/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.entity.construct;

import com.google.common.collect.Lists;
import electroblob.wizardry.Wizardry;
import electroblob.wizardry.entity.construct.EntityScaledConstruct;
import electroblob.wizardry.registry.Spells;
import electroblob.wizardry.registry.WizardrySounds;
import electroblob.wizardry.util.BlockUtils;
import electroblob.wizardry.util.EntityUtils;
import electroblob.wizardry.util.MagicDamage;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class EntityBoulder
extends EntityScaledConstruct {
    private double velX;
    private double velZ;
    private int hitsRemaining;
    private boolean soundStarted = false;

    public EntityBoulder(World world) {
        super(world);
        this.func_70105_a(2.375f, 2.375f);
        this.field_70145_X = false;
        this.func_189654_d(false);
        this.field_70138_W = 1.0f;
        this.hitsRemaining = 5;
    }

    public void setHorizontalVelocity(double velX, double velZ) {
        this.velX = velX;
        this.velZ = velZ;
    }

    @Override
    public void func_70071_h_() {
        EntityLivingBase entity;
        if (this.field_70170_p.field_72995_K && !this.soundStarted && this.field_70122_E) {
            this.soundStarted = true;
            Wizardry.proxy.playMovingSound(this, WizardrySounds.ENTITY_BOULDER_ROLL, WizardrySounds.SPELLS, 1.0f, 1.0f, true);
        }
        super.func_70071_h_();
        this.field_70181_x -= (double)0.04f;
        this.func_70091_d(MoverType.SELF, this.velX, this.field_70181_x, this.velZ);
        List collided = this.field_70170_p.func_72872_a(EntityLivingBase.class, this.func_174813_aQ());
        float damage = Spells.boulder.getProperty("damage").floatValue() * this.damageMultiplier;
        float knockback = Spells.boulder.getProperty("knockback_strength").floatValue();
        Iterator iterator = collided.iterator();
        while (iterator.hasNext() && this.isValidTarget((Entity)(entity = (EntityLivingBase)iterator.next()))) {
            boolean crushBonus = entity.field_70163_u < this.field_70163_u && entity.func_174813_aQ().field_72340_a > this.func_174813_aQ().field_72340_a && entity.func_174813_aQ().field_72336_d < this.func_174813_aQ().field_72336_d && entity.func_174813_aQ().field_72339_c > this.func_174813_aQ().field_72339_c && entity.func_174813_aQ().field_72334_f < this.func_174813_aQ().field_72334_f;
            if (EntityUtils.attackEntityWithoutKnockback((Entity)entity, MagicDamage.causeIndirectMagicDamage(this, (Entity)this.getCaster(), MagicDamage.DamageType.MAGIC), crushBonus ? damage * 1.5f : damage) && !crushBonus) {
                EntityUtils.applyStandardKnockback(this, entity, knockback);
                entity.field_70159_w += this.field_70159_w;
                entity.field_70179_y += this.field_70179_y;
            }
            entity.func_184185_a(WizardrySounds.ENTITY_BOULDER_HIT, 1.0f, 1.0f);
        }
        if (EntityUtils.canDamageBlocks((Entity)this.getCaster(), this.field_70170_p) && this.field_70123_F) {
            AxisAlignedBB box = this.func_174813_aQ().func_72317_d(this.velX, 0.0, this.velZ);
            ArrayList cuboid = Lists.newArrayList((Iterable)BlockPos.func_191532_a((int)MathHelper.func_76128_c((double)box.field_72340_a), (int)MathHelper.func_76128_c((double)box.field_72338_b), (int)MathHelper.func_76128_c((double)box.field_72339_c), (int)MathHelper.func_76128_c((double)box.field_72336_d), (int)MathHelper.func_76128_c((double)box.field_72337_e), (int)MathHelper.func_76128_c((double)box.field_72334_f)));
            this.smashBlocks(cuboid, true);
        }
        for (int i = 0; i < 10; ++i) {
            double particleX = this.field_70165_t + (double)this.field_70130_N * 0.7 * (this.field_70146_Z.nextDouble() - 0.5);
            double particleZ = this.field_70161_v + (double)this.field_70130_N * 0.7 * (this.field_70146_Z.nextDouble() - 0.5);
            IBlockState block = this.field_70170_p.func_180495_p(new BlockPos((Entity)this).func_177977_b());
            if (block.func_177230_c() == Blocks.field_150350_a) continue;
            this.field_70170_p.func_175688_a(EnumParticleTypes.BLOCK_DUST, particleX, this.field_70163_u, particleZ, 0.0, 0.2, 0.0, new int[]{Block.func_176210_f((IBlockState)block)});
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean smashBlocks(List<BlockPos> blocks, boolean breakIfTooHard) {
        if (blocks.removeIf(p -> this.field_70170_p.func_180495_p(p).func_177230_c().getExplosionResistance(this.field_70170_p, p, (Entity)this, null) > 3.0f || !this.field_70170_p.field_72995_K && !BlockUtils.canBreakBlock((Entity)this.getCaster(), this.field_70170_p, p))) {
            if (!breakIfTooHard) return false;
            this.despawn();
        } else if (!this.field_70170_p.field_72995_K) {
            blocks.forEach(p -> this.field_70170_p.func_175655_b(p, false));
            if (--this.hitsRemaining <= 0) {
                this.despawn();
            }
        } else {
            this.field_70170_p.func_184134_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, WizardrySounds.ENTITY_BOULDER_BREAK_BLOCK, SoundCategory.BLOCKS, 1.0f, 1.0f, false);
        }
        this.shakeNearbyPlayers();
        return true;
    }

    private void shakeNearbyPlayers() {
        EntityUtils.getEntitiesWithinRadius(10.0, this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70170_p, EntityPlayer.class).forEach(p -> Wizardry.proxy.shakeScreen((EntityPlayer)p, 8.0f));
    }

    @Override
    public void despawn() {
        if (this.field_70170_p.field_72995_K) {
            for (int i = 0; i < 200; ++i) {
                double x = this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N;
                double y = this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O;
                double z = this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N;
                this.field_70170_p.func_175688_a(EnumParticleTypes.BLOCK_DUST, x, y, z, (x - this.field_70165_t) * 0.1, (y - this.field_70163_u + (double)(this.field_70131_O / 2.0f)) * 0.1, (z - this.field_70161_v) * 0.1, new int[]{Block.func_176210_f((IBlockState)Blocks.field_150346_d.func_176223_P())});
            }
            this.field_70170_p.func_184134_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, WizardrySounds.ENTITY_BOULDER_BREAK_BLOCK, SoundCategory.BLOCKS, 1.0f, 1.0f, false);
        }
        super.despawn();
    }

    public void func_70091_d(MoverType type, double x, double y, double z) {
        super.func_70091_d(type, x, y, z);
        this.field_70125_A = (float)((double)this.field_70125_A + Math.toDegrees(MathHelper.func_76133_a((double)(x * x + y * y + z * z)) / (this.field_70130_N / 2.0f)));
    }

    public void func_180430_e(float distance, float damageMultiplier) {
        super.func_180430_e(distance, damageMultiplier);
        if (EntityUtils.canDamageBlocks((Entity)this.getCaster(), this.field_70170_p) && distance > 3.0f) {
            AxisAlignedBB box = this.func_174813_aQ().func_72317_d(this.velX, this.field_70181_x, this.velZ);
            ArrayList cuboid = Lists.newArrayList((Iterable)BlockPos.func_191532_a((int)MathHelper.func_76128_c((double)box.field_72340_a), (int)MathHelper.func_76128_c((double)box.field_72338_b), (int)MathHelper.func_76128_c((double)box.field_72339_c), (int)MathHelper.func_76128_c((double)box.field_72336_d), (int)MathHelper.func_76128_c((double)box.field_72337_e), (int)MathHelper.func_76128_c((double)box.field_72334_f)));
            if (this.smashBlocks(cuboid, distance > 8.0f)) {
                return;
            }
            --this.hitsRemaining;
        }
        if (this.field_70170_p.field_72995_K) {
            for (int i = 0; i < 40; ++i) {
                double particleX = this.field_70165_t - 1.5 + 3.0 * this.field_70146_Z.nextDouble();
                double particleZ = this.field_70161_v - 1.5 + 3.0 * this.field_70146_Z.nextDouble();
                IBlockState block = this.field_70170_p.func_180495_p(new BlockPos(this.field_70165_t, this.field_70163_u - 2.0, this.field_70161_v));
                if (block.func_177230_c() == Blocks.field_150350_a) continue;
                this.field_70170_p.func_175688_a(EnumParticleTypes.BLOCK_DUST, particleX, this.field_70163_u, particleZ, particleX - this.field_70165_t, 0.0, particleZ - this.field_70161_v, new int[]{Block.func_176210_f((IBlockState)block)});
            }
            if ((double)distance > 1.2) {
                this.field_70170_p.func_184134_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, WizardrySounds.ENTITY_BOULDER_LAND, SoundCategory.BLOCKS, Math.min(2.0f, distance / 4.0f), 1.0f, false);
                this.shakeNearbyPlayers();
            }
        }
    }

    public boolean func_70067_L() {
        return true;
    }

    public AxisAlignedBB func_70046_E() {
        return this.func_174813_aQ();
    }

    @Override
    protected void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.velX = nbt.func_74769_h("velX");
        this.velZ = nbt.func_74769_h("velZ");
        this.hitsRemaining = nbt.func_74762_e("hitsRemaining");
    }

    @Override
    protected void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74780_a("velX", this.velX);
        nbt.func_74780_a("velZ", this.velZ);
        nbt.func_74768_a("hitsRemaining", this.hitsRemaining);
    }

    @Override
    public void writeSpawnData(ByteBuf data) {
        super.writeSpawnData(data);
        data.writeDouble(this.velX);
        data.writeDouble(this.velZ);
    }

    @Override
    public void readSpawnData(ByteBuf data) {
        super.readSpawnData(data);
        this.velX = data.readDouble();
        this.velZ = data.readDouble();
    }
}

