/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.entity.construct;

import electroblob.wizardry.Wizardry;
import electroblob.wizardry.item.ISpellCastingItem;
import electroblob.wizardry.registry.WizardrySounds;
import electroblob.wizardry.util.AllyDesignationSystem;
import electroblob.wizardry.util.EntityUtils;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityOwnable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class EntityMagicConstruct
extends Entity
implements IEntityOwnable,
IEntityAdditionalSpawnData {
    private UUID casterUUID;
    public int lifetime = 600;
    public float damageMultiplier = 1.0f;

    public EntityMagicConstruct(World world) {
        super(world);
        this.field_70131_O = 1.0f;
        this.field_70130_N = 1.0f;
        this.field_70145_X = true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180426_a(double x, double y, double z, float yaw, float pitch, int posRotationIncrements, boolean teleport) {
        this.func_70107_b(x, y, z);
        this.func_70101_b(yaw, pitch);
    }

    public void func_70071_h_() {
        if (this.field_70173_aa > this.lifetime && this.lifetime != -1) {
            this.despawn();
        }
        super.func_70071_h_();
    }

    public EnumActionResult func_184199_a(EntityPlayer player, Vec3d vec, EnumHand hand) {
        if (this.lifetime == -1 && this.getCaster() == player && player.func_70093_af() && player.func_184586_b(hand).func_77973_b() instanceof ISpellCastingItem) {
            this.despawn();
            return EnumActionResult.SUCCESS;
        }
        return super.func_184199_a(player, vec, hand);
    }

    public void despawn() {
        this.func_70106_y();
    }

    protected void func_70088_a() {
    }

    protected void func_70037_a(NBTTagCompound nbttagcompound) {
        if (nbttagcompound.func_186855_b("casterUUID")) {
            this.casterUUID = nbttagcompound.func_186857_a("casterUUID");
        }
        this.lifetime = nbttagcompound.func_74762_e("lifetime");
        this.damageMultiplier = nbttagcompound.func_74760_g("damageMultiplier");
    }

    protected void func_70014_b(NBTTagCompound nbttagcompound) {
        if (this.casterUUID != null) {
            nbttagcompound.func_186854_a("casterUUID", this.casterUUID);
        }
        nbttagcompound.func_74768_a("lifetime", this.lifetime);
        nbttagcompound.func_74776_a("damageMultiplier", this.damageMultiplier);
    }

    public void writeSpawnData(ByteBuf data) {
        data.writeInt(this.lifetime);
        data.writeInt(this.getCaster() == null ? -1 : this.getCaster().func_145782_y());
    }

    public void readSpawnData(ByteBuf data) {
        this.lifetime = data.readInt();
        int id = data.readInt();
        if (id == -1) {
            this.setCaster(null);
        } else {
            Entity entity = this.field_70170_p.func_73045_a(id);
            if (entity instanceof EntityLivingBase) {
                this.setCaster((EntityLivingBase)entity);
            } else {
                Wizardry.logger.warn("Construct caster with ID in spawn data not found");
            }
        }
    }

    @Nullable
    public UUID func_184753_b() {
        return this.casterUUID;
    }

    @Nullable
    public Entity func_70902_q() {
        return this.getCaster();
    }

    @Nullable
    public EntityLivingBase getCaster() {
        Entity entity = EntityUtils.getEntityByUUID(this.field_70170_p, this.func_184753_b());
        if (entity != null && !(entity instanceof EntityLivingBase)) {
            Wizardry.logger.warn("{} has a non-living owner!", (Object)this);
            entity = null;
        }
        return (EntityLivingBase)entity;
    }

    public void setCaster(@Nullable EntityLivingBase caster) {
        this.casterUUID = caster == null ? null : caster.func_110124_au();
    }

    public boolean isValidTarget(Entity target) {
        return AllyDesignationSystem.isValidTarget((Entity)this.getCaster(), target);
    }

    public SoundCategory func_184176_by() {
        return WizardrySounds.SPELLS;
    }

    public boolean func_90999_ad() {
        return false;
    }

    public boolean func_96092_aw() {
        return false;
    }
}

