/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.integration;

import com.google.common.collect.ImmutableSet;
import electroblob.wizardry.Wizardry;
import electroblob.wizardry.util.EntityUtils;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.util.DamageSource;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

@Mod.EventBusSubscriber
public final class DamageSafetyChecker {
    private static final Set<String> VANILLA_DAMAGE_NAMES = ImmutableSet.of((Object)"inFire", (Object)"lightningBolt", (Object)"onFire", (Object)"lava", (Object)"hotFloor", (Object)"inWall", (Object[])new String[]{"cramming", "drown", "starve", "cactus", "fall", "flyIntoWall", "outOfWorld", "generic", "magic", "wither", "anvil", "fallingBlock", "dragonBreath", "fireworks", "mob", "player", "arrow", "thrown", "indirectMagic", "thorns", "explosion", "explosion.player"});
    private static int attacksThisTick = 0;
    private static final int EXCESSIVE_CALL_THRESHOLD = 15;
    private static final int EXCESSIVE_CALL_LIMIT = 25;

    public static boolean attackEntitySafely(Entity target, DamageSource source, float damage, String originalSourceName, DamageSource fallback, boolean knockback) {
        for (String sourceName : Wizardry.settings.damageSourceBlacklist) {
            if (!originalSourceName.equals(sourceName)) continue;
            ++attacksThisTick;
            return knockback ? target.func_70097_a(fallback, damage) : EntityUtils.attackEntityWithoutKnockback(target, fallback, damage);
        }
        if (attacksThisTick > 25 * target.field_70170_p.field_72996_f.size()) {
            DamageSafetyChecker.logInterception(originalSourceName, true);
            return false;
        }
        if (attacksThisTick > 15 * target.field_70170_p.field_72996_f.size()) {
            DamageSafetyChecker.logInterception(originalSourceName, false);
            ++attacksThisTick;
            return knockback ? target.func_70097_a(fallback, damage) : EntityUtils.attackEntityWithoutKnockback(target, fallback, damage);
        }
        ++attacksThisTick;
        return knockback ? target.func_70097_a(source, damage) : EntityUtils.attackEntityWithoutKnockback(target, source, damage);
    }

    public static boolean attackEntitySafely(Entity target, DamageSource source, float damage, DamageSource originalSource, boolean knockback) {
        return DamageSafetyChecker.attackEntitySafely(target, source, damage, originalSource.func_76355_l(), originalSource, knockback);
    }

    public static boolean attackEntitySafely(Entity target, DamageSource source, float damage, String originalSourceName) {
        return DamageSafetyChecker.attackEntitySafely(target, source, damage, originalSourceName, DamageSource.field_76376_m, true);
    }

    private static void logInterception(String originalSourceName, boolean aborted) {
        if (!Wizardry.settings.compatibilityWarnings) {
            return;
        }
        boolean vanillaName = VANILLA_DAMAGE_NAMES.contains(originalSourceName);
        if (aborted) {
            Wizardry.logger.warn("Entity attack excessive call limit reached, aborting entity damage entirely!");
        } else {
            Wizardry.logger.warn("Entity attack excessive call threshold reached, substituting for non-entity-based damage to avert a crash.");
        }
        if (vanillaName) {
            Wizardry.logger.info("The damage source in question had a vanilla identifier. If you know which mod may have caused this, consider asking the author to add a custom identifier so it may be blacklisted. You can turn this warning off using the compatibilityWarnings config option. Please do not report it to wizardry's author.");
        } else {
            Wizardry.logger.info("To prevent this message and improve efficiency, add \"" + originalSourceName + "\" (without quotes) to the damage source blacklist in the config. Please do not report this warning unless you have added the damage source to the blacklist already.");
        }
    }

    @SubscribeEvent
    public static void tick(TickEvent event) {
        if (event.phase == TickEvent.Phase.START && event.type == TickEvent.Type.WORLD) {
            attacksThisTick = 0;
        }
    }
}

