/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.packet;

import electroblob.wizardry.Wizardry;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.tileentity.TileEntityLectern;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketLectern
implements IMessageHandler<Message, IMessage> {
    public IMessage onMessage(Message message, MessageContext ctx) {
        if (ctx.side.isServer()) {
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            player.func_71121_q().func_152344_a(() -> {
                TileEntity tileentity = player.field_70170_p.func_175625_s(message.pos);
                if (tileentity instanceof TileEntityLectern) {
                    ((TileEntityLectern)tileentity).currentSpell = message.spell;
                    ((TileEntityLectern)tileentity).sync();
                } else {
                    Wizardry.logger.warn("Received a PacketLectern, but no lectern existed at the position specified!");
                }
            });
        }
        return null;
    }

    public static class Message
    implements IMessage {
        private BlockPos pos;
        private Spell spell;

        public Message() {
        }

        public Message(BlockPos pos, Spell spell) {
            this.pos = pos;
            this.spell = spell;
        }

        public void fromBytes(ByteBuf buf) {
            this.pos = new BlockPos(buf.readInt(), buf.readInt(), buf.readInt());
            this.spell = Spell.byNetworkID(buf.readInt());
        }

        public void toBytes(ByteBuf buf) {
            buf.writeInt(this.pos.func_177958_n());
            buf.writeInt(this.pos.func_177956_o());
            buf.writeInt(this.pos.func_177952_p());
            buf.writeInt(this.spell.networkID());
        }
    }
}

