/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.potion;

import electroblob.wizardry.potion.PotionMagicEffect;
import electroblob.wizardry.registry.WizardryPotions;
import electroblob.wizardry.registry.WizardrySounds;
import electroblob.wizardry.util.EntityUtils;
import electroblob.wizardry.util.GeometryUtils;
import electroblob.wizardry.util.NBTExtras;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.potion.Potion;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber
public class PotionContainment
extends PotionMagicEffect {
    public static final String ENTITY_TAG = "containmentPos";

    public PotionContainment(boolean isBadEffect, int liquidColour) {
        super(isBadEffect, liquidColour, new ResourceLocation("ebwizardry", "textures/gui/potion_icons/containment.png"));
        this.func_76390_b("potion.ebwizardry:containment");
    }

    public boolean func_76397_a(int duration, int amplifier) {
        return true;
    }

    public static float getContainmentDistance(int effectStrength) {
        return 15 - effectStrength * 4;
    }

    @Override
    public void func_76394_a(EntityLivingBase target, int strength) {
        float maxDistance = PotionContainment.getContainmentDistance(strength);
        if (!target.getEntityData().func_74764_b(ENTITY_TAG)) {
            NBTExtras.storeTagSafely(target.getEntityData(), ENTITY_TAG, (NBTBase)NBTUtil.func_186859_a((BlockPos)new BlockPos(target.func_174791_d().func_178786_a(0.5, 0.5, 0.5))));
        }
        Vec3d origin = GeometryUtils.getCentre(NBTUtil.func_186861_c((NBTTagCompound)target.getEntityData().func_74775_l(ENTITY_TAG)));
        double x = target.field_70165_t;
        double y = target.field_70163_u;
        double z = target.field_70161_v;
        if (target.func_174813_aQ().field_72336_d > origin.field_72450_a + (double)maxDistance) {
            x = origin.field_72450_a + (double)maxDistance - (double)(target.field_70130_N / 2.0f);
        }
        if (target.func_174813_aQ().field_72340_a < origin.field_72450_a - (double)maxDistance) {
            x = origin.field_72450_a - (double)maxDistance + (double)(target.field_70130_N / 2.0f);
        }
        if (target.func_174813_aQ().field_72337_e > origin.field_72448_b + (double)maxDistance) {
            y = origin.field_72448_b + (double)maxDistance - (double)target.field_70131_O;
        }
        if (target.func_174813_aQ().field_72338_b < origin.field_72448_b - (double)maxDistance) {
            y = origin.field_72448_b - (double)maxDistance;
        }
        if (target.func_174813_aQ().field_72334_f > origin.field_72449_c + (double)maxDistance) {
            z = origin.field_72449_c + (double)maxDistance - (double)(target.field_70130_N / 2.0f);
        }
        if (target.func_174813_aQ().field_72339_c < origin.field_72449_c - (double)maxDistance) {
            z = origin.field_72449_c - (double)maxDistance + (double)(target.field_70130_N / 2.0f);
        }
        if (x != target.field_70165_t || y != target.field_70163_u || z != target.field_70161_v) {
            target.func_70024_g(0.15 * Math.signum(x - target.field_70165_t), 0.15 * Math.signum(y - target.field_70163_u), 0.15 * Math.signum(z - target.field_70161_v));
            EntityUtils.undoGravity((Entity)target);
            if (target.field_70170_p.field_72995_K) {
                target.field_70170_p.func_184134_a(target.field_70165_t, target.field_70163_u, target.field_70161_v, WizardrySounds.ENTITY_FORCEFIELD_DEFLECT, WizardrySounds.SPELLS, 0.3f, 1.0f, false);
            }
        }
        if (target.func_70660_b((Potion)this).func_76459_b() <= 1) {
            target.getEntityData().func_82580_o(ENTITY_TAG);
        }
    }

    @SubscribeEvent
    public static void onLivingUpdateEvent(LivingEvent.LivingUpdateEvent event) {
        if (event.getEntity().field_70173_aa % 20 == 0 && event.getEntityLiving().getEntityData().func_74764_b(ENTITY_TAG) && !event.getEntityLiving().func_70644_a(WizardryPotions.containment)) {
            event.getEntityLiving().getEntityData().func_82580_o(ENTITY_TAG);
        }
    }
}

