/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.spell;

import electroblob.wizardry.Wizardry;
import electroblob.wizardry.item.SpellActions;
import electroblob.wizardry.spell.SpellRay;
import electroblob.wizardry.util.AllyDesignationSystem;
import electroblob.wizardry.util.BlockUtils;
import electroblob.wizardry.util.EntityUtils;
import electroblob.wizardry.util.NBTExtras;
import electroblob.wizardry.util.SpellModifiers;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityDispenser;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingDestroyBlockEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.ExplosionEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber
public class ArcaneLock
extends SpellRay {
    public static final String NBT_KEY = "arcaneLockOwner";

    public ArcaneLock() {
        super("arcane_lock", SpellActions.POINT, false);
    }

    @Override
    public boolean requiresPacket() {
        return true;
    }

    @Override
    public boolean canBeCastBy(TileEntityDispenser dispenser) {
        return false;
    }

    @Override
    public boolean canBeCastBy(EntityLiving npc, boolean override) {
        return false;
    }

    @Override
    protected boolean onEntityHit(World world, Entity target, Vec3d hit, EntityLivingBase caster, Vec3d origin, int ticksInUse, SpellModifiers modifiers) {
        return false;
    }

    @Override
    protected boolean onBlockHit(World world, BlockPos pos, EnumFacing side, Vec3d hit, EntityLivingBase caster, Vec3d origin, int ticksInUse, SpellModifiers modifiers) {
        if (caster instanceof EntityPlayer && !world.field_72995_K && this.toggleLock(world, pos, (EntityPlayer)caster)) {
            BlockPos otherHalf = BlockUtils.getConnectedChest(world, pos);
            if (otherHalf != null) {
                this.toggleLock(world, otherHalf, (EntityPlayer)caster);
            }
            return true;
        }
        return false;
    }

    private boolean toggleLock(World world, BlockPos pos, EntityPlayer player) {
        TileEntity tileentity = world.func_175625_s(pos);
        if (tileentity != null) {
            if (tileentity.getTileData().func_186855_b(NBT_KEY)) {
                if (world.func_152378_a(tileentity.getTileData().func_186857_a(NBT_KEY)) == player) {
                    NBTExtras.removeUniqueId(tileentity.getTileData(), NBT_KEY);
                    world.markAndNotifyBlock(pos, null, world.func_180495_p(pos), world.func_180495_p(pos), 3);
                    return true;
                }
            } else {
                tileentity.getTileData().func_186854_a(NBT_KEY, player.func_110124_au());
                world.markAndNotifyBlock(pos, null, world.func_180495_p(pos), world.func_180495_p(pos), 3);
                return true;
            }
        }
        return false;
    }

    @Override
    protected boolean onMiss(World world, EntityLivingBase caster, Vec3d origin, Vec3d direction, int ticksInUse, SpellModifiers modifiers) {
        return false;
    }

    @SubscribeEvent
    public static void onRightClickBlockEvent(PlayerInteractEvent.RightClickBlock event) {
        EntityPlayer owner;
        TileEntity tileentity;
        if (!ArcaneLock.canBypassLocks(event.getEntityPlayer()) && (tileentity = event.getWorld().func_175625_s(event.getPos())) != null && tileentity.getTileData().func_186855_b(NBT_KEY) && ((owner = event.getWorld().func_152378_a(tileentity.getTileData().func_186857_a(NBT_KEY))) == null || owner != event.getEntityPlayer() && !AllyDesignationSystem.isPlayerAlly(owner, event.getEntityPlayer()))) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onLeftClickBlockEvent(PlayerInteractEvent.LeftClickBlock event) {
        event.setCanceled(ArcaneLock.checkForLockedBlockBreak((EntityLivingBase)event.getEntityPlayer(), event.getWorld(), event.getPos()));
    }

    @SubscribeEvent
    public static void onBlockBreakEvent(BlockEvent.BreakEvent event) {
        event.setCanceled(ArcaneLock.checkForLockedBlockBreak((EntityLivingBase)event.getPlayer(), event.getWorld(), event.getPos()));
    }

    @SubscribeEvent
    public static void onLivingDestroyBlockEvent(LivingDestroyBlockEvent event) {
        event.setCanceled(ArcaneLock.checkForLockedBlockBreak(event.getEntityLiving(), event.getEntity().field_70170_p, event.getPos()));
    }

    private static boolean checkForLockedBlockBreak(EntityLivingBase breaker, World world, BlockPos pos) {
        TileEntity tileentity;
        return (!(breaker instanceof EntityPlayer) || !ArcaneLock.canBypassLocks((EntityPlayer)breaker)) && (tileentity = world.func_175625_s(pos)) != null && tileentity.getTileData().func_186855_b(NBT_KEY) && breaker.func_110124_au() != tileentity.getTileData().func_186857_a(NBT_KEY);
    }

    private static boolean canBypassLocks(EntityPlayer player) {
        if (!player.func_184812_l_()) {
            return false;
        }
        if (Wizardry.settings.creativeBypassesArcaneLock) {
            return true;
        }
        MinecraftServer server = player.field_70170_p.func_73046_m();
        return server != null && EntityUtils.isPlayerOp(player, server);
    }

    @SubscribeEvent
    public static void onExplosionEvent(ExplosionEvent.Detonate event) {
        event.getAffectedBlocks().removeIf(pos -> event.getWorld().func_175625_s(pos) != null && event.getWorld().func_175625_s(pos).getTileData().func_186855_b(NBT_KEY));
    }
}

