/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.spell;

import electroblob.wizardry.Wizardry;
import electroblob.wizardry.item.SpellActions;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.spell.SpellAreaEffect;
import electroblob.wizardry.spell.SpellBuff;
import electroblob.wizardry.util.ParticleBuilder;
import electroblob.wizardry.util.SpellModifiers;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.MobEffects;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class InvigoratingPresence
extends SpellAreaEffect {
    public InvigoratingPresence() {
        super("invigorating_presence", SpellActions.POINT_UP, false);
        this.soundValues(0.7f, 1.2f, 0.4f);
        this.alwaysSucceed(true);
        this.targetAllies(true);
        this.addProperties("effect_duration", "effect_strength");
    }

    @Override
    protected boolean affectEntity(World world, Vec3d origin, @Nullable EntityLivingBase caster, EntityLivingBase target, int targetCount, int ticksInUse, SpellModifiers modifiers) {
        int bonusAmplifier = SpellBuff.getStandardBonusAmplifier(modifiers.get("potency"));
        target.func_70690_d(new PotionEffect(MobEffects.field_76420_g, (int)(this.getProperty("effect_duration").floatValue() * modifiers.get(WizardryItems.duration_upgrade)), this.getProperty("effect_strength").intValue() + bonusAmplifier));
        return true;
    }

    @Override
    protected void spawnParticle(World world, double x, double y, double z) {
        ParticleBuilder.create(ParticleBuilder.Type.SPARKLE).pos(x, y, z).vel(0.0, 0.03, 0.0).time(50).clr(1.0f, 0.2f, 0.2f).spawn(world);
    }

    @Override
    protected String getTranslationKey() {
        return Wizardry.tisTheSeason ? super.getTranslationKey() + "_festive" : super.getTranslationKey();
    }
}

