/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.spell;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Multimap;
import electroblob.wizardry.Wizardry;
import electroblob.wizardry.data.IVariable;
import electroblob.wizardry.data.Persistence;
import electroblob.wizardry.data.WizardData;
import electroblob.wizardry.entity.living.EntityDecoy;
import electroblob.wizardry.entity.living.EntityIceWraith;
import electroblob.wizardry.entity.living.EntityLightningWraith;
import electroblob.wizardry.entity.living.EntityShadowWraith;
import electroblob.wizardry.entity.living.EntityStormElemental;
import electroblob.wizardry.entity.living.EntityStrayMinion;
import electroblob.wizardry.entity.projectile.EntityDarknessOrb;
import electroblob.wizardry.entity.projectile.EntityIceShard;
import electroblob.wizardry.entity.projectile.EntityLargeMagicFireball;
import electroblob.wizardry.entity.projectile.EntityLightningDisc;
import electroblob.wizardry.entity.projectile.EntityMagicArrow;
import electroblob.wizardry.entity.projectile.EntityMagicFireball;
import electroblob.wizardry.entity.projectile.EntityMagicProjectile;
import electroblob.wizardry.integration.DamageSafetyChecker;
import electroblob.wizardry.item.SpellActions;
import electroblob.wizardry.packet.PacketControlInput;
import electroblob.wizardry.packet.PacketPossession;
import electroblob.wizardry.packet.WizardryPacketHandler;
import electroblob.wizardry.potion.PotionSlowTime;
import electroblob.wizardry.registry.Spells;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.spell.SpellRay;
import electroblob.wizardry.util.EntityUtils;
import electroblob.wizardry.util.NBTExtras;
import electroblob.wizardry.util.ParticleBuilder;
import electroblob.wizardry.util.SpellModifiers;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.monster.EntityBlaze;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntityGhast;
import net.minecraft.entity.monster.EntitySnowman;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.monster.EntityStray;
import net.minecraft.entity.monster.EntityWitch;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityFlying;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityPotion;
import net.minecraft.entity.projectile.EntitySnowball;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.init.PotionTypes;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraft.tileentity.TileEntityDispenser;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

@Mod.EventBusSubscriber
public class Possession
extends SpellRay {
    public static final ResourceLocation SHADER = new ResourceLocation("ebwizardry", "shaders/post/possession.json");
    public static final String NBT_KEY = "possessed";
    public static final String INVENTORY_NBT_KEY = "prevInventory";
    public static final String CRITICAL_HEALTH = "critical_health";
    private static final int PROJECTILE_COOLDOWN = 30;
    public static final IVariable<Integer> TIMER_KEY = new IVariable.Variable<Integer>(Persistence.DIMENSION_CHANGE).withTicker(Possession::update);
    public static final IVariable<EntityLiving> POSSESSEE_KEY = new IVariable.Variable<EntityLiving>(Persistence.DIMENSION_CHANGE);
    public static final IVariable<Integer> SHOOT_COOLDOWN_KEY = new IVariable.Variable<Integer>(Persistence.DIMENSION_CHANGE).withTicker((p, n) -> Math.max(n - 1, 0));
    private static final Multimap<Class<? extends EntityLiving>, BiConsumer<?, EntityPlayer>> abilities = HashMultimap.create();
    private static final Map<Class<? extends EntityLiving>, Function<World, ? extends IProjectile>> projectiles = new HashMap<Class<? extends EntityLiving>, Function<World, ? extends IProjectile>>();
    private static final Set<Class<? extends EntityLiving>> blacklist = new HashSet<Class<? extends EntityLiving>>();
    private static final Map<IAttribute, UUID> INHERITED_ATTRIBUTES = ImmutableMap.of((Object)SharedMonsterAttributes.field_111263_d, (Object)UUID.fromString("f65cfcaf-e7ec-4dfb-aa6c-711735d007e3"), (Object)SharedMonsterAttributes.field_111264_e, (Object)UUID.fromString("ab67c89e-74a5-4e27-9621-40bffb4f7a03"), (Object)SharedMonsterAttributes.field_111266_c, (Object)UUID.fromString("05529535-9bcf-42bb-8822-45f5ce6a8f08"));

    public Possession() {
        super("possession", SpellActions.POINT, false);
        this.addProperties("effect_duration", CRITICAL_HEALTH);
    }

    @Override
    public boolean canBeCastBy(EntityLiving npc, boolean override) {
        return false;
    }

    @Override
    public boolean canBeCastBy(TileEntityDispenser dispenser) {
        return false;
    }

    @Override
    public boolean requiresPacket() {
        return false;
    }

    @Override
    protected SoundEvent[] createSounds() {
        return this.createSoundsWithSuffixes("possess", "end");
    }

    @Override
    public boolean cast(World world, EntityPlayer caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        Vec3d look = caster.func_70040_Z();
        Vec3d origin = new Vec3d(caster.field_70165_t, caster.field_70163_u + (double)caster.func_70047_e() - 0.25, caster.field_70161_v);
        if (!this.shootSpell(world, origin, look, (EntityLivingBase)caster, ticksInUse, modifiers)) {
            return false;
        }
        this.playSound(world, (EntityLivingBase)caster, ticksInUse, -1, modifiers, "possess");
        return true;
    }

    @Override
    protected boolean onEntityHit(World world, Entity target, Vec3d hit, EntityLivingBase caster, Vec3d origin, int ticksInUse, SpellModifiers modifiers) {
        if (target instanceof EntityLiving && !blacklist.contains(target.getClass()) && caster instanceof EntityPlayer && !Possession.isPossessing((EntityPlayer)caster)) {
            int duration;
            EntityPlayer player = (EntityPlayer)caster;
            if (!player.func_184812_l_() && player.func_110143_aJ() <= this.getProperty(CRITICAL_HEALTH).floatValue()) {
                player.func_146105_b((ITextComponent)new TextComponentTranslation("spell." + this.getRegistryName() + ".insufficienthealth", new Object[0]), true);
                return false;
            }
            if (!world.field_72995_K && this.possess(player, (EntityLiving)target, duration = (int)(this.getProperty("effect_duration").floatValue() * modifiers.get(WizardryItems.duration_upgrade)))) {
                return true;
            }
        }
        return false;
    }

    @Override
    protected boolean onBlockHit(World world, BlockPos pos, EnumFacing side, Vec3d hit, EntityLivingBase caster, Vec3d origin, int ticksInUse, SpellModifiers modifiers) {
        return false;
    }

    @Override
    protected boolean onMiss(World world, EntityLivingBase caster, Vec3d origin, Vec3d direction, int ticksInUse, SpellModifiers modifiers) {
        return false;
    }

    public boolean possess(EntityPlayer possessor, EntityLiving target, int duration) {
        if (possessor.func_70093_af()) {
            return false;
        }
        if (WizardData.get(possessor) != null) {
            WizardData.get(possessor).setVariable(POSSESSEE_KEY, target);
            WizardData.get(possessor).setVariable(TIMER_KEY, duration);
            possessor.func_70080_a(target.field_70165_t, target.field_70163_u, target.field_70161_v, target.field_70177_z, target.field_70125_A);
            possessor.eyeHeight = target.func_70047_e();
            Possession.setSize((Entity)possessor, target.field_70130_N, target.field_70131_O);
            target.func_184210_p();
            target.func_70106_y();
            target.func_94061_f(true);
            target.func_70624_b(null);
            target.getEntityData().func_74757_a(NBT_KEY, true);
            if (target instanceof net.minecraft.entity.EntityFlying || target instanceof EntityFlying) {
                possessor.field_71075_bZ.field_75101_c = true;
                possessor.field_71075_bZ.field_75100_b = true;
            }
            block0: for (IAttribute attribute : INHERITED_ATTRIBUTES.keySet()) {
                IAttributeInstance instance = target.func_110140_aT().func_111151_a(attribute);
                if (instance == null) continue;
                double targetValue = instance.func_111126_e();
                double currentValue = possessor.func_110140_aT().func_111151_a(attribute).func_111126_e();
                if (attribute == SharedMonsterAttributes.field_111263_d) {
                    currentValue /= (double)possessor.field_71075_bZ.func_75094_b();
                }
                for (EntityEquipmentSlot slot : EntityEquipmentSlot.values()) {
                    if (target.func_184582_a(slot).func_111283_C(slot).containsKey((Object)attribute.func_111108_a())) continue block0;
                }
                possessor.func_110140_aT().func_111151_a(attribute).func_111121_a(new AttributeModifier(INHERITED_ATTRIBUTES.get(attribute), "possessionModifier", targetValue / currentValue, 1));
            }
            if (possessor.field_70170_p.field_72995_K) {
                Wizardry.proxy.loadShader(possessor, SHADER);
                Wizardry.proxy.playBlinkEffect(possessor);
            } else {
                for (EntityLiving creature : EntityUtils.getEntitiesWithinRadius(16.0, possessor.field_70165_t, possessor.field_70163_u, possessor.field_70161_v, possessor.field_70170_p, EntityLiving.class)) {
                    if (creature.func_70638_az() != possessor || creature.func_70686_a(target.getClass())) continue;
                    creature.func_70624_b(null);
                }
                if (possessor.getEntityData() != null) {
                    NBTExtras.storeTagSafely(possessor.getEntityData(), INVENTORY_NBT_KEY, (NBTBase)possessor.field_71071_by.func_70442_a(new NBTTagList()));
                }
                possessor.field_71071_by.func_174888_l();
                possessor.field_71069_bz.func_75142_b();
                ItemStack stack = target.func_184614_ca().func_77946_l();
                if (target instanceof EntityEnderman && ((EntityEnderman)target).func_175489_ck() != null) {
                    stack = new ItemStack(((EntityEnderman)target).func_175489_ck().func_177230_c());
                } else if (stack.func_77973_b() instanceof ItemBow) {
                    Map enchantments = EnchantmentHelper.func_82781_a((ItemStack)stack);
                    enchantments.put(Enchantments.field_185312_x, 1);
                    EnchantmentHelper.func_82782_a((Map)enchantments, (ItemStack)stack);
                    ItemStack arrow = new ItemStack(Items.field_151032_g);
                    if (target instanceof EntityStray || target instanceof EntityStrayMinion) {
                        arrow = new ItemStack(Items.field_185167_i);
                        PotionUtils.func_185188_a((ItemStack)arrow, (PotionType)PotionTypes.field_185246_r);
                    }
                    possessor.func_184611_a(EnumHand.OFF_HAND, arrow);
                }
                possessor.func_184201_a(EntityEquipmentSlot.MAINHAND, stack);
                WizardryPacketHandler.net.sendToAllTracking((IMessage)new PacketPossession.Message(possessor, target, duration), (Entity)possessor);
                if (possessor instanceof EntityPlayerMP) {
                    WizardryPacketHandler.net.sendTo((IMessage)new PacketPossession.Message(possessor, target, duration), (EntityPlayerMP)possessor);
                }
            }
            return true;
        }
        return false;
    }

    public void endPossession(EntityPlayer player) {
        EntityLiving victim = Possession.getPossessee(player);
        if (victim != null) {
            victim.field_70128_L = false;
            victim.func_94061_f(false);
            victim.getEntityData().func_82580_o(NBT_KEY);
            victim.func_70107_b(player.field_70165_t, player.field_70163_u, player.field_70161_v);
            if (!player.field_70170_p.field_72995_K) {
                player.field_70170_p.func_72838_d((Entity)victim);
            }
            for (PotionEffect effect : player.func_70651_bq()) {
                if (effect.func_188419_a() instanceof PotionSlowTime) continue;
                victim.func_70690_d(effect);
            }
        }
        player.func_70674_bp();
        player.eyeHeight = player.getDefaultEyeHeight();
        if (WizardData.get(player) != null) {
            WizardData.get(player).setVariable(TIMER_KEY, 0);
            WizardData.get(player).setVariable(POSSESSEE_KEY, null);
        }
        if (!player.field_71075_bZ.field_75098_d) {
            player.field_71075_bZ.field_75101_c = false;
            player.field_71075_bZ.field_75100_b = false;
        }
        if (player.field_70170_p.field_72995_K && player == Minecraft.func_71410_x().field_71439_g) {
            Minecraft.func_71410_x().field_71460_t.func_181022_b();
            Wizardry.proxy.playBlinkEffect(player);
        }
        for (IAttribute attribute : INHERITED_ATTRIBUTES.keySet()) {
            player.func_110140_aT().func_111151_a(attribute).func_188479_b(INHERITED_ATTRIBUTES.get(attribute));
        }
        if (player instanceof EntityPlayerMP) {
            player.field_71071_by.func_174888_l();
            if (player.getEntityData() != null) {
                player.field_71071_by.func_70443_b(player.getEntityData().func_150295_c(INVENTORY_NBT_KEY, 10));
            }
            player.field_71069_bz.func_75142_b();
        }
        this.playSound(player.field_70170_p, (EntityLivingBase)player, 0, -1, null, "end");
        if (!player.field_70170_p.field_72995_K && player instanceof EntityPlayerMP) {
            WizardryPacketHandler.net.sendToAllTracking((IMessage)new PacketPossession.Message(player, null, 0), (Entity)player);
            WizardryPacketHandler.net.sendTo((IMessage)new PacketPossession.Message(player, null, 0), (EntityPlayerMP)player);
        }
    }

    @Nullable
    public static EntityLiving getPossessee(EntityPlayer player) {
        return WizardData.get(player) == null ? null : WizardData.get(player).getVariable(POSSESSEE_KEY);
    }

    public static boolean isPossessing(EntityPlayer player) {
        return Possession.getPossessee(player) != null;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static int update(EntityPlayer player, Integer possessionTimer) {
        if (possessionTimer == null) {
            possessionTimer = 0;
        }
        if (possessionTimer <= 0) {
            if (!Possession.isPossessing(player)) return possessionTimer;
            ((Possession)Spells.possession).endPossession(player);
            return possessionTimer;
        }
        if (Possession.isPossessing(player) && !player.func_70093_af()) {
            Integer n = possessionTimer;
            Integer n2 = possessionTimer = Integer.valueOf(possessionTimer - 1);
            if (!player.field_70170_p.field_72995_K) return possessionTimer;
            ParticleBuilder.create(ParticleBuilder.Type.DARK_MAGIC, (Entity)player).clr(0.1f, 0.0f, 0.3f).spawn(player.field_70170_p);
            Wizardry.proxy.loadShader(player, SHADER);
            return possessionTimer;
        }
        ((Possession)Spells.possession).endPossession(player);
        return 0;
    }

    public static <T extends EntityLiving> void addAbility(Class<T> entityType, BiConsumer<T, EntityPlayer> ability) {
        abilities.put(entityType, ability);
    }

    private static <T extends EntityLiving> void performAbilities(EntityLiving entity, EntityPlayer player) {
        for (Class entityType : abilities.keySet()) {
            if (!entityType.isAssignableFrom(entity.getClass())) continue;
            abilities.get((Object)entityType).forEach(a -> a.accept(entity, player));
        }
    }

    public static <T extends Entity> void addProjectile(Class<? extends EntityLiving> entityType, Function<World, T> factory) {
        projectiles.put(entityType, factory);
    }

    private static void setSize(Entity entity, float width, float height) {
        if (width != entity.field_70130_N || height != entity.field_70131_O) {
            entity.field_70130_N = width;
            entity.field_70131_O = height;
            double halfWidth = (double)width / 2.0;
            entity.func_174826_a(new AxisAlignedBB(entity.field_70165_t - halfWidth, entity.field_70163_u, entity.field_70161_v - halfWidth, entity.field_70165_t + halfWidth, entity.field_70163_u + (double)entity.field_70131_O, entity.field_70161_v + halfWidth));
        }
    }

    @SubscribeEvent
    public static void onPlayerTickEvent(TickEvent.PlayerTickEvent event) {
        EntityLiving possessee;
        if (event.phase == TickEvent.Phase.START && (possessee = Possession.getPossessee(event.player)) != null) {
            possessee.func_70107_b(event.player.field_70165_t, event.player.field_70163_u, event.player.field_70161_v);
            possessee.field_70159_w = event.player.field_70159_w;
            possessee.field_70181_x = event.player.field_70181_x;
            possessee.field_70179_y = event.player.field_70179_y;
            possessee.field_70122_E = event.player.field_70122_E;
            possessee.func_70071_h_();
            ++possessee.field_70173_aa;
            if (possessee.func_110143_aJ() <= 0.0f) {
                ((Possession)Spells.possession).endPossession(event.player);
            }
            Possession.performAbilities(possessee, event.player);
        }
        if (event.phase == TickEvent.Phase.END && (possessee = Possession.getPossessee(event.player)) != null) {
            Possession.setSize((Entity)event.player, possessee.field_70130_N, possessee.field_70131_O);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onLivingAttackEvent(LivingAttackEvent event) {
        EntityLiving possessee;
        if (event.getEntity() instanceof EntityPlayer && event.getSource() != DamageSource.field_76380_i && (possessee = Possession.getPossessee((EntityPlayer)event.getEntity())) != null) {
            DamageSafetyChecker.attackEntitySafely((Entity)possessee, event.getSource(), event.getAmount(), event.getSource().func_76355_l());
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onLivingDamageEvent(LivingDamageEvent event) {
        for (EntityPlayer player : event.getEntity().field_70170_p.field_73010_i) {
            EntityLiving possessee = Possession.getPossessee(player);
            if (possessee != event.getEntity()) continue;
            if (!player.field_71075_bZ.field_75098_d) {
                DamageSafetyChecker.attackEntitySafely((Entity)player, DamageSource.field_76380_i, event.getAmount() / 2.0f, DamageSource.field_76380_i.func_76355_l());
            }
            if (!(player.func_110143_aJ() <= Spells.possession.getProperty(CRITICAL_HEALTH).floatValue())) continue;
            player.func_70606_j(Spells.possession.getProperty(CRITICAL_HEALTH).floatValue());
            ((Possession)Spells.possession).endPossession(player);
        }
    }

    @SubscribeEvent
    public static void onPlayerInteractEvent(PlayerInteractEvent event) {
        if (event instanceof PlayerInteractEvent.RightClickItem) {
            return;
        }
        EntityLiving possessee = Possession.getPossessee(event.getEntityPlayer());
        if (possessee != null) {
            Integer cooldown;
            if (possessee instanceof EntityEnderman && (event instanceof PlayerInteractEvent.RightClickBlock && ((EntityEnderman)possessee).func_175489_ck() != null || event instanceof PlayerInteractEvent.LeftClickBlock && ((EntityEnderman)possessee).func_175489_ck() == null)) {
                return;
            }
            if (WizardData.get(event.getEntityPlayer()) != null && event.getWorld().field_72995_K && (event instanceof PlayerInteractEvent.RightClickEmpty || event instanceof PlayerInteractEvent.EntityInteract || event instanceof PlayerInteractEvent.RightClickBlock) && ((cooldown = WizardData.get(event.getEntityPlayer()).getVariable(SHOOT_COOLDOWN_KEY)) == null || cooldown == 0)) {
                WizardryPacketHandler.net.sendToServer((IMessage)new PacketControlInput.Message(PacketControlInput.ControlType.POSSESSION_PROJECTILE));
                WizardData.get(event.getEntityPlayer()).setVariable(SHOOT_COOLDOWN_KEY, 30);
                if (possessee instanceof EntityLightningWraith) {
                    Spells.arc.cast(event.getWorld(), event.getEntityPlayer(), EnumHand.MAIN_HAND, 0, new SpellModifiers());
                }
                if (possessee instanceof EntityCreeper) {
                    ((EntityCreeper)possessee).func_146079_cb();
                }
            }
            if (event.isCancelable()) {
                event.setCanceled(true);
            }
        }
    }

    public static void shootProjectile(EntityPlayer possessor) {
        EntityLiving possessee;
        Integer cooldown;
        if (WizardData.get(possessor) != null && ((cooldown = WizardData.get(possessor).getVariable(SHOOT_COOLDOWN_KEY)) == null || cooldown == 0) && (possessee = Possession.getPossessee(possessor)) != null) {
            Function<World, ? extends IProjectile> factory;
            if (possessee instanceof EntityLightningWraith) {
                Spells.arc.cast(possessor.field_70170_p, possessor, EnumHand.MAIN_HAND, 0, new SpellModifiers());
            }
            if (possessee instanceof EntityCreeper) {
                ((Possession)Spells.possession).endPossession(possessor);
                ((EntityCreeper)possessee).func_146079_cb();
            }
            if ((factory = projectiles.get(possessee.getClass())) != null) {
                IProjectile projectile = factory.apply(possessor.field_70170_p);
                Vec3d look = possessor.func_70040_Z();
                ((Entity)projectile).func_70107_b(possessor.field_70165_t + look.field_72450_a, possessor.field_70163_u + (double)possessor.func_70047_e() + look.field_72448_b, possessor.field_70161_v + look.field_72449_c);
                projectile.func_70186_c(look.field_72450_a, look.field_72448_b, look.field_72449_c, 1.6f, (float)EntityUtils.getDefaultAimingError(possessor.field_70170_p.func_175659_aa()));
                if (projectile instanceof EntityMagicProjectile) {
                    ((EntityMagicProjectile)projectile).setCaster((EntityLivingBase)possessor);
                } else if (projectile instanceof EntityMagicArrow) {
                    ((EntityMagicArrow)projectile).setCaster((EntityLivingBase)possessor);
                }
                possessor.field_70170_p.func_72838_d((Entity)projectile);
            }
            WizardData.get(possessor).setVariable(SHOOT_COOLDOWN_KEY, 30);
        }
    }

    @SubscribeEvent
    public static void onLivingSetAttackTargetEvent(LivingSetAttackTargetEvent event) {
        if (event.getTarget() instanceof EntityPlayer && event.getEntityLiving() instanceof EntityLiving) {
            EntityLiving possessee = Possession.getPossessee((EntityPlayer)event.getTarget());
            EntityLiving attacker = (EntityLiving)event.getEntityLiving();
            if (possessee != null && !attacker.func_70686_a(possessee.getClass())) {
                ((EntityLiving)event.getEntityLiving()).func_70624_b(null);
            }
        }
    }

    @SubscribeEvent
    public static void onLivingDeathEvent(LivingDeathEvent event) {
        if (event.getEntity() instanceof EntityPlayer && Possession.isPossessing((EntityPlayer)event.getEntity())) {
            ((Possession)Spells.possession).endPossession((EntityPlayer)event.getEntity());
        }
    }

    @SubscribeEvent
    public static void onPlayerLoggedOutEvent(PlayerEvent.PlayerLoggedOutEvent event) {
        if (Possession.isPossessing(event.player)) {
            ((Possession)Spells.possession).endPossession(event.player);
        }
    }

    @SubscribeEvent
    public static void onBlockBreakEvent(BlockEvent.BreakEvent event) {
        EntityLiving possessee = Possession.getPossessee(event.getPlayer());
        if (possessee instanceof EntityEnderman) {
            if (((EntityEnderman)possessee).func_175489_ck() == null) {
                ((EntityEnderman)possessee).func_175490_a(event.getState());
                event.getPlayer().func_184611_a(EnumHand.MAIN_HAND, new ItemStack(event.getState().func_177230_c()));
                event.setExpToDrop(0);
                event.getWorld().func_175698_g(event.getPos());
            } else {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void onBlockPlaceEvent(BlockEvent.PlaceEvent event) {
        EntityLiving possessee = Possession.getPossessee(event.getPlayer());
        if (possessee instanceof EntityEnderman) {
            if (((EntityEnderman)possessee).func_175489_ck() == event.getState()) {
                ((EntityEnderman)possessee).func_175490_a(null);
            } else {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void onEntityItemPickupEvent(EntityItemPickupEvent event) {
        EntityLiving possessee = Possession.getPossessee(event.getEntityPlayer());
        if (possessee != null) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    static void onItemTossEvent(ItemTossEvent event) {
        if (Possession.isPossessing(event.getPlayer())) {
            event.setCanceled(true);
            event.getPlayer().field_71071_by.func_70441_a(event.getEntityItem().func_92059_d());
        }
    }

    @SubscribeEvent
    public static void onAttackEntityEvent(AttackEntityEvent event) {
        EntityLiving possessee = Possession.getPossessee(event.getEntityPlayer());
        if (possessee == null) {
            return;
        }
        if (possessee instanceof EntityCreeper) {
            event.setCanceled(true);
        } else if (possessee.field_70714_bg.field_75782_a.stream().noneMatch(t -> t.field_75733_a instanceof EntityAIAttackMelee)) {
            event.setCanceled(true);
        }
    }

    static {
        Possession.addAbility(EntitySpider.class, (spider, player) -> {
            if (player.field_70123_F) {
                player.field_70181_x = 0.2;
            }
        });
        Possession.addAbility(EntityChicken.class, (chicken, player) -> {
            if (!player.field_70122_E && player.field_70181_x < 0.0) {
                player.field_70181_x *= 0.6;
            }
        });
        Possession.addAbility(EntityLiving.class, (entity, player) -> {
            if (!entity.func_70045_F() && player.func_70027_ad()) {
                player.func_70066_B();
            }
        });
        Possession.addProjectile(EntitySnowman.class, EntitySnowball::new);
        Possession.addProjectile(EntityBlaze.class, EntityMagicFireball::new);
        Possession.addProjectile(EntityGhast.class, EntityLargeMagicFireball::new);
        Possession.addProjectile(EntityIceWraith.class, EntityIceShard::new);
        Possession.addProjectile(EntityShadowWraith.class, EntityDarknessOrb::new);
        Possession.addProjectile(EntityStormElemental.class, EntityLightningDisc::new);
        Possession.addProjectile(EntityWitch.class, EntityPotion::new);
        blacklist.add(EntityDecoy.class);
    }
}

