/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.spell;

import electroblob.wizardry.Wizardry;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.EntityUtils;
import electroblob.wizardry.util.RayTracer;
import electroblob.wizardry.util.SpellModifiers;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.tileentity.TileEntityDispenser;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public abstract class SpellRay
extends Spell {
    protected static final double Y_OFFSET = 0.25;
    protected double particleSpacing = 0.85;
    protected double particleJitter = 0.1;
    protected double particleVelocity = 0.0;
    protected boolean ignoreLivingEntities = false;
    protected boolean hitLiquids = false;
    protected boolean ignoreUncollidables = true;
    protected float aimAssist = 0.0f;

    public SpellRay(String name, EnumAction action, boolean isContinuous) {
        this("ebwizardry", name, action, isContinuous);
    }

    public SpellRay(String modID, String name, EnumAction action, boolean isContinuous) {
        super(modID, name, action, isContinuous);
        this.addProperties("range");
        this.npcSelector((e, o) -> true);
    }

    public Spell particleSpacing(double particleSpacing) {
        this.particleSpacing = particleSpacing;
        return this;
    }

    public Spell particleJitter(double particleJitter) {
        this.particleJitter = particleJitter;
        return this;
    }

    public Spell particleVelocity(double particleVelocity) {
        this.particleVelocity = particleVelocity;
        return this;
    }

    public Spell ignoreLivingEntities(boolean ignoreLivingEntities) {
        this.ignoreLivingEntities = ignoreLivingEntities;
        return this;
    }

    public Spell hitLiquids(boolean hitLiquids) {
        this.hitLiquids = hitLiquids;
        return this;
    }

    public Spell ignoreUncollidables(boolean ignoreUncollidables) {
        this.ignoreUncollidables = ignoreUncollidables;
        return this;
    }

    public Spell aimAssist(float aimAssist) {
        this.aimAssist = aimAssist;
        return this;
    }

    @Override
    public boolean canBeCastBy(TileEntityDispenser dispenser) {
        return true;
    }

    @Override
    public boolean cast(World world, EntityPlayer caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        Vec3d look = caster.func_70040_Z();
        Vec3d origin = new Vec3d(caster.field_70165_t, caster.field_70163_u + (double)caster.func_70047_e() - 0.25, caster.field_70161_v);
        if (!this.isContinuous && world.field_72995_K && !Wizardry.proxy.isFirstPerson((Entity)caster)) {
            origin = origin.func_178787_e(look.func_186678_a(1.2));
        }
        if (!this.shootSpell(world, origin, look, (EntityLivingBase)caster, ticksInUse, modifiers)) {
            return false;
        }
        if (this.casterSwingsArm(world, (EntityLivingBase)caster, hand, ticksInUse, modifiers)) {
            caster.func_184609_a(hand);
        }
        this.playSound(world, (EntityLivingBase)caster, ticksInUse, -1, modifiers, new String[0]);
        return true;
    }

    @Override
    public boolean cast(World world, EntityLiving caster, EnumHand hand, int ticksInUse, EntityLivingBase target, SpellModifiers modifiers) {
        Vec3d origin = new Vec3d(caster.field_70165_t, caster.field_70163_u + (double)caster.func_70047_e() - 0.25, caster.field_70161_v);
        Vec3d targetPos = null;
        if (target != null) {
            if (!this.ignoreLivingEntities || !EntityUtils.isLiving((Entity)target)) {
                targetPos = new Vec3d(target.field_70165_t, target.field_70163_u + (double)(target.field_70131_O / 2.0f), target.field_70161_v);
            } else {
                int z;
                int y;
                int x = MathHelper.func_76128_c((double)target.field_70165_t);
                BlockPos pos = new BlockPos(x, y = (int)target.field_70163_u - 1, z = MathHelper.func_76128_c((double)target.field_70161_v));
                if (!(world.func_175623_d(pos) || world.func_180495_p(pos).func_185904_a().func_76224_d() && !this.hitLiquids)) {
                    targetPos = new Vec3d((double)x + 0.5, (double)(y + 1), (double)z + 0.5);
                }
            }
        }
        if (targetPos == null) {
            return false;
        }
        if (!this.shootSpell(world, origin, targetPos.func_178788_d(origin).func_72432_b(), (EntityLivingBase)caster, ticksInUse, modifiers)) {
            return false;
        }
        if (this.casterSwingsArm(world, (EntityLivingBase)caster, hand, ticksInUse, modifiers)) {
            caster.func_184609_a(hand);
        }
        this.playSound(world, (EntityLivingBase)caster, ticksInUse, -1, modifiers, new String[0]);
        return true;
    }

    @Override
    public boolean cast(World world, double x, double y, double z, EnumFacing direction, int ticksInUse, int duration, SpellModifiers modifiers) {
        Vec3d origin = new Vec3d(x, y, z);
        Vec3d vec = new Vec3d(direction.func_176730_m());
        if (!this.shootSpell(world, origin, vec, null, ticksInUse, modifiers)) {
            return false;
        }
        this.playSound(world, x - (double)direction.func_82601_c(), y - (double)direction.func_96559_d(), z - (double)direction.func_82599_e(), ticksInUse, duration, modifiers, new String[0]);
        return true;
    }

    protected double getRange(World world, Vec3d origin, Vec3d direction, @Nullable EntityLivingBase caster, int ticksInUse, SpellModifiers modifiers) {
        return this.getProperty("range").doubleValue() * (double)modifiers.get(WizardryItems.range_upgrade);
    }

    protected boolean casterSwingsArm(World world, EntityLivingBase caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        return !this.isContinuous && this.action == EnumAction.NONE;
    }

    protected boolean shootSpell(World world, Vec3d origin, Vec3d direction, @Nullable EntityLivingBase caster, int ticksInUse, SpellModifiers modifiers) {
        double range = this.getRange(world, origin, direction, caster, ticksInUse, modifiers);
        Vec3d endpoint = origin.func_178787_e(direction.func_186678_a(range));
        RayTraceResult rayTrace = RayTracer.rayTrace(world, origin, endpoint, this.aimAssist, this.hitLiquids, this.ignoreUncollidables, false, Entity.class, this.ignoreLivingEntities ? EntityUtils::isLiving : RayTracer.ignoreEntityFilter((Entity)caster));
        boolean flag = false;
        if (rayTrace != null) {
            if (rayTrace.field_72313_a == RayTraceResult.Type.ENTITY) {
                flag = this.onEntityHit(world, rayTrace.field_72308_g, rayTrace.field_72307_f, caster, origin, ticksInUse, modifiers);
                if (flag) {
                    range = origin.func_72438_d(rayTrace.field_72307_f);
                }
            } else if (rayTrace.field_72313_a == RayTraceResult.Type.BLOCK) {
                flag = this.onBlockHit(world, rayTrace.func_178782_a(), rayTrace.field_178784_b, rayTrace.field_72307_f, caster, origin, ticksInUse, modifiers);
                range = origin.func_72438_d(rayTrace.field_72307_f);
            }
        }
        if (!flag && !this.onMiss(world, caster, origin, direction, ticksInUse, modifiers)) {
            return false;
        }
        if (world.field_72995_K) {
            this.spawnParticleRay(world, origin, direction, caster, range);
        }
        return true;
    }

    protected abstract boolean onEntityHit(World var1, Entity var2, Vec3d var3, @Nullable EntityLivingBase var4, Vec3d var5, int var6, SpellModifiers var7);

    protected abstract boolean onBlockHit(World var1, BlockPos var2, EnumFacing var3, Vec3d var4, @Nullable EntityLivingBase var5, Vec3d var6, int var7, SpellModifiers var8);

    protected abstract boolean onMiss(World var1, @Nullable EntityLivingBase var2, Vec3d var3, Vec3d var4, int var5, SpellModifiers var6);

    protected void spawnParticleRay(World world, Vec3d origin, Vec3d direction, @Nullable EntityLivingBase caster, double distance) {
        Vec3d velocity = direction.func_186678_a(this.particleVelocity);
        for (double d = this.particleSpacing; d <= distance; d += this.particleSpacing) {
            double x = origin.field_72450_a + d * direction.field_72450_a + this.particleJitter * (world.field_73012_v.nextDouble() * 2.0 - 1.0);
            double y = origin.field_72448_b + d * direction.field_72448_b + this.particleJitter * (world.field_73012_v.nextDouble() * 2.0 - 1.0);
            double z = origin.field_72449_c + d * direction.field_72449_c + this.particleJitter * (world.field_73012_v.nextDouble() * 2.0 - 1.0);
            this.spawnParticle(world, x, y, z, velocity.field_72450_a, velocity.field_72448_b, velocity.field_72449_c);
        }
    }

    protected void spawnParticle(World world, double x, double y, double z, double vx, double vy, double vz) {
    }
}

