/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.worldgen;

import com.google.common.collect.ImmutableSet;
import electroblob.wizardry.Wizardry;
import electroblob.wizardry.integration.antiqueatlas.WizardryAntiqueAtlasIntegration;
import electroblob.wizardry.registry.WizardryBlocks;
import electroblob.wizardry.tileentity.TileEntityBookshelf;
import electroblob.wizardry.util.BlockUtils;
import electroblob.wizardry.worldgen.MossifierTemplateProcessor;
import electroblob.wizardry.worldgen.MultiTemplateProcessor;
import electroblob.wizardry.worldgen.WoodTypeTemplateProcessor;
import electroblob.wizardry.worldgen.WorldGenUndergroundStructure;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.BlockStoneBrick;
import net.minecraft.block.BlockStoneSlab;
import net.minecraft.block.properties.IProperty;
import net.minecraft.init.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.structure.template.ITemplateProcessor;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraft.world.gen.structure.template.Template;
import org.apache.commons.lang3.ArrayUtils;

public class WorldGenUndergroundLibraryRuins
extends WorldGenUndergroundStructure {
    private final Set<Block> nonReplaceableBlocks = ImmutableSet.of((Object)WizardryBlocks.imbuement_altar, (Object)WizardryBlocks.receptacle, (Object)WizardryBlocks.oak_bookshelf);

    @Override
    public String getStructureName() {
        return "underground_library_ruins";
    }

    @Override
    public long getRandomSeedModifier() {
        return 13012834L;
    }

    @Override
    public ResourceLocation getStructureFile(Random random) {
        return Wizardry.settings.undergroundLibraryFiles[random.nextInt(Wizardry.settings.undergroundLibraryFiles.length)];
    }

    @Override
    public boolean canGenerate(Random random, World world, int chunkX, int chunkZ) {
        return ArrayUtils.contains((int[])Wizardry.settings.libraryDimensions, (int)world.field_73011_w.getDimension()) && Wizardry.settings.libraryRarity > 0 && random.nextInt(Wizardry.settings.libraryRarity) == 0;
    }

    @Override
    public void spawnStructure(Random random, World world, BlockPos origin, Template template, PlacementSettings settings, ResourceLocation structureFile) {
        Biome biome = world.func_180494_b(origin);
        float stoneBrickChance = random.nextFloat();
        float mossiness = 0.6f;
        BlockPlanks.EnumType woodType = BlockUtils.getBiomeWoodVariant(biome);
        MultiTemplateProcessor processor = new MultiTemplateProcessor(true, (w, p, i) -> w.func_175623_d(p) && !this.nonReplaceableBlocks.contains(i.field_186243_b.func_177230_c()) ? null : i, (w, p, i) -> {
            if (w.field_73012_v.nextFloat() > stoneBrickChance) {
                if (i.field_186243_b.func_177230_c() == Blocks.field_150347_e) {
                    return new Template.BlockInfo(i.field_186242_a, Blocks.field_150417_aV.func_176223_P(), i.field_186244_c);
                }
                if (i.field_186243_b.func_177230_c() == Blocks.field_150333_U && i.field_186243_b.func_177229_b((IProperty)BlockStoneSlab.field_176556_M) == BlockStoneSlab.EnumType.COBBLESTONE) {
                    return new Template.BlockInfo(i.field_186242_a, i.field_186243_b.func_177226_a((IProperty)BlockStoneSlab.field_176556_M, (Comparable)BlockStoneSlab.EnumType.SMOOTHBRICK), i.field_186244_c);
                }
                if (i.field_186243_b.func_177230_c() == Blocks.field_150446_ar) {
                    return new Template.BlockInfo(i.field_186242_a, BlockUtils.copyState(Blocks.field_150390_bg, i.field_186243_b), i.field_186244_c);
                }
            }
            return i;
        }, new WoodTypeTemplateProcessor(woodType), new MossifierTemplateProcessor(0.6f, 0.04f, origin.func_177956_o() + 1), (w, p, i) -> i.field_186243_b.func_177230_c() == Blocks.field_150417_aV && w.field_73012_v.nextFloat() < 0.1f ? new Template.BlockInfo(i.field_186242_a, Blocks.field_150417_aV.func_176223_P().func_177226_a((IProperty)BlockStoneBrick.field_176249_a, (Comparable)BlockStoneBrick.EnumType.CRACKED), i.field_186244_c) : i, (w, p, i) -> {
            TileEntityBookshelf.markAsNatural(i.field_186244_c);
            return i;
        });
        template.func_189960_a(world, origin, (ITemplateProcessor)processor, settings, 18);
        WizardryAntiqueAtlasIntegration.markLibrary(world, origin.func_177958_n(), origin.func_177952_p(), true);
    }
}

