/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.thaumicadditions.api;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.function.BiFunction;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.MathHelper;
import org.zeith.thaumicadditions.api.AspectUtil;
import org.zeith.thaumicadditions.init.KnowledgeTAR;
import org.zeith.thaumicadditions.init.PotionsTAR;
import org.zeith.thaumicadditions.utils.Foods;
import thaumcraft.api.ThaumcraftApi;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.capabilities.IPlayerKnowledge;
import thaumcraft.api.capabilities.IPlayerWarp;
import thaumcraft.api.capabilities.ThaumcraftCapabilities;
import thaumcraft.api.potions.PotionFluxTaint;
import thaumcraft.api.research.ResearchCategories;
import thaumcraft.api.research.ResearchCategory;
import thaumcraft.common.lib.SoundsTC;
import thaumcraft.common.lib.potions.PotionWarpWard;

public class EdibleAspect {
    public static final int MAX_ESSENTIA = 32;
    public static final Map<Aspect, BiFunction<EntityLivingBase, Integer, Boolean>> EAT_FUNCTIONS = new HashMap<Aspect, BiFunction<EntityLivingBase, Integer, Boolean>>();
    public static final Map<AspectList, BiFunction<EntityLivingBase, AspectList, Boolean>> COMPLEX_FUNCTIONS = new HashMap<AspectList, BiFunction<EntityLivingBase, AspectList, Boolean>>();

    public static boolean addPotionEffect(EntityLivingBase elb, Potion potion, int timeInSec, int amplifier) {
        PotionEffect pe = elb.func_70660_b(potion);
        if (pe != null && (potion != MobEffects.field_76439_r || pe.func_76459_b() >= 300) && pe.func_76459_b() > 40) {
            return false;
        }
        elb.func_70690_d(new PotionEffect(potion, timeInSec, amplifier, false, false));
        return true;
    }

    public static AspectList execute(EntityLivingBase ent, AspectList al) {
        if (ent == null || al == null || al.visSize() == 0) {
            return new AspectList();
        }
        AspectList alt = al = al.copy();
        AspectList origin = al.copy();
        AspectList used = new AspectList();
        COMPLEX_FUNCTIONS.keySet().stream().filter(a -> AspectUtil.containsAll(alt, a)).forEach(a -> {
            BiFunction<EntityLivingBase, AspectList, Boolean> bi = COMPLEX_FUNCTIONS.get(alt);
            if (bi != null) {
                if (Objects.equals(bi.apply(ent, alt), Boolean.TRUE)) {
                    used.add(a);
                }
                alt.remove(a);
            }
        });
        for (Aspect a2 : alt.getAspectsSortedByAmount()) {
            BiFunction<EntityLivingBase, Integer, Boolean> cons = EAT_FUNCTIONS.get(a2);
            if (cons == null || !Objects.equals(cons.apply(ent, alt.getAmount(a2)), Boolean.TRUE)) continue;
            used.add(a2, alt.getAmount(a2));
        }
        return used;
    }

    public static void addComplexCall(AspectList list, BiFunction<EntityLivingBase, AspectList, Boolean> c) {
        COMPLEX_FUNCTIONS.put(list, c);
    }

    public static void addEatCall(Aspect asp, BiFunction<EntityLivingBase, Integer, Boolean> c) {
        BiFunction<EntityLivingBase, Integer, Boolean> ef = EAT_FUNCTIONS.get(asp);
        if (ef != null) {
            ef = EdibleAspect.aor(c, ef);
        }
        EAT_FUNCTIONS.put(asp, c);
    }

    private static <A1, A2> BiFunction<A1, A2, Boolean> aor(BiFunction<A1, A2, Boolean> a, BiFunction<A1, A2, Boolean> b) {
        return (k, u) -> (Boolean)a.apply(k, u) != false || (Boolean)b.apply(k, u) != false;
    }

    public static ItemStack withoutSalt(ItemStack stack) {
        if ((stack = stack.func_77946_l()).func_190926_b()) {
            return stack;
        }
        if (!Foods.isFood(stack.func_77973_b())) {
            return stack;
        }
        if (stack.func_77942_o()) {
            stack.func_77978_p().func_82580_o("TARSalt");
        }
        if (stack.func_77978_p().func_82582_d()) {
            stack.func_77982_d(null);
        }
        return stack;
    }

    public static ItemStack applyToFoodStack(ItemStack stack, AspectList aspects) {
        if ((stack = stack.func_77946_l()).func_190926_b()) {
            return stack;
        }
        if (!Foods.isFood(stack.func_77973_b())) {
            return stack;
        }
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        AspectList fin = new AspectList();
        fin.add(aspects);
        fin.add(EdibleAspect.getSalt(stack));
        NBTTagCompound anbt = new NBTTagCompound();
        fin.writeToNBT(anbt);
        stack.func_77978_p().func_74782_a("TARSalt", (NBTBase)anbt);
        return stack;
    }

    public static AspectList getSalt(ItemStack stack) {
        NBTTagCompound anbt = stack.func_77978_p();
        if (anbt != null) {
            if (!anbt.func_150297_b("TARSalt", 10)) {
                return new AspectList();
            }
            anbt = anbt.func_74775_l("TARSalt");
            AspectList nal = new AspectList();
            nal.readFromNBT(anbt);
            return nal;
        }
        return new AspectList();
    }

    static {
        EdibleAspect.addEatCall(Aspect.FIRE, (player, count) -> EdibleAspect.addPotionEffect(player, MobEffects.field_76426_n, 10 + count * count, 0));
        EdibleAspect.addEatCall(Aspect.WATER, (player, count) -> EdibleAspect.addPotionEffect(player, MobEffects.field_76427_o, 10 + count * count, 0));
        EdibleAspect.addEatCall(Aspect.TRAP, (player, count) -> EdibleAspect.addPotionEffect(player, MobEffects.field_76421_d, 20 + count * count * 20, 1));
        EdibleAspect.addEatCall(Aspect.SENSES, (player, count) -> EdibleAspect.addPotionEffect(player, MobEffects.field_76439_r, 400 + count * count, 0));
        EdibleAspect.addEatCall(Aspect.DARKNESS, (player, count) -> EdibleAspect.addPotionEffect(player, MobEffects.field_76440_q, 10 + count * count, 0));
        EdibleAspect.addEatCall(Aspect.ALCHEMY, (player, count) -> EdibleAspect.addPotionEffect(player, MobEffects.field_76431_k, 10 + count * count, 0));
        EdibleAspect.addEatCall(Aspect.ENERGY, (player, count) -> EdibleAspect.addPotionEffect(player, MobEffects.field_76420_g, 20 + count * count, (int)Math.sqrt(count.intValue())));
        EdibleAspect.addEatCall(Aspect.TOOL, (player, count) -> EdibleAspect.addPotionEffect(player, MobEffects.field_76422_e, 20 + count * count, (int)Math.sqrt(count.intValue())));
        EdibleAspect.addEatCall(Aspect.DEATH, (player, count) -> player.func_70097_a(DamageSource.field_76376_m, 1.0f + (float)Math.sqrt(count.intValue())));
        EdibleAspect.addEatCall(Aspect.MOTION, (player, count) -> EdibleAspect.addPotionEffect(player, MobEffects.field_76424_c, 10 + count * count, count * 3 / 32));
        EdibleAspect.addEatCall(KnowledgeTAR.SONUS, (player, count) -> EdibleAspect.addPotionEffect(player, PotionsTAR.SOUND_SENSIVITY, 120 + count * count, count * 21 / 32));
        EdibleAspect.addEatCall(Aspect.DESIRE, (player, count) -> EdibleAspect.addPotionEffect(player, MobEffects.field_76438_s, 100 + count * count, count * 5 / 32));
        EdibleAspect.addEatCall(Aspect.PROTECT, (player, count) -> EdibleAspect.addPotionEffect(player, MobEffects.field_76429_m, 200 + count * count * 2, count * 10 / 32));
        EdibleAspect.addEatCall(Aspect.AURA, (player, count) -> EdibleAspect.addPotionEffect(player, PotionWarpWard.instance, 1200 + count * 200, 0));
        EdibleAspect.addEatCall(Aspect.MIND, (player, count) -> {
            if (player instanceof EntityPlayer) {
                player.field_70170_p.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundsTC.learn, SoundCategory.NEUTRAL, 0.5f, 0.4f / (player.func_70681_au().nextFloat() * 0.4f + 0.8f));
                if (player instanceof EntityPlayerMP && !player.field_70170_p.field_72995_K) {
                    EntityPlayerMP mp = (EntityPlayerMP)player;
                    count = (int)(Math.sqrt(count.intValue()) * 2.0);
                    int oProg = IPlayerKnowledge.EnumKnowledgeType.OBSERVATION.getProgression() * count;
                    int tProg = IPlayerKnowledge.EnumKnowledgeType.THEORY.getProgression() * count;
                    ResearchCategory[] rc = ResearchCategories.researchCategories.values().toArray(new ResearchCategory[0]);
                    ThaumcraftApi.internalMethods.addKnowledge((EntityPlayer)mp, IPlayerKnowledge.EnumKnowledgeType.OBSERVATION, rc[player.func_70681_au().nextInt(rc.length)], MathHelper.func_76136_a((Random)player.func_70681_au(), (int)(oProg / 10), (int)(oProg / 8)));
                    ThaumcraftApi.internalMethods.addKnowledge((EntityPlayer)mp, IPlayerKnowledge.EnumKnowledgeType.THEORY, rc[player.func_70681_au().nextInt(rc.length)], MathHelper.func_76136_a((Random)player.func_70681_au(), (int)(tProg / 20), (int)(tProg / 16)));
                }
                return true;
            }
            return false;
        });
        EdibleAspect.addEatCall(Aspect.FLUX, (player, count) -> {
            if (player instanceof EntityPlayerMP && !player.field_70170_p.field_72995_K) {
                EntityPlayerMP mp = (EntityPlayerMP)player;
                IPlayerWarp warp = ThaumcraftCapabilities.getWarp((EntityPlayer)mp);
                warp.add(IPlayerWarp.EnumWarpType.TEMPORARY, (int)Math.ceil(Math.sqrt(count.intValue())));
                warp.sync(mp);
            }
            return EdibleAspect.addPotionEffect(player, PotionFluxTaint.instance, 10 + count * count, 0);
        });
        EdibleAspect.addEatCall(Aspect.LIFE, (player, count) -> {
            boolean healthy;
            boolean bl = healthy = player.func_110138_aP() - player.func_110143_aJ() < 0.5f;
            if (!healthy) {
                player.func_70691_i(1.0f + (float)Math.sqrt(count.intValue()));
            }
            return !healthy;
        });
    }
}

