/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.thaumicadditions.api;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.capabilities.IPlayerKnowledge;
import thaumcraft.api.capabilities.ThaumcraftCapabilities;

public class ShadowEnchantment {
    private static final Map<Enchantment, ShadowEnchantment> ENCH_REGISTRY = new HashMap<Enchantment, ShadowEnchantment>();
    private static final List<ShadowEnchantment> REGISTRY = new ArrayList<ShadowEnchantment>();
    public final Enchantment enchantment;
    protected final ByIntFunction<AspectList> aspects;
    protected final ResourceLocation icon;
    protected final String research;

    public ShadowEnchantment(Enchantment enchantment, ByIntFunction<AspectList> aspects, ResourceLocation icon, String research) {
        this.enchantment = enchantment;
        this.aspects = aspects;
        this.icon = icon;
        this.research = research;
    }

    public static ShadowEnchantment pick(Enchantment ench) {
        return ENCH_REGISTRY.get(ench);
    }

    public static void registerEnchantment(ShadowEnchantment ench) {
        REGISTRY.add(ench);
        ENCH_REGISTRY.put(ench.enchantment, ench);
    }

    public static void registerEnchantment(Enchantment ench, ByIntFunction<AspectList> aspects, ResourceLocation icon, @Nullable String research) {
        ShadowEnchantment.registerEnchantment(new ShadowEnchantment(ench, aspects, icon, research));
    }

    public static AspectBuilder aspectBuilder() {
        return new AspectBuilder();
    }

    public static List<ShadowEnchantment> getRegistry() {
        return REGISTRY;
    }

    public AspectList getAspects(int lvl) {
        return this.aspects.apply(lvl);
    }

    public Enchantment getEnchantment() {
        return this.enchantment;
    }

    public ResourceLocation getIcon() {
        return this.icon;
    }

    public String getResearch() {
        return this.research;
    }

    public boolean canBeAppliedBy(EntityPlayer player) {
        if (this.research != null) {
            IPlayerKnowledge k = ThaumcraftCapabilities.getKnowledge((EntityPlayer)player);
            if (k != null) {
                return k.isResearchComplete(this.research);
            }
            return false;
        }
        return true;
    }

    public static class AspectBuilder
    implements ByIntFunction<AspectList> {
        private final Map<Aspect, Int2IntFunction> aspects = new HashMap<Aspect, Int2IntFunction>();

        private AspectBuilder() {
        }

        public AspectBuilder powByLvl(Aspect aspect, int baseAmount) {
            this.aspects.put(aspect, lvl -> (int)Math.round(Math.pow(baseAmount, lvl)));
            return this;
        }

        public AspectBuilder multiplyByLvl(Aspect aspect, int baseAmount) {
            this.aspects.put(aspect, lvl -> baseAmount * lvl);
            return this;
        }

        public AspectBuilder constant(Aspect aspect, int amount) {
            this.aspects.put(aspect, lvl -> amount);
            return this;
        }

        @Override
        public AspectList apply(int i) {
            AspectList list = new AspectList();
            this.aspects.forEach((a, f) -> list.add(a, f.applyAsInt(i)));
            return list;
        }
    }

    public static interface ByIntFunction<T> {
        public T apply(int var1);
    }

    public static interface Int2IntFunction {
        public int applyAsInt(int var1);
    }
}

