/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.thaumicadditions.api.items;

import com.google.common.base.Predicates;
import com.zeitheron.hammercore.utils.base.Cast;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import org.zeith.thaumicadditions.blocks.BlockAbstractEssentiaJar;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.blocks.BlocksTC;
import thaumcraft.common.blocks.essentia.BlockJarItem;

public class EssentiaJarManager {
    private static final Map<Item, Function<ItemStack, IJar>> JARS = new HashMap<Item, Function<ItemStack, IJar>>();

    public static void registerJar(Item item, IJar jar) {
        JARS.put(item, stack -> jar);
    }

    public static void registerJar(Item item, Function<ItemStack, IJar> jar) {
        JARS.put(item, jar);
    }

    public static IJar fromStack(ItemStack stack) {
        if (stack.func_190926_b()) {
            return null;
        }
        Function<ItemStack, IJar> jarsup = JARS.get(stack.func_77973_b());
        return jarsup == null ? null : jarsup.apply(stack);
    }

    static {
        Function<ItemStack, IJar> vanillaJar = stack -> {
            final BlockJarItem item = (BlockJarItem)Cast.cast((Object)stack.func_77973_b(), BlockJarItem.class);
            return new IJar(){

                @Override
                public AspectList getEssentia(ItemStack stack) {
                    AspectList list = item.getAspects(stack);
                    return list == null ? new AspectList() : list;
                }

                @Override
                public int drain(ItemStack stack, Aspect aspect, int amount) {
                    AspectList list = this.getEssentia(stack);
                    int d = list.getAmount(aspect);
                    if (d > 0) {
                        amount = Math.min(d, amount);
                        list.remove(aspect, amount);
                        item.setAspects(stack, list);
                        return amount;
                    }
                    return 0;
                }

                @Override
                public int fill(ItemStack stack, Aspect aspect, int amount) {
                    AspectList list = this.getEssentia(stack);
                    int d = list.getAmount(aspect);
                    if (d < 250) {
                        amount = Math.min(250 - d, amount);
                        list.add(aspect, amount);
                        item.setAspects(stack, list);
                        return amount;
                    }
                    return 0;
                }

                @Override
                public int capacity(ItemStack jarStack) {
                    return 250;
                }
            };
        };
        EssentiaJarManager.registerJar(Item.func_150898_a((Block)BlocksTC.jarNormal), vanillaJar);
        EssentiaJarManager.registerJar(Item.func_150898_a((Block)BlocksTC.jarVoid), vanillaJar);
        ForgeRegistries.ITEMS.getValuesCollection().stream().filter(Predicates.instanceOf(BlockAbstractEssentiaJar.BlockAbstractJarItem.class)).forEach(ji -> {
            final BlockAbstractEssentiaJar.BlockAbstractJarItem item = (BlockAbstractEssentiaJar.BlockAbstractJarItem)((Object)ji);
            final int capacity = item.field_150939_a.capacity;
            EssentiaJarManager.registerJar(ji, (ItemStack stack) -> new IJar(){

                @Override
                public AspectList getEssentia(ItemStack stack) {
                    AspectList list = item.getAspects(stack);
                    return list == null ? new AspectList() : list;
                }

                @Override
                public int drain(ItemStack stack, Aspect aspect, int amount) {
                    AspectList list = this.getEssentia(stack);
                    int d = list.getAmount(aspect);
                    if (d > 0) {
                        amount = Math.min(d, amount);
                        list.remove(aspect, amount);
                        item.setAspects(stack, list);
                        return amount;
                    }
                    return 0;
                }

                @Override
                public int fill(ItemStack stack, Aspect aspect, int amount) {
                    AspectList list = this.getEssentia(stack);
                    int d = list.getAmount(aspect);
                    if (d < capacity) {
                        amount = Math.min(capacity - d, amount);
                        list.add(aspect, amount);
                        item.setAspects(stack, list);
                        return amount;
                    }
                    return 0;
                }

                @Override
                public int capacity(ItemStack jarStack) {
                    return capacity;
                }
            });
        });
    }

    public static interface IJar {
        public AspectList getEssentia(ItemStack var1);

        public int drain(ItemStack var1, Aspect var2, int var3);

        public int fill(ItemStack var1, Aspect var2, int var3);

        public int capacity(ItemStack var1);
    }
}

