/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.thaumicadditions.client.util.tesseract;

import com.zeitheron.hammercore.utils.color.ColorHelper;
import javax.vecmath.Vector4f;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.zeith.thaumicadditions.client.util.planemath.Matrix4f;
import org.zeith.thaumicadditions.client.util.planemath.TrigMath;

public class Plane {
    Vector4f[] vectors;

    public Plane(Vector4f vec1, Vector4f vec2, Vector4f vec3, Vector4f vec4) {
        this.vectors = new Vector4f[]{vec1, vec2, vec3, vec4};
    }

    private static Vector4f rotXW(Vector4f v, double angle) {
        return Matrix4f.from(TrigMath.cos(angle), 0.0f, 0.0f, TrigMath.sin(angle), 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, -TrigMath.sin(angle), 0.0f, 0.0f, TrigMath.cos(angle)).transform(v);
    }

    private static Vector4f rotZW(Vector4f v, double angle) {
        return Matrix4f.from(1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, TrigMath.cos(angle), -TrigMath.sin(angle), 0.0f, 0.0f, TrigMath.sin(angle), TrigMath.cos(angle)).transform(v);
    }

    private static Vector4f rotYW(Vector4f v, double angle) {
        return Matrix4f.from(1.0f, 0.0f, 0.0f, 0.0f, 0.0f, TrigMath.cos(angle), 0.0f, TrigMath.sin(angle), 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, -TrigMath.sin(angle), 0.0f, TrigMath.cos(angle)).transform(v);
    }

    private static Vector4f rotXY(Vector4f v, double angle) {
        return Matrix4f.from(TrigMath.cos(angle), -TrigMath.sin(angle), 0.0f, 0.0f, TrigMath.sin(angle), TrigMath.cos(angle), 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f).transform(v);
    }

    @SideOnly(value=Side.CLIENT)
    private static void project(BufferBuilder buffer, Vector4f vector, int u, int v, int color) {
        double scalar = 1.0 / (double)(vector.getW() + 1.0f);
        Vec3d vector1 = new Vec3d((double)vector.getX(), (double)vector.getY(), (double)vector.getZ()).func_186678_a(scalar);
        buffer.func_181662_b(vector1.field_72450_a, vector1.field_72448_b, vector1.field_72449_c).func_187315_a((double)u, (double)v).func_181666_a(ColorHelper.getRed((int)color), ColorHelper.getGreen((int)color), ColorHelper.getBlue((int)color), ColorHelper.getAlpha((int)color)).func_181675_d();
    }

    @SideOnly(value=Side.CLIENT)
    public void draw(int color, double radian) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder worldRenderer = tessellator.func_178180_c();
        worldRenderer.func_181668_a(2, DefaultVertexFormats.field_181709_i);
        Plane.project(worldRenderer, Plane.rotYW(this.vectors[0], radian), 0, 0, color);
        Plane.project(worldRenderer, Plane.rotYW(this.vectors[1], radian), 0, 1, color);
        Plane.project(worldRenderer, Plane.rotYW(this.vectors[2], radian), 1, 1, color);
        Plane.project(worldRenderer, Plane.rotYW(this.vectors[3], radian), 1, 0, color);
        tessellator.func_78381_a();
    }
}

