/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.thaumicadditions.events;

import com.zeitheron.hammercore.client.render.shader.ShaderProgram;
import com.zeitheron.hammercore.client.render.shader.impl.ShaderEnderField;
import com.zeitheron.hammercore.client.render.world.VirtualWorld;
import com.zeitheron.hammercore.client.utils.RenderUtil;
import com.zeitheron.hammercore.net.HCNet;
import com.zeitheron.hammercore.net.IPacket;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.PositionedSound;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.profiler.Profiler;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.event.FOVUpdateEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.client.event.sound.PlaySoundEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.ARBShaderObjects;
import org.lwjgl.opengl.GL11;
import org.zeith.thaumicadditions.api.AttributesTAR;
import org.zeith.thaumicadditions.api.EdibleAspect;
import org.zeith.thaumicadditions.client.HudHandlerHookTAR;
import org.zeith.thaumicadditions.client.ParticleHooksTAR;
import org.zeith.thaumicadditions.items.ItemSealSymbol;
import org.zeith.thaumicadditions.items.armor.ItemMithminiteDress;
import org.zeith.thaumicadditions.items.tools.ItemVoidThaumometer;
import org.zeith.thaumicadditions.net.PacketLeftClick;
import org.zeith.thaumicadditions.tiles.TileSeal;
import org.zeith.thaumicadditions.utils.Foods;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.client.fx.ParticleEngine;
import thaumcraft.client.fx.particles.FXGeneric;
import thaumcraft.client.lib.UtilsFX;
import thaumcraft.common.entities.EntityFluxRift;
import thaumcraft.common.lib.utils.Utils;

public class ClientEventReactor {
    public static final ClientEventReactor REACTOR = new ClientEventReactor();
    final List<Particle> sounding = new ArrayList<Particle>();
    final List<BlockPos> excludesRAJ = new ArrayList<BlockPos>();
    final VirtualWorld ores = new VirtualWorld();
    boolean voidThaumometer;
    WeakReference<TileSeal> seal_MH;
    int sealHoverTime_MH;
    private boolean keyBindAttack;
    private final Map<EntityEquipmentSlot, ItemStack> armor = new HashMap<EntityEquipmentSlot, ItemStack>();

    public static void translatePlayerIrrelative(double x, double y, double z) {
        GlStateManager.func_179137_b((double)(x - TileEntityRendererDispatcher.field_147554_b), (double)(y - TileEntityRendererDispatcher.field_147555_c), (double)(z - TileEntityRendererDispatcher.field_147552_d));
    }

    @SubscribeEvent
    public void clientTick(TickEvent.ClientTickEvent cte) {
        RayTraceResult over;
        KeyBinding kb;
        ItemStack head;
        if (cte.phase == TickEvent.Phase.START) {
            return;
        }
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        boolean mithminiteHelm = false;
        if (world != null && player != null && !(head = player.func_184582_a(EntityEquipmentSlot.HEAD)).func_190926_b() && head.func_77973_b() instanceof ItemMithminiteDress) {
            mithminiteHelm = true;
            Profiler prof = Minecraft.func_71410_x().field_71424_I;
            prof.func_76320_a("sounding_figure_ores");
            Field particles = ParticleEngine.class.getDeclaredFields()[2];
            particles.setAccessible(true);
            try {
                HashMap[] ps = (HashMap[])particles.get(null);
                int pss = this.sounding.size();
                this.sounding.clear();
                for (HashMap effects : ps) {
                    ArrayList listParticles = (ArrayList)effects.get(world.field_73011_w.getDimension());
                    if (listParticles == null) continue;
                    for (Particle fx : listParticles) {
                        FXGeneric fxg;
                        if (!(fx instanceof FXGeneric) || !ParticleHooksTAR.isSoundingFX(fxg = (FXGeneric)fx)) continue;
                        this.sounding.add((Particle)fxg);
                    }
                }
                if (pss != this.sounding.size()) {
                    this.excludesRAJ.clear();
                    prof.func_76320_a("render");
                    for (int i = 0; i < this.sounding.size(); ++i) {
                        Particle s = this.sounding.get(i);
                        this.renderAllAdjacent((World)world, new BlockPos(s.field_187126_f, s.field_187127_g, s.field_187128_h), null, null);
                    }
                    prof.func_76318_c("sort");
                    this.excludesRAJ.sort((a, b) -> {
                        double da = a.func_177954_c(TileEntityRendererDispatcher.field_147554_b, TileEntityRendererDispatcher.field_147555_c, TileEntityRendererDispatcher.field_147552_d) * 100.0;
                        double db = b.func_177954_c(TileEntityRendererDispatcher.field_147554_b, TileEntityRendererDispatcher.field_147555_c, TileEntityRendererDispatcher.field_147552_d) * 100.0;
                        return (int)(db - da);
                    });
                    prof.func_76319_b();
                }
            }
            catch (IllegalAccessException | IllegalArgumentException | ConcurrentModificationException exception) {
                // empty catch block
            }
            prof.func_76319_b();
        } else {
            this.sounding.clear();
            this.excludesRAJ.clear();
        }
        if (world != null && (kb = Minecraft.func_71410_x().field_71474_y.field_74312_F).func_151470_d() != this.keyBindAttack) {
            this.keyBindAttack = kb.func_151470_d();
            HCNet.INSTANCE.sendToServer((IPacket)new PacketLeftClick(this.keyBindAttack));
        }
        if (mithminiteHelm && (over = Minecraft.func_71410_x().field_71476_x) != null && over.field_72313_a == RayTraceResult.Type.BLOCK && world.func_175625_s(over.func_178782_a()) instanceof TileSeal) {
            if (this.sealHoverTime_MH < 20) {
                ++this.sealHoverTime_MH;
            } else {
                this.seal_MH = new WeakReference<TileSeal>((TileSeal)world.func_175625_s(over.func_178782_a()));
            }
        } else {
            this.seal_MH = null;
            this.sealHoverTime_MH = 0;
        }
    }

    @SubscribeEvent
    public void soundEvent(PlaySoundEvent e) {
        if (e.getSound() instanceof PositionedSound) {
            PositionedSound ps = (PositionedSound)e.getSound();
            Field volume = PositionedSound.class.getDeclaredFields()[4];
            volume.setAccessible(true);
            if (volume.getType() == Float.TYPE) {
                try {
                    float f = volume.getFloat(ps);
                    if (Minecraft.func_71410_x().field_71439_g != null) {
                        IAttributeInstance ss = Minecraft.func_71410_x().field_71439_g.func_110148_a(AttributesTAR.SOUND_SENSIVITY);
                        f *= (float)ss.func_111126_e();
                    }
                    volume.setFloat(ps, f);
                }
                catch (Throwable err) {
                    err.printStackTrace();
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void tooltipEvent(ItemTooltipEvent e) {
        AspectList salt;
        ItemStack stack = e.getItemStack();
        if (!stack.func_190926_b() && Foods.isFood(stack.func_77973_b()) && (salt = EdibleAspect.getSalt(stack)).visSize() > 0) {
            e.getToolTip().add(I18n.func_135052_a((String)"tooltip.thaumadditions:vis", (Object[])new Object[]{salt.visSize(), 32}));
            for (Aspect a : salt.getAspectsSortedByName()) {
                e.getToolTip().add(a.getName() + " x" + salt.getAmount(a));
            }
        }
        if (stack.func_77973_b() instanceof ItemArmor && stack.func_77942_o() && stack.func_77978_p().func_74767_n("TAR_PHANTOM")) {
            e.getToolTip().add(TextFormatting.DARK_AQUA + I18n.func_135052_a((String)"tooltip.thaumadditions:phantom", (Object[])new Object[0]));
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void renderWorldLast(RenderWorldLastEvent e) {
        EntityFluxRift rift;
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (player == null) {
            return;
        }
        Profiler prof = Minecraft.func_71410_x().field_71424_I;
        prof.func_76320_a("sounding_render_ores");
        BlockRendererDispatcher brd = Minecraft.func_71410_x().func_175602_ab();
        BufferBuilder bb = Tessellator.func_178181_a().func_178180_c();
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        BlockPos origin = this.excludesRAJ.isEmpty() ? BlockPos.field_177992_a : this.excludesRAJ.get(0);
        GlStateManager.func_179094_E();
        GlStateManager.func_179147_l();
        ClientEventReactor.translatePlayerIrrelative(0.0, 0.0, 0.0);
        com.zeitheron.hammercore.client.utils.UtilsFX.bindTexture((String)"minecraft", (String)"textures/entity/end_portal.png");
        if (ShaderEnderField.endShader == null) {
            ShaderEnderField.reloadShader();
        }
        ShaderEnderField.endShader.freeBindShader();
        ARBShaderObjects.glUniform4fARB((int)ShaderEnderField.endShader.getUniformLoc("color"), (float)0.044f, (float)0.036f, (float)0.063f, (float)0.2f);
        GlStateManager.func_179097_i();
        bb.func_181668_a(7, DefaultVertexFormats.field_176600_a);
        int c = this.excludesRAJ.size();
        for (int i = 0; i < c; ++i) {
            BlockPos pos = this.excludesRAJ.get(i);
            IBlockState state = world.func_180495_p(pos).func_185899_b((IBlockAccess)world, pos);
            IBakedModel model = brd.func_184389_a(state);
            state = state.func_177230_c().getExtendedState(state, (IBlockAccess)world, pos);
            brd.func_175019_b().func_178267_a((IBlockAccess)this.ores, model, state, pos, bb, true);
        }
        Tessellator.func_178181_a().func_78381_a();
        ShaderProgram.unbindShader();
        GlStateManager.func_179126_j();
        GlStateManager.func_179121_F();
        prof.func_76319_b();
        if (this.voidThaumometer && (rift = ItemVoidThaumometer.getSelectedRift()) != null) {
            double x = 0.0;
            double y = 0.0;
            double z = 0.0;
            for (Vec3d p : rift.points) {
                x += p.field_72450_a;
                y += p.field_72448_b;
                z += p.field_72449_c;
            }
            int np = rift.points.size();
            x /= (double)np;
            y /= (double)np;
            z /= (double)np;
            x += rift.field_70165_t;
            y += rift.field_70163_u + 1.0;
            z += rift.field_70161_v;
            if (Minecraft.func_71410_x().func_175606_aa() instanceof EntityPlayer) {
                String text = I18n.func_135052_a((String)("stability." + rift.getStability()), (Object[])new Object[0]) + (rift.getCollapse() ? ", Collapsing..." : "");
                float scale = 1.5f;
                float partialTicks = e.getPartialTicks();
                player = (EntityPlayer)Minecraft.func_71410_x().func_175606_aa();
                double iPX = player.field_70169_q + (player.field_70165_t - player.field_70169_q) * (double)partialTicks;
                double iPY = player.field_70167_r + (player.field_70163_u - player.field_70167_r) * (double)partialTicks;
                double iPZ = player.field_70166_s + (player.field_70161_v - player.field_70166_s) * (double)partialTicks;
                GL11.glPushMatrix();
                GL11.glTranslated((double)(-iPX + x + 0.5), (double)(-iPY + y + 0.5), (double)(-iPZ + z + 0.5));
                float xd = (float)(iPX - (x + 0.5));
                float zd = (float)(iPZ - (z + 0.5));
                float rotYaw = (float)(Math.atan2(xd, zd) * 180.0 / Math.PI);
                GL11.glRotatef((float)(rotYaw + 180.0f), (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                GL11.glScalef((float)(0.02f * scale), (float)(0.02f * scale), (float)(0.02f * scale));
                int sw = Minecraft.func_71410_x().field_71466_p.func_78256_a(text);
                GL11.glEnable((int)3042);
                GL11.glBlendFunc((int)770, (int)771);
                Minecraft.func_71410_x().field_71466_p.func_78276_b(text, 1 - sw / 2, 1, 0x111111);
                GL11.glTranslated((double)0.0, (double)0.0, (double)-0.1);
                Minecraft.func_71410_x().field_71466_p.func_78276_b(text, -sw / 2, 0, 0xFFFFFF);
                GL11.glPopMatrix();
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void preRenderPlayer(RenderPlayerEvent.Pre e) {
        EntityPlayer player = e.getEntityPlayer();
        for (EntityEquipmentSlot s : EntityEquipmentSlot.values()) {
            ItemStack stack;
            if (s.func_188452_c() == 0 || s.func_188452_c() == 5 || (stack = player.func_184582_a(s)).func_190926_b() || !stack.func_77942_o() || !stack.func_77978_p().func_74767_n("TAR_PHANTOM")) continue;
            player.field_71071_by.field_70460_b.set(s.func_188454_b(), (Object)ItemStack.field_190927_a);
            this.armor.put(s, stack);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void postRenderPlayer(RenderPlayerEvent.Post e) {
        EntityPlayer player = e.getEntityPlayer();
        for (EntityEquipmentSlot s : EntityEquipmentSlot.values()) {
            if (s.func_188452_c() == 0 || s.func_188452_c() == 5 || !this.armor.containsKey(s)) continue;
            player.field_71071_by.field_70460_b.set(s.func_188454_b(), (Object)this.armor.remove(s));
        }
    }

    @SubscribeEvent
    public void renderTick(TickEvent.RenderTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            Minecraft mc = FMLClientHandler.instance().getClient();
            if (Minecraft.func_71410_x().func_175606_aa() instanceof EntityPlayer) {
                EntityPlayer player = (EntityPlayer)Minecraft.func_71410_x().func_175606_aa();
                long time = System.currentTimeMillis();
                if (player != null) {
                    this.renderHuds(mc, event.renderTickTime, player, time);
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    void renderHuds(Minecraft mc, float renderTickTime, EntityPlayer player, long time) {
        GL11.glPushMatrix();
        ScaledResolution sr = new ScaledResolution(Minecraft.func_71410_x());
        GL11.glClear((int)256);
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        GL11.glOrtho((double)0.0, (double)sr.func_78327_c(), (double)sr.func_78324_d(), (double)0.0, (double)1000.0, (double)3000.0);
        GL11.glMatrixMode((int)5888);
        GL11.glLoadIdentity();
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-2000.0f);
        int ww = sr.func_78326_a();
        int hh = sr.func_78328_b();
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        if (mc.field_71415_G && Minecraft.func_71382_s()) {
            TileSeal seal;
            com.zeitheron.hammercore.client.utils.UtilsFX.bindTexture((String)"thaumcraft", (String)"textures/gui/hud.png");
            ItemStack handStack = player.func_184614_ca();
            boolean rT = false;
            for (int a = 0; a < 2; ++a) {
                if (handStack != null && !handStack.func_190926_b() && !rT && handStack.func_77973_b() instanceof ItemVoidThaumometer) {
                    HudHandlerHookTAR.renderThaumometer(mc, renderTickTime, player, time, ww, hh, 0);
                    rT = true;
                }
                handStack = player.func_184592_cb();
            }
            this.voidThaumometer = rT;
            if (this.seal_MH != null && (seal = (TileSeal)((Object)this.seal_MH.get())) != null) {
                String d;
                int xSize = 192;
                int ySize = 96;
                int guiLeft = (sr.func_78326_a() - xSize) / 2;
                int guiTop = (sr.func_78328_b() - ySize) / 2;
                float size = 32.0f;
                int total = 3;
                double gap = xSize / total;
                for (int i = 0; i < total; ++i) {
                    Aspect s = seal.getSymbol(i);
                    com.zeitheron.hammercore.client.utils.UtilsFX.bindTexture((String)"thaumadditions", (String)"textures/gui/widgets.png");
                    GlStateManager.func_179094_E();
                    float x = (float)((double)((float)guiLeft + ((float)xSize - size) / 2.0f) + gap * (double)(i - 1));
                    float y = guiTop;
                    GlStateManager.func_179109_b((float)x, (float)y, (float)0.0f);
                    GlStateManager.func_179152_a((float)(size / 16.0f), (float)(size / 16.0f), (float)(size / 16.0f));
                    RenderUtil.drawTexturedModalRect((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
                    if (s == null) {
                        RenderUtil.drawTexturedModalRect((double)0.0, (double)0.0, (double)0.0, (double)32.0, (double)16.0, (double)16.0);
                    } else {
                        ItemStack is = ItemSealSymbol.createItem(s, 1);
                        mc.func_175599_af().func_180450_b(is, 0, 0);
                        GlStateManager.func_179094_E();
                        GlStateManager.func_179137_b((double)9.5, (double)9.5, (double)350.0);
                        GlStateManager.func_179139_a((double)0.3333333333333333, (double)0.3333333333333333, (double)0.3333333333333333);
                        UtilsFX.drawTag((int)0, (int)0, (Aspect)s, (float)0.0f, (int)0, (double)0.0, (int)771, (float)1.0f, (boolean)false);
                        GlStateManager.func_179121_F();
                    }
                    GlStateManager.func_179121_F();
                }
                String text = seal.combination == null ? I18n.func_135052_a((String)"seal.thaumadditions:none", (Object[])new Object[0]) : ((d = seal.combination.getDescription(seal)) != null ? d : I18n.func_135052_a((String)"seal.thaumadditions:unconfigured", (Object[])new Object[]{seal.combination.getModName(), seal.combination.getAuthor()}));
                FontRenderer fontRenderer = mc.field_71466_p;
                int width = Math.min(fontRenderer.func_78256_a(text), sr.func_78326_a() / 2);
                fontRenderer.func_78279_b(text, (sr.func_78326_a() - width) / 2 + 1, guiTop + 37 + (ySize - 36) / 2, width, -12303292);
                fontRenderer.func_78279_b(text, (sr.func_78326_a() - width) / 2, guiTop + 36 + (ySize - 36) / 2, width, -1);
            }
        }
        GL11.glDisable((int)3042);
        GL11.glPopMatrix();
    }

    private void renderAllAdjacent(World world, BlockPos pos, BufferBuilder bb, BlockRendererDispatcher brd) {
        if (this.excludesRAJ.size() >= 8192 || this.excludesRAJ.contains(pos) || !Utils.isOreBlock((World)world, (BlockPos)pos)) {
            return;
        }
        this.excludesRAJ.add(pos);
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        this.ores.setBlockState(pos, state);
        this.ores.setTileEntity(pos, world.func_175625_s(pos));
        for (EnumFacing face : EnumFacing.field_82609_l) {
            BlockPos rem = pos.func_177972_a(face);
            if (block != world.func_180495_p(rem).func_177230_c() || this.excludesRAJ.contains(rem)) continue;
            this.renderAllAdjacent(world, rem, bb, brd);
        }
    }

    @SubscribeEvent
    public void fixFOV(FOVUpdateEvent e) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (player != null && player.getEntityData().func_74762_e("TAR_LockFOV") > 0) {
            e.setNewfov(1.0f);
        }
    }
}

