/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.thaumicadditions.items;

import com.zeitheron.hammercore.net.HCNet;
import com.zeitheron.hammercore.raytracer.RayTracer;
import com.zeitheron.hammercore.utils.SoundUtil;
import com.zeitheron.hammercore.utils.WorldUtil;
import com.zeitheron.hammercore.utils.base.Cast;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.storage.AnvilChunkLoader;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.zeith.thaumicadditions.ChatTA;
import org.zeith.thaumicadditions.config.ConfigsTAR;
import org.zeith.thaumicadditions.init.ItemsTAR;
import thaumcraft.common.lib.SoundsTC;

public class ItemEntityCell
extends Item {
    public static final Set<Class<? extends Entity>> SAMPLE_BLACKLIST = new HashSet<Class<? extends Entity>>();

    public ItemEntityCell() {
        this.func_77655_b("dna_sample");
        this.func_77625_d(1);
    }

    public static ItemStack sample(@Nullable EntityEntry entry, @Nullable Entity entity) {
        ItemStack stack = new ItemStack((Item)ItemsTAR.ENTITY_CELL);
        NBTTagCompound sampled = ItemEntityCell.sampleNBT(entry, entity);
        if (sampled == null) {
            return stack;
        }
        NBTTagCompound nbt = new NBTTagCompound();
        stack.func_77982_d(nbt);
        nbt.func_74782_a("Entity", (NBTBase)sampled);
        return stack;
    }

    @Nullable
    public static NBTTagCompound sampleNBT(@Nullable EntityEntry entry, @Nullable Entity entity) {
        if (entry == null && entity != null) {
            entry = EntityRegistry.getEntry(entity.getClass());
        }
        if (entry == null) {
            return null;
        }
        if (SAMPLE_BLACKLIST.contains(entry.getEntityClass())) {
            return null;
        }
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74778_a("Id", entry.getRegistryName().toString());
        if (entity != null) {
            nbt.func_74782_a("Data", (NBTBase)entity.serializeNBT());
        }
        return entry.getEgg() == null ? null : nbt;
    }

    @Nullable
    public static Entity createFromDNA(ItemStack sample, World world, Vec3d pos, boolean spawn) {
        Entity ent;
        if (sample.func_190926_b() || !sample.func_77942_o() || !sample.func_77978_p().func_150297_b("Entity", 10)) {
            return null;
        }
        NBTTagCompound nbt = sample.func_77978_p().func_74775_l("Entity");
        EntityEntry entry = (EntityEntry)GameRegistry.findRegistry(EntityEntry.class).getValue(new ResourceLocation(nbt.func_74779_i("Id")));
        if (entry != null && (ent = entry.newInstance(world)) != null) {
            if (nbt.func_150297_b("Data", 10)) {
                ent.deserializeNBT(nbt.func_74775_l("Data"));
            }
            ent.field_70165_t = ent.field_70169_q = pos.field_72450_a;
            ent.field_70163_u = ent.field_70167_r = pos.field_72448_b;
            ent.field_70161_v = ent.field_70166_s = pos.field_72449_c;
            ent.func_70634_a(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c);
            if (spawn && !world.field_72995_K) {
                world.func_72838_d(ent);
            }
            return ent;
        }
        return null;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        double reach = RayTracer.getBlockReachDistance((EntityPlayer)playerIn);
        Vec3d vec3d = playerIn.func_174824_e(1.0f);
        Vec3d vec3d1 = playerIn.func_70676_i(1.0f);
        Vec3d vec3d2 = vec3d.func_72441_c(vec3d1.field_72450_a * reach, vec3d1.field_72448_b * reach, vec3d1.field_72449_c * reach);
        RayTraceResult r = worldIn.func_147447_a(vec3d, vec3d2, false, false, true);
        ItemStack stack = playerIn.func_184586_b(handIn);
        if (!worldIn.field_72995_K && playerIn.func_70093_af()) {
            if (stack.func_77942_o() && stack.func_77978_p().func_150297_b("Entity", 10)) {
                stack.func_77978_p().func_82580_o("Entity");
                HCNet.swingArm((EntityPlayer)playerIn, (EnumHand)handIn);
            }
        } else if (!worldIn.field_72995_K && r != null && r.field_72313_a == RayTraceResult.Type.BLOCK && stack.func_77942_o() && stack.func_77978_p().func_150297_b("Entity", 10)) {
            NBTTagCompound nbttagcompound = stack.func_77978_p().func_74775_l("Entity").func_74775_l("Data");
            BlockPos pos = r.func_178782_a().func_177972_a(r.field_178784_b);
            World world = worldIn;
            nbttagcompound.func_74778_a("id", stack.func_77978_p().func_74775_l("Entity").func_74779_i("Id"));
            UUID uuid = UUID.randomUUID();
            nbttagcompound.func_74778_a("UUID", uuid.toString());
            NBTTagList nbttaglist = nbttagcompound.func_150295_c("Pos", 6);
            double d0 = (double)pos.func_177958_n() + 0.5;
            double d1 = (double)pos.func_177956_o() + 0.5;
            double d2 = (double)pos.func_177952_p() + 0.5;
            Entity entity = AnvilChunkLoader.func_186054_a((NBTTagCompound)nbttagcompound, (World)world, (double)d0, (double)d1, (double)d2, (boolean)false);
            if (entity != null) {
                entity.func_184221_a(uuid);
                WorldServer ws = (WorldServer)Cast.cast((Object)world, WorldServer.class);
                for (int k = 0; k < 16 && ws != null && ws.func_175733_a(entity.func_110124_au()) != null; ++k) {
                    entity.func_184221_a(UUID.randomUUID());
                }
                EntityLiving entityliving = entity instanceof EntityLiving ? (EntityLiving)entity : null;
                entity.func_70012_b(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, world.field_73012_v.nextFloat() * 360.0f, 0.0f);
                AnvilChunkLoader.func_186052_a((Entity)entity, (World)world);
                SoundUtil.playSoundEffect((World)world, (String)SoundsTC.poof.getRegistryName().toString(), (BlockPos)pos, (float)1.0f, (float)1.0f, (SoundCategory)SoundCategory.PLAYERS);
                stack.func_77978_p().func_82580_o("Entity");
                HCNet.swingArm((EntityPlayer)playerIn, (EnumHand)handIn);
            }
        }
        return super.func_77659_a(worldIn, playerIn, handIn);
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            items.add((Object)new ItemStack((Item)this));
            for (EntityEntry e : GameRegistry.findRegistry(EntityEntry.class).getValuesCollection()) {
                if (e.getEgg() == null || ConfigsTAR.entityBlacklist.contains(e.getRegistryName())) continue;
                items.add((Object)ItemEntityCell.sample(e, null));
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack sample, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        if (sample.func_190926_b() || !sample.func_77942_o() || !sample.func_77978_p().func_150297_b("Entity", 10)) {
            tooltip.add(I18n.func_135052_a((String)"item.thaumadditions:dna_sample.blank", (Object[])new Object[0]));
            return;
        }
        NBTTagCompound nbt = sample.func_77978_p().func_74775_l("Entity");
        EntityEntry entry = (EntityEntry)GameRegistry.findRegistry(EntityEntry.class).getValue(new ResourceLocation(nbt.func_74779_i("Id")));
        if (entry != null) {
            tooltip.add(I18n.func_135052_a((String)"item.thaumadditions:dna_sample.entity", (Object[])new Object[0]) + ": " + I18n.func_135052_a((String)("entity." + entry.getName() + ".name"), (Object[])new Object[0]));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public int getColor(ItemStack sample, int layer) {
        if (layer != 1 && layer != 2) {
            return 0xFFFFFF;
        }
        if (sample.func_190926_b() || !sample.func_77942_o() || !sample.func_77978_p().func_150297_b("Entity", 10)) {
            return 0xFFFFFF;
        }
        NBTTagCompound nbt = sample.func_77978_p().func_74775_l("Entity");
        EntityEntry entry = (EntityEntry)GameRegistry.findRegistry(EntityEntry.class).getValue(new ResourceLocation(nbt.func_74779_i("Id")));
        if (entry != null && entry.getEgg() != null) {
            EntityList.EntityEggInfo inf = entry.getEgg();
            return layer == 2 ? inf.field_75611_b : inf.field_75612_c;
        }
        return 0xFFFFFF;
    }

    public boolean onLeftClickEntity(ItemStack stack, EntityPlayer player, Entity entity) {
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt == null) {
            nbt = new NBTTagCompound();
            stack.func_77982_d(nbt);
        }
        EntityEntry ee = EntityRegistry.getEntry(entity.getClass());
        if (!(nbt.func_74764_b("Entity") || player.field_70170_p.field_72995_K || ee == null || ConfigsTAR.entityBlacklist.contains(ee.getRegistryName()))) {
            NBTTagCompound sampled = ItemEntityCell.sampleNBT(null, entity);
            if (sampled != null && !sampled.func_82582_d()) {
                NBTTagCompound data = sampled.func_74775_l("Data");
                if (data.func_74767_n("Leashed")) {
                    data.func_74757_a("Leashed", false);
                    data.func_82580_o("Leash");
                    WorldUtil.spawnItemStack((World)player.field_70170_p, (double)entity.field_70165_t, (double)entity.field_70163_u, (double)entity.field_70161_v, (ItemStack)new ItemStack(Items.field_151058_ca));
                }
                nbt.func_74782_a("Entity", (NBTBase)sampled);
                SoundUtil.playSoundEffect((World)player.field_70170_p, (String)SoundsTC.poof.getRegistryName().toString(), (BlockPos)player.func_180425_c(), (float)1.0f, (float)1.0f, (SoundCategory)SoundCategory.PLAYERS);
                entity.func_70106_y();
                return true;
            }
            TextComponentTranslation tct = new TextComponentTranslation("status.thaumadditions:dna_unpickable" + (entity instanceof EntityLivingBase ? "" : ".1"), new Object[0]);
            tct.func_150256_b().func_150238_a(TextFormatting.DARK_RED);
            ChatTA.sendMessage(player, (ITextComponent)tct);
            SoundUtil.playSoundEffect((World)player.field_70170_p, (String)SoundsTC.wandfail.getRegistryName().toString(), (BlockPos)player.func_180425_c(), (float)1.0f, (float)1.0f, (SoundCategory)SoundCategory.PLAYERS);
        }
        return false;
    }
}

