/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.thaumicadditions.items.weapons;

import com.zeitheron.hammercore.client.gui.IGuiCallback;
import com.zeitheron.hammercore.client.render.item.IItemRender;
import com.zeitheron.hammercore.client.render.vertex.SimpleBlockRendering;
import com.zeitheron.hammercore.client.utils.RenderBlocks;
import com.zeitheron.hammercore.internal.GuiManager;
import com.zeitheron.hammercore.net.HCNet;
import com.zeitheron.hammercore.utils.SoundUtil;
import com.zeitheron.hammercore.utils.WorldLocation;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumHandSide;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;
import org.zeith.thaumicadditions.api.AspectUtil;
import org.zeith.thaumicadditions.api.animator.BaseItemAnimator;
import org.zeith.thaumicadditions.api.animator.IAnimatableItem;
import org.zeith.thaumicadditions.api.animator.ItemShootableWeaponAnimator;
import org.zeith.thaumicadditions.api.items.EssentiaJarManager;
import org.zeith.thaumicadditions.entity.EntityEssentiaShot;
import org.zeith.thaumicadditions.init.GuisTAR;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;

public class ItemEssentiaPistol
extends Item
implements IAnimatableItem {
    final AspectList emptylist = new AspectList();

    public ItemEssentiaPistol() {
        this.func_77655_b("essentia_pistol");
        this.func_77625_d(1);
    }

    public static void setJar(ItemStack pistol, ItemStack jar) {
        if (!pistol.func_190926_b()) {
            if (!pistol.func_77942_o()) {
                pistol.func_77982_d(new NBTTagCompound());
            }
            pistol.func_77978_p().func_74782_a("Jar", (NBTBase)jar.serializeNBT());
        }
    }

    public static ItemStack getJar(ItemStack pistol) {
        if (!pistol.func_190926_b() && pistol.func_77942_o() && pistol.func_77978_p().func_74764_b("Jar")) {
            return new ItemStack(pistol.func_77978_p().func_74775_l("Jar"));
        }
        return ItemStack.field_190927_a;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        AspectList list;
        int i = stack.func_77942_o() ? stack.func_77978_p().func_74762_e("Count") : 1;
        tooltip.add(I18n.func_135052_a((String)"tooltip.thaumadditions:essentia_pistol.shoot", (Object[])new Object[]{i}));
        ItemStack jarStack = ItemEssentiaPistol.getJar(stack);
        EssentiaJarManager.IJar jar = EssentiaJarManager.fromStack(jarStack);
        AspectList aspectList = list = jar != null ? jar.getEssentia(jarStack) : this.emptylist;
        if (list != null) {
            for (Aspect a : list.getAspectsSortedByAmount()) {
                tooltip.add(" - " + a.getName() + " x" + String.format("%,d", list.getAmount(a)));
            }
        }
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        AspectList aspects;
        if (playerIn.func_70093_af()) {
            GuiManager.openGuiCallback((IGuiCallback)GuisTAR.ESSENTIA_PISTOL, (EntityPlayer)playerIn, (WorldLocation)new WorldLocation(worldIn, playerIn.func_180425_c()));
            return new ActionResult(EnumActionResult.SUCCESS, (Object)playerIn.func_184586_b(handIn));
        }
        ItemStack stack = playerIn.func_184586_b(handIn);
        ItemStack jarStack = ItemEssentiaPistol.getJar(stack);
        EssentiaJarManager.IJar jar = EssentiaJarManager.fromStack(jarStack);
        AspectList aspectList = aspects = jar != null ? jar.getEssentia(jarStack) : this.emptylist;
        if (aspects != null && aspects.visSize() > 0) {
            if (!worldIn.field_72995_K) {
                Aspect as = aspects.getAspects()[0];
                if (as == null) {
                    return super.func_77659_a(worldIn, playerIn, handIn);
                }
                int amt = Math.min(Math.max(stack.func_77978_p().func_74762_e("Count"), 1), aspects.getAmount(as));
                AspectList a = new AspectList();
                a.add(as, amt);
                EntityEssentiaShot shot = new EntityEssentiaShot(worldIn, (EntityLivingBase)playerIn, a);
                EnumHandSide hs = playerIn.func_184591_cq();
                int shift = hs == EnumHandSide.RIGHT && handIn == EnumHand.MAIN_HAND || hs == EnumHandSide.LEFT && handIn == EnumHand.OFF_HAND ? 90 : -90;
                float yaw = playerIn.field_70177_z + (float)shift;
                float pitch = playerIn.field_70125_A;
                float f = MathHelper.func_76134_b((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
                float f1 = MathHelper.func_76126_a((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
                float f2 = -MathHelper.func_76134_b((float)(-pitch * ((float)Math.PI / 180)));
                float f3 = MathHelper.func_76126_a((float)(-pitch * ((float)Math.PI / 180)));
                Vec3d look = new Vec3d((double)(f1 * f2), (double)f3, (double)(f * f2));
                Vec3d actualLook = playerIn.func_70676_i(1.0f).func_186678_a((double)0.4f);
                shot.field_70165_t += look.field_72450_a * (double)0.45f + actualLook.field_72450_a;
                shot.field_70163_u += actualLook.field_72448_b;
                shot.field_70161_v += look.field_72449_c * (double)0.45f + actualLook.field_72449_c;
                shot.func_184538_a((Entity)playerIn, playerIn.field_70125_A, playerIn.field_70177_z, 0.0f, 1.5f, 0.0f);
                worldIn.func_72838_d((Entity)shot);
                if (!playerIn.field_71075_bZ.field_75098_d) {
                    jar.drain(jarStack, as, amt);
                    ItemEssentiaPistol.setJar(stack, jarStack);
                }
                HCNet.swingArm((EntityPlayer)playerIn, (EnumHand)handIn);
                SoundUtil.playSoundEffect((World)worldIn, (String)"thaumadditions:essentia_pistol_shoot", (double)playerIn.field_70165_t, (double)playerIn.field_70163_u, (double)playerIn.field_70161_v, (float)1.0f, (float)1.0f, (SoundCategory)SoundCategory.PLAYERS);
            }
            playerIn.func_184811_cZ().func_185145_a((Item)this, 10);
        }
        return super.func_77659_a(worldIn, playerIn, handIn);
    }

    @Override
    public BaseItemAnimator getAnimator(ItemStack stack) {
        return ItemShootableWeaponAnimator.DEF_0125;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public float overrideSwing(float amount, ItemStack stack, EntityPlayer player, float partialTime) {
        return amount;
    }

    @SideOnly(value=Side.CLIENT)
    public static class ItemRendererEssentiaPistol
    implements IItemRender {
        final AspectList emptylist = new AspectList();

        public void renderItem(ItemStack item) {
            AspectList list;
            ItemStack jarStack = ItemEssentiaPistol.getJar(item);
            EssentiaJarManager.IJar jar = EssentiaJarManager.fromStack(jarStack);
            AspectList aspectList = list = jar != null ? jar.getEssentia(jarStack) : this.emptylist;
            if (list == null || list.visSize() == 0) {
                return;
            }
            float fill = (float)list.visSize() / Math.max(1.0f, (float)jar.capacity(jarStack));
            int color = AspectUtil.getColor(list, true);
            GlStateManager.func_179094_E();
            GlStateManager.func_179123_a();
            GlStateManager.func_179084_k();
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glDisable((int)2896);
            GlStateManager.func_179114_b((float)22.5f, (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            SimpleBlockRendering sbr = RenderBlocks.forMod((String)"thaumadditions").simpleRenderer;
            sbr.begin();
            sbr.setSprite(Minecraft.func_71410_x().func_147117_R().func_110572_b("thaumcraft:blocks/animatedglow"));
            Arrays.fill(sbr.rgb, color);
            sbr.setRenderBounds((double)0.475f, (double)0.57f, (double)0.495f, (double)0.56f, (double)(0.57f + 0.18f * fill), (double)0.586f);
            sbr.setBrightness(255);
            sbr.drawBlock(0.0, (double)-0.025f, (double)-0.02f);
            sbr.end();
            GL11.glEnable((int)2896);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179099_b();
            GlStateManager.func_179121_F();
        }
    }
}

