/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.thaumicadditions.tiles;

import com.zeitheron.hammercore.tile.ITileDroppable;
import com.zeitheron.hammercore.tile.TileSyncableTickable;
import com.zeitheron.hammercore.utils.InterItemStack;
import com.zeitheron.hammercore.utils.ItemStackUtil;
import com.zeitheron.hammercore.utils.color.ColorHelper;
import com.zeitheron.hammercore.utils.inventory.InventoryDummy;
import net.minecraft.client.particle.Particle;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.zeith.thaumicadditions.api.AspectUtil;
import org.zeith.thaumicadditions.init.BlocksTAR;
import org.zeith.thaumicadditions.inventory.container.ContainerGrowthChamber;
import org.zeith.thaumicadditions.inventory.gui.GuiGrowthChamber;
import org.zeith.thaumicadditions.net.PacketBlockEvent;
import thaumcraft.api.ThaumcraftApiHelper;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.aspects.IAspectContainer;
import thaumcraft.api.aspects.IEssentiaTransport;
import thaumcraft.api.aura.AuraHelper;
import thaumcraft.api.items.ItemsTC;
import thaumcraft.client.fx.FXDispatcher;
import thaumcraft.client.fx.ParticleEngine;
import thaumcraft.client.fx.particles.FXVisSparkle;

public class TileGrowthChamber
extends TileSyncableTickable
implements IEssentiaTransport,
IAspectContainer,
ITileDroppable {
    public static final float MAX_AURA_DRAIN = 20.0f;
    public final InventoryDummy growthInventory = new InventoryDummy(2);
    public Aspect slotAspect;
    public int amount;
    public int capacity = 6;
    public float toDrainAura = 20.0f;

    public TileGrowthChamber() {
        this.growthInventory.validSlots = (index, stack) -> index == 0 && stack.func_77973_b() == BlocksTAR.CRYSTAL_BLOCK.getItemBlock();
    }

    public static boolean itemsEqual(ItemStack a, ItemStack b) {
        if (InterItemStack.isStackNull((ItemStack)a) || InterItemStack.isStackNull((ItemStack)b)) {
            return false;
        }
        return a.func_77973_b() == b.func_77973_b() && a.func_77952_i() == b.func_77952_i() && ItemStackUtil.tagsEqual((NBTTagCompound)a.func_77978_p(), (NBTTagCompound)b.func_77978_p());
    }

    public void tick() {
        if (!this.growthInventory.func_70301_a(1).func_190926_b() && this.growthInventory.func_70301_a(1).func_190916_E() >= this.growthInventory.func_70301_a(1).func_77976_d()) {
            return;
        }
        this.slotAspect = !this.growthInventory.func_70301_a(0).func_190926_b() && this.growthInventory.func_70301_a(0).func_77973_b() == BlocksTAR.CRYSTAL_BLOCK.getItemBlock() ? AspectUtil.getAspectFromCrystalBlockStack(this.growthInventory.func_70301_a(0)) : null;
        if (this.slotAspect == null) {
            if (this.amount > 0) {
                AuraHelper.polluteAura((World)this.field_145850_b, (BlockPos)this.field_174879_c, (float)this.amount, (boolean)true);
                this.amount = 0;
                this.sendChangesToNearby();
            }
            if (20.0f - this.toDrainAura > 0.0f) {
                AuraHelper.addVis((World)this.field_145850_b, (BlockPos)this.field_174879_c, (float)(20.0f - this.toDrainAura));
                this.toDrainAura = 20.0f;
            }
            return;
        }
        if (!this.field_145850_b.field_72995_K) {
            for (EnumFacing rf : EnumFacing.field_82609_l) {
                int taken;
                int amt;
                Aspect lasp;
                IEssentiaTransport l = (IEssentiaTransport)ThaumcraftApiHelper.getConnectableTile((World)this.field_145850_b, (BlockPos)this.field_174879_c, (EnumFacing)rf.func_176734_d());
                if (l == null || !l.canOutputTo(rf) || (lasp = l.getEssentiaType(rf)) != this.slotAspect || (amt = this.capacity - this.amount) <= 0 || (taken = l.takeEssentia(lasp, amt, rf)) <= 0) continue;
                this.amount += taken;
                this.sendChangesToNearby();
            }
        }
        if (this.canCraft()) {
            this.toDrainAura -= AuraHelper.drainVis((World)this.field_145850_b, (BlockPos)this.field_174879_c, (float)0.016666668f, (boolean)false);
            if (this.atTickRate(5) && !this.field_145850_b.field_72995_K) {
                this.sendChangesToNearby();
            }
            if (this.atTickRate(10) && !this.field_145850_b.field_72995_K) {
                PacketBlockEvent.performBlockEvent(this.field_145850_b, this.field_174879_c, 1, 0);
            }
            if (this.toDrainAura <= 0.0f) {
                this.craft();
                --this.amount;
                this.toDrainAura += 20.0f;
            }
        }
    }

    public boolean canCraft() {
        if (!this.growthInventory.func_70301_a(1).func_190926_b() && this.growthInventory.func_70301_a(1).func_190916_E() >= this.growthInventory.func_70301_a(1).func_77976_d()) {
            return false;
        }
        if (!this.growthInventory.func_70301_a(0).func_190926_b() && this.growthInventory.func_70301_a(0).func_77973_b() == BlocksTAR.CRYSTAL_BLOCK.getItemBlock() && this.slotAspect != null) {
            return this.amount > 0;
        }
        return false;
    }

    public void craft() {
        ItemStack is;
        if (this.growthInventory.func_70301_a(1).func_190926_b()) {
            ItemStack is2 = AspectUtil.crystalEssence(AspectUtil.getAspectFromCrystalBlockStack(this.growthInventory.func_70301_a(0)));
            is2.func_190920_e(1);
            this.growthInventory.func_70299_a(1, is2);
        } else if (!this.growthInventory.func_70301_a(1).func_190926_b() && this.growthInventory.func_70301_a(1).func_77973_b() == ItemsTC.crystalEssence && (is = this.growthInventory.func_70301_a(1)).func_190916_E() + 1 <= is.func_77976_d()) {
            is.func_190917_f(1);
        }
    }

    public boolean doDrainAura(float vis) {
        float drained = AuraHelper.drainVis((World)this.field_145850_b, (BlockPos)this.field_174879_c, (float)vis, (boolean)true);
        if (drained >= vis) {
            AuraHelper.drainVis((World)this.field_145850_b, (BlockPos)this.field_174879_c, (float)vis, (boolean)false);
            return true;
        }
        return false;
    }

    public void writeNBT(NBTTagCompound nbt) {
        nbt.func_74782_a("Items", (NBTBase)this.growthInventory.writeToNBT(new NBTTagCompound()));
        nbt.func_74776_a("Aura", this.toDrainAura);
        nbt.func_74768_a("Amount", this.amount);
    }

    public void readNBT(NBTTagCompound nbt) {
        this.growthInventory.readFromNBT(nbt.func_74775_l("Items"));
        this.toDrainAura = nbt.func_74760_g("Aura");
        this.amount = nbt.func_74762_e("Amount");
    }

    public boolean hasGui() {
        return true;
    }

    public Object getClientGuiElement(EntityPlayer player) {
        return new GuiGrowthChamber(player, this);
    }

    public Object getServerGuiElement(EntityPlayer player) {
        return new ContainerGrowthChamber(player, this);
    }

    public void createDrop(EntityPlayer player, World world, BlockPos pos) {
        this.growthInventory.drop(world, pos);
        if (!world.field_72995_K) {
            AuraHelper.polluteAura((World)world, (BlockPos)pos, (float)this.amount, (boolean)true);
        }
    }

    public AspectList getAspects() {
        AspectList al = new AspectList();
        if (this.slotAspect != null) {
            al.add(this.slotAspect, this.amount);
        }
        return al;
    }

    public void setAspects(AspectList var1) {
        if (this.slotAspect != null) {
            this.amount = var1.getAmount(this.slotAspect);
            this.sendChangesToNearby();
        }
    }

    public boolean doesContainerAccept(Aspect var1) {
        return this.slotAspect != null && this.slotAspect == var1;
    }

    public int addToContainer(Aspect var1, int var2) {
        if (this.slotAspect != null && this.slotAspect == var1) {
            int ma = Math.min(var2, this.capacity - this.amount);
            this.amount += ma;
            this.sendChangesToNearby();
            return ma;
        }
        return 0;
    }

    public boolean takeFromContainer(Aspect var1, int var2) {
        return false;
    }

    public boolean takeFromContainer(AspectList var1) {
        return false;
    }

    public boolean doesContainerContainAmount(Aspect var1, int var2) {
        return this.slotAspect != null && this.slotAspect == var1 && this.amount >= var2;
    }

    public boolean doesContainerContain(AspectList var1) {
        return this.slotAspect != null && this.amount >= var1.getAmount(this.slotAspect);
    }

    public int containerContains(Aspect var1) {
        return this.slotAspect != null && this.slotAspect == var1 ? this.amount : 0;
    }

    public boolean isConnectable(EnumFacing var1) {
        return this.canInputFrom(var1);
    }

    public boolean canInputFrom(EnumFacing var1) {
        return true;
    }

    public boolean canOutputTo(EnumFacing var1) {
        return false;
    }

    public void setSuction(Aspect var1, int var2) {
    }

    public Aspect getSuctionType(EnumFacing var1) {
        return this.canInputFrom(var1) && this.slotAspect != null ? this.slotAspect : null;
    }

    public int getSuctionAmount(EnumFacing f) {
        return this.canInputFrom(f) ? 128 : 0;
    }

    public int takeEssentia(Aspect var1, int var2, EnumFacing var3) {
        return 0;
    }

    public int addEssentia(Aspect var1, int var2, EnumFacing var3) {
        return this.slotAspect != null ? this.addToContainer(var1, var2) : 0;
    }

    public Aspect getEssentiaType(EnumFacing var1) {
        return this.canInputFrom(var1) ? this.slotAspect : null;
    }

    public int getEssentiaAmount(EnumFacing var1) {
        return this.canInputFrom(var1) ? this.amount : 0;
    }

    public int getMinimumSuction() {
        return 0;
    }

    public boolean func_145842_c(int id, int type) {
        int rays = 2;
        if (id == 1 && this.field_145850_b.field_72995_K) {
            for (int i = 0; i < rays; ++i) {
                float deg = (float)(this.ticksExisted * 12) + (float)i * (360.0f / (float)rays);
                float rad = (float)Math.toRadians(deg);
                float sin = (float)Math.sin(rad);
                float cos = (float)Math.cos(rad);
                this.visSparkle((float)this.field_174879_c.func_177958_n() + 0.5f + cos * this.getRNG().nextFloat() * 6.0f, (float)this.field_174879_c.func_177956_o() + 1.5f + this.getRNG().nextFloat() * 4.0f, (float)this.field_174879_c.func_177952_p() + 0.5f + sin * this.getRNG().nextFloat() * 6.0f, (float)this.field_174879_c.func_177958_n() + cos * 0.3f + 0.5f, (float)this.field_174879_c.func_177956_o() + 0.5f, (float)this.field_174879_c.func_177952_p() + sin * 0.3f + 0.5f, Aspect.AURA.getColor());
            }
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void visSparkle(float x, float y, float z, float x2, float y2, float z2, int color) {
        FXVisSparkle fb = new FXVisSparkle(FXDispatcher.INSTANCE.getWorld(), (double)x, (double)y, (double)z, (double)x2, (double)y2, (double)z2);
        fb.func_70538_b(ColorHelper.getRed((int)color), ColorHelper.getGreen((int)color), ColorHelper.getBlue((int)color));
        ParticleEngine.addEffect((World)FXDispatcher.INSTANCE.getWorld(), (Particle)fb);
    }
}

