/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumicaugmentation.api.impetus;

import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import thecodex6824.thaumicaugmentation.api.entity.DamageSourceImpetus;
import thecodex6824.thaumicaugmentation.api.impetus.CapabilityImpetusStorage;
import thecodex6824.thaumicaugmentation.api.impetus.IImpetusStorage;
import thecodex6824.thaumicaugmentation.common.network.PacketParticleEffect;
import thecodex6824.thaumicaugmentation.common.network.TANetwork;

public final class ImpetusAPI {
    public static final String ENERGY_NONE = "thaumicaugmentation.text.energy_none";
    public static final String ENERGY_MINIMAL = "thaumicaugmentation.text.energy_minimal";
    public static final String ENERGY_VERY_WEAK = "thaumicaugmentation.text.energy_very_weak";
    public static final String ENERGY_WEAK = "thaumicaugmentation.text.energy_weak";
    public static final String ENERGY_MEDIUM = "thaumicaugmentation.text.energy_medium";
    public static final String ENERGY_STRONG = "thaumicaugmentation.text.energy_strong";
    public static final String ENERGY_MAX = "thaumicaugmentation.text.energy_max";

    private ImpetusAPI() {
    }

    public static String getEnergyAmountDescriptor(IImpetusStorage storage) {
        if (storage.getEnergyStored() <= 0L) {
            return ENERGY_NONE;
        }
        if ((double)storage.getEnergyStored() / (double)storage.getMaxEnergyStored() <= 0.1) {
            return ENERGY_MINIMAL;
        }
        if ((double)storage.getEnergyStored() / (double)storage.getMaxEnergyStored() <= 0.25) {
            return ENERGY_VERY_WEAK;
        }
        if ((double)storage.getEnergyStored() / (double)storage.getMaxEnergyStored() <= 0.5) {
            return ENERGY_WEAK;
        }
        if ((double)storage.getEnergyStored() / (double)storage.getMaxEnergyStored() <= 0.75) {
            return ENERGY_MEDIUM;
        }
        if (storage.getEnergyStored() < storage.getMaxEnergyStored()) {
            return ENERGY_STRONG;
        }
        return ENERGY_MAX;
    }

    public static TextFormatting getSuggestedChatColorForDescriptor(IImpetusStorage storage) {
        if (storage.getEnergyStored() <= 0L) {
            return TextFormatting.DARK_RED;
        }
        if ((double)storage.getEnergyStored() / (double)storage.getMaxEnergyStored() <= 0.1) {
            return TextFormatting.RED;
        }
        if ((double)storage.getEnergyStored() / (double)storage.getMaxEnergyStored() <= 0.25) {
            return TextFormatting.GOLD;
        }
        if ((double)storage.getEnergyStored() / (double)storage.getMaxEnergyStored() <= 0.5) {
            return TextFormatting.YELLOW;
        }
        if ((double)storage.getEnergyStored() / (double)storage.getMaxEnergyStored() <= 0.75) {
            return TextFormatting.GREEN;
        }
        if (storage.getEnergyStored() < storage.getMaxEnergyStored()) {
            return TextFormatting.GREEN;
        }
        return TextFormatting.DARK_GREEN;
    }

    public static int getSuggestedColorForDescriptor(IImpetusStorage storage) {
        if (storage.getEnergyStored() <= 0L) {
            return 0xAA0000;
        }
        if ((double)storage.getEnergyStored() / (double)storage.getMaxEnergyStored() <= 0.1) {
            return 0xFF5555;
        }
        if ((double)storage.getEnergyStored() / (double)storage.getMaxEnergyStored() <= 0.25) {
            return 0xFFAA00;
        }
        if ((double)storage.getEnergyStored() / (double)storage.getMaxEnergyStored() <= 0.5) {
            return 0xFFFF55;
        }
        if ((double)storage.getEnergyStored() / (double)storage.getMaxEnergyStored() <= 0.75) {
            return 0x55FF55;
        }
        if (storage.getEnergyStored() < storage.getMaxEnergyStored()) {
            return 0x55FF55;
        }
        return 43520;
    }

    public static void createImpetusParticles(World world, Vec3d origin, Vec3d dest) {
        TANetwork.INSTANCE.sendToAllTracking((IMessage)new PacketParticleEffect(PacketParticleEffect.ParticleEffect.VOID_STREAKS, origin.field_72450_a, origin.field_72448_b, origin.field_72449_c, dest.field_72450_a, dest.field_72448_b, dest.field_72449_c, 0.04f), new NetworkRegistry.TargetPoint(world.field_73011_w.getDimension(), dest.field_72450_a, dest.field_72448_b, dest.field_72449_c, 64.0));
    }

    public static boolean drainEnergyIntoStorage(World world, IImpetusStorage src, IImpetusStorage dest) {
        return ImpetusAPI.drainEnergyIntoStorage(world, src, dest, null, null);
    }

    public static boolean drainEnergyIntoStorage(World world, IImpetusStorage src, IImpetusStorage dest, @Nullable Vec3d effectOrigin, @Nullable Vec3d effectDest) {
        long maxToExtract = dest.getMaxEnergyStored() - dest.getEnergyStored();
        long extracted = src.extractEnergy(maxToExtract, false);
        if (extracted > 0L) {
            dest.receiveEnergy(extracted, false);
            if (effectOrigin != null && effectDest != null) {
                TANetwork.INSTANCE.sendToAllTracking((IMessage)new PacketParticleEffect(PacketParticleEffect.ParticleEffect.VOID_STREAKS, effectOrigin.field_72450_a, effectOrigin.field_72448_b, effectOrigin.field_72449_c, effectDest.field_72450_a, effectDest.field_72448_b, effectDest.field_72449_c, 0.04f), new NetworkRegistry.TargetPoint(world.field_73011_w.getDimension(), effectDest.field_72450_a, effectDest.field_72448_b, effectDest.field_72449_c, 64.0));
            }
            return true;
        }
        return false;
    }

    public static boolean drainNearbyEnergyIntoStorage(World world, IImpetusStorage dest, AxisAlignedBB range) {
        return ImpetusAPI.drainNearbyEnergyIntoStorage(world, dest, range, null);
    }

    public static boolean drainNearbyEnergyIntoStorage(World world, IImpetusStorage dest, AxisAlignedBB range, @Nullable Vec3d effectDest) {
        boolean receivedEnergy = false;
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(0, 0, 0);
        int x = (int)Math.floor(range.field_72340_a);
        while ((double)x < Math.ceil(range.field_72336_d)) {
            int z = (int)Math.floor(range.field_72339_c);
            while ((double)z < Math.ceil(range.field_72334_f)) {
                pos.func_181079_c(x, 0, z);
                int y = (int)Math.floor(range.field_72338_b);
                while ((double)y < Math.ceil(range.field_72337_e)) {
                    long maxToExtract;
                    long extracted;
                    IImpetusStorage storage;
                    TileEntity tile;
                    if (world.func_175667_e((BlockPos)pos) && world.func_175726_f((BlockPos)pos).func_177424_a((BlockPos)pos, Chunk.EnumCreateEntityType.CHECK) != null && (tile = world.func_175625_s((BlockPos)pos)) != null && (storage = (IImpetusStorage)tile.getCapability(CapabilityImpetusStorage.IMPETUS_STORAGE, null)) != null && (extracted = storage.extractEnergy(maxToExtract = dest.getMaxEnergyStored() - dest.getEnergyStored(), false)) > 0L) {
                        dest.receiveEnergy(extracted, false);
                        if (effectDest != null) {
                            TANetwork.INSTANCE.sendToAllTracking((IMessage)new PacketParticleEffect(PacketParticleEffect.ParticleEffect.VOID_STREAKS, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, effectDest.field_72450_a, effectDest.field_72448_b, effectDest.field_72449_c, 0.04f), new NetworkRegistry.TargetPoint(world.field_73011_w.getDimension(), effectDest.field_72450_a, effectDest.field_72448_b, effectDest.field_72449_c, 64.0));
                        }
                        receivedEnergy = true;
                    }
                    if (dest.getEnergyStored() == dest.getMaxEnergyStored()) {
                        return receivedEnergy;
                    }
                    ++y;
                }
                ++z;
            }
            ++x;
        }
        for (Entity entity : world.func_72872_a(Entity.class, range)) {
            long maxToExtract;
            long extracted;
            IImpetusStorage storage = (IImpetusStorage)entity.getCapability(CapabilityImpetusStorage.IMPETUS_STORAGE, null);
            if (storage != null && (extracted = storage.extractEnergy(maxToExtract = dest.getMaxEnergyStored() - dest.getEnergyStored(), false)) > 0L) {
                dest.receiveEnergy(extracted, false);
                if (effectDest != null) {
                    TANetwork.INSTANCE.sendToAllTracking((IMessage)new PacketParticleEffect(PacketParticleEffect.ParticleEffect.VOID_STREAKS, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, effectDest.field_72450_a, effectDest.field_72448_b, effectDest.field_72449_c, 0.04f), new NetworkRegistry.TargetPoint(world.field_73011_w.getDimension(), effectDest.field_72450_a, effectDest.field_72448_b, effectDest.field_72449_c, 64.0));
                }
                receivedEnergy = true;
            }
            if (dest.getEnergyStored() != dest.getMaxEnergyStored()) continue;
            return receivedEnergy;
        }
        return receivedEnergy;
    }

    public static boolean tryExtractFully(IImpetusStorage storage, long amount) {
        if (!storage.canExtract()) {
            return false;
        }
        long total = amount;
        long oldAmount = amount;
        do {
            oldAmount = amount;
        } while ((amount -= storage.extractEnergy(amount, true)) > 0L && oldAmount != amount);
        if (amount <= 0L) {
            oldAmount = total;
            amount = total;
            do {
                oldAmount = amount;
            } while ((amount -= storage.extractEnergy(amount, false)) > 0L && oldAmount != amount);
            return amount <= 0L;
        }
        return false;
    }

    public static boolean tryExtractFully(IImpetusStorage storage, long amount, Entity user) {
        if (user instanceof EntityPlayer && ((EntityPlayer)user).func_184812_l_()) {
            return true;
        }
        return ImpetusAPI.tryExtractFully(storage, amount);
    }

    private static boolean doDamage(DamageSource source1, DamageSource source2, Entity target, float damage) {
        boolean result = target.func_70097_a(source1, damage / 2.0f);
        if (result) {
            if (target instanceof EntityLivingBase) {
                EntityLivingBase base = (EntityLivingBase)target;
                base.field_70172_ad = 0;
                base.field_110153_bc = 0.0f;
            }
            target.func_70097_a(source2, damage / 2.0f);
        }
        return result;
    }

    public static boolean causeImpetusDamage(Entity target, float totalDamage) {
        DamageSource magic = new DamageSourceImpetus(null).func_76348_h().func_82726_p();
        DamageSourceImpetus normal = new DamageSourceImpetus(null);
        return ImpetusAPI.doDamage(magic, normal, target, totalDamage);
    }

    public static boolean causeImpetusDamage(Vec3d source, Entity target, float totalDamage) {
        DamageSource magic = new DamageSourceImpetus(source).func_76348_h().func_82726_p();
        DamageSourceImpetus normal = new DamageSourceImpetus(source);
        return ImpetusAPI.doDamage(magic, normal, target, totalDamage);
    }

    public static boolean causeImpetusDamage(Entity source, Entity target, float totalDamage) {
        DamageSource magic = new DamageSourceImpetus(source, source.func_174791_d()).func_76348_h().func_82726_p();
        DamageSourceImpetus normal = new DamageSourceImpetus(source, source.func_174791_d());
        return ImpetusAPI.doDamage(magic, normal, target, totalDamage);
    }
}

