/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumicaugmentation.api.ward.storage;

import com.google.common.annotations.VisibleForTesting;
import it.unimi.dsi.fastutil.objects.Object2ByteOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ShortOpenHashMap;
import java.util.Arrays;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.fml.common.eventhandler.Event;
import thecodex6824.thaumicaugmentation.api.event.BlockWardEvent;
import thecodex6824.thaumicaugmentation.api.ward.WardSyncManager;
import thecodex6824.thaumicaugmentation.api.ward.storage.IWardStorageServer;

public class WardStorageServer
implements IWardStorageServer,
INBTSerializable<NBTTagCompound> {
    protected StorageManagersServer.IWardStorageManagerServer manager;

    public WardStorageServer() {
        this.manager = new StorageManagersServer.StorageManagerNull();
    }

    @VisibleForTesting
    WardStorageServer(StorageManagersServer.IWardStorageManagerServer toSet) {
        this.manager = toSet;
    }

    @Override
    public int getTotalWardOwners() {
        return this.manager.getNumCurrentOwners();
    }

    @Override
    public UUID getWard(BlockPos pos) {
        return this.manager.getOwner(pos);
    }

    @Override
    public boolean isWardOwner(UUID id) {
        return this.manager.isOwner(id);
    }

    @Override
    public boolean hasWard(BlockPos pos) {
        return !this.getWard(pos).equals(NIL_UUID);
    }

    @Override
    public void clearWard(BlockPos pos) {
        this.manager.setOwner(pos, NIL_UUID);
    }

    @Override
    public void clearWard(BlockPos pos, World syncTo) {
        if (this.hasWard(pos)) {
            BlockWardEvent.DewardedServer.Pre event = new BlockWardEvent.DewardedServer.Pre(syncTo, pos);
            MinecraftForge.EVENT_BUS.post((Event)event);
            if (!event.isCanceled()) {
                this.manager.setOwner(pos, NIL_UUID);
                WardSyncManager.markPosForClear(syncTo, pos);
                MinecraftForge.EVENT_BUS.post((Event)new BlockWardEvent.DewardedServer.Post(syncTo, pos));
            }
        }
    }

    @Override
    public void clearAllWards() {
        this.manager.clearAllOwnersAndWards();
    }

    @Override
    public void clearAllWards(World syncTo, BlockPos inside) {
        this.manager.clearAllOwnersAndWards();
        WardSyncManager.markChunkForFullSync(syncTo, inside);
    }

    protected StorageManagersServer.IWardStorageManagerServer createIncreasedSizeManager() {
        switch (this.manager.getStorageID()) {
            case 0: {
                return new StorageManagersServer.StorageManager1Bit(this.manager);
            }
            case 1: {
                return new StorageManagersServer.StorageManager2Bits(this.manager);
            }
            case 2: {
                return new StorageManagersServer.StorageManager4Bits(this.manager);
            }
            case 3: {
                return new StorageManagersServer.StorageManagerByte(this.manager);
            }
            case 4: {
                return new StorageManagersServer.StorageManagerShort(this.manager);
            }
        }
        throw new RuntimeException("Invalid ward storage manager growth (other mod interacting?)");
    }

    protected void evaluateManagerSizeDecrease() {
        if (this.manager.getMaxAllowedOwners() != 0 && this.manager.getNumCurrentOwners() == 0) {
            this.manager = new StorageManagersServer.StorageManagerNull(this.manager);
        } else if (this.manager.getMaxAllowedOwners() > 1 && this.manager.getNumCurrentOwners() <= 1) {
            this.manager = new StorageManagersServer.StorageManager1Bit(this.manager);
        } else if (this.manager.getMaxAllowedOwners() > 3 && this.manager.getNumCurrentOwners() <= 3) {
            this.manager = new StorageManagersServer.StorageManager2Bits(this.manager);
        } else if (this.manager.getMaxAllowedOwners() > 15 && this.manager.getNumCurrentOwners() <= 15) {
            this.manager = new StorageManagersServer.StorageManager4Bits(this.manager);
        } else if (this.manager.getMaxAllowedOwners() > 255 && this.manager.getNumCurrentOwners() <= 255) {
            this.manager = new StorageManagersServer.StorageManagerByte(this.manager);
        }
    }

    @Override
    public void setWard(BlockPos pos, UUID owner) {
        if (!this.manager.isOwner(owner)) {
            if (this.manager.getNumCurrentOwners() == this.manager.getMaxAllowedOwners()) {
                this.manager = this.createIncreasedSizeManager();
            }
            this.manager.addOwner(owner);
        }
        this.manager.setOwner(pos, owner);
    }

    @Override
    public void setWard(BlockPos pos, UUID owner, World syncTo) {
        if (!this.getWard(pos).equals(owner)) {
            BlockWardEvent.WardedServer.Pre event = new BlockWardEvent.WardedServer.Pre(syncTo, pos, owner);
            MinecraftForge.EVENT_BUS.post((Event)event);
            if (!event.isCanceled()) {
                if (!this.manager.isOwner(owner)) {
                    if (this.manager.getNumCurrentOwners() == this.manager.getMaxAllowedOwners()) {
                        this.manager = this.createIncreasedSizeManager();
                    }
                    this.manager.addOwner(owner);
                }
                this.manager.setOwner(pos, owner);
                WardSyncManager.markPosForNewOwner(syncTo, pos, owner);
                MinecraftForge.EVENT_BUS.post((Event)new BlockWardEvent.WardedServer.Post(syncTo, pos, owner));
            }
        }
    }

    @Override
    public void removeOwner(UUID owner) {
        if (this.manager.isOwner(owner)) {
            this.manager.removeOwner(owner, true);
        }
    }

    @Override
    @Nullable
    public NBTTagCompound fullSyncToClient(Chunk chunk, UUID player) {
        return this.fullSyncToClient(chunk, player, false);
    }

    @Override
    @Nullable
    public NBTTagCompound fullSyncToClient(Chunk chunk, UUID player, boolean force) {
        if (force || this.manager.getNumCurrentOwners() > 0) {
            NBTTagCompound tag = new NBTTagCompound();
            byte[] data = new byte[StorageManagersServer.CHUNK_DATA_SIZE / 4];
            BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(0, 0, 0);
            for (int x = 0; x < StorageManagersServer.CHUNK_X_SIZE; ++x) {
                for (int z = 0; z < StorageManagersServer.CHUNK_Z_SIZE; ++z) {
                    pos.func_181079_c(x, 0, z);
                    for (int y = 0; y < StorageManagersServer.CHUNK_Y_SIZE; ++y) {
                        pos.func_185336_p(y);
                        int toSet = 0;
                        UUID owner = this.manager.getOwner((BlockPos)pos);
                        if (owner.equals(player)) {
                            toSet = 1;
                        } else if (!owner.equals(IWardStorageServer.NIL_UUID)) {
                            toSet = 2;
                        }
                        int index = (pos.func_177958_n() & 0xF) + (pos.func_177956_o() & 0xFF) * StorageManagersServer.CHUNK_X_SIZE + (pos.func_177952_p() & 0xF) * StorageManagersServer.CHUNK_X_SIZE * StorageManagersServer.CHUNK_Y_SIZE;
                        data[index / 4] = (toSet & 1) != 0 ? (byte)(data[index / 4] | 1 << index % 4 * 2) : (byte)(data[index / 4] & ~(1 << index % 4 * 2));
                        data[index / 4] = (toSet & 2) != 0 ? (byte)(data[index / 4] | 2 << index % 4 * 2) : (byte)(data[index / 4] & ~(2 << index % 4 * 2));
                    }
                }
            }
            tag.func_74773_a("d", data);
            tag.func_74768_a("x", chunk.field_76635_g);
            tag.func_74768_a("z", chunk.field_76647_h);
            return tag;
        }
        return null;
    }

    public NBTTagCompound serializeNBT() {
        this.evaluateManagerSizeDecrease();
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74774_a("s", this.manager.getStorageID());
        tag.func_74782_a("d", (NBTBase)this.manager.serialize());
        return tag;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        byte id = nbt.func_74771_c("s");
        switch (id) {
            case 0: {
                this.manager = new StorageManagersServer.StorageManagerNull();
                break;
            }
            case 1: {
                this.manager = new StorageManagersServer.StorageManager1Bit();
                break;
            }
            case 2: {
                this.manager = new StorageManagersServer.StorageManager2Bits();
                break;
            }
            case 3: {
                this.manager = new StorageManagersServer.StorageManager4Bits();
                break;
            }
            case 4: {
                this.manager = new StorageManagersServer.StorageManagerByte();
                break;
            }
            case 5: {
                this.manager = new StorageManagersServer.StorageManagerShort();
                break;
            }
            default: {
                throw new RuntimeException("Invalid chunk ward storage manager ID");
            }
        }
        this.manager.deserialize(nbt.func_74775_l("d"));
    }

    @VisibleForTesting
    static final class StorageManagersServer {
        public static int CHUNK_X_SIZE = 16;
        public static int CHUNK_Y_SIZE = 256;
        public static int CHUNK_Z_SIZE = 16;
        public static int CHUNK_DATA_SIZE = CHUNK_X_SIZE * CHUNK_Y_SIZE * CHUNK_Z_SIZE;

        private StorageManagersServer() {
        }

        public static class StorageManagerShort
        implements IWardStorageManagerServer {
            protected short[] data = new short[CHUNK_DATA_SIZE];
            protected UUID[] owners;
            protected Object2ShortOpenHashMap<UUID> reverseMap;
            protected char[] counts;

            public StorageManagerShort() {
                Arrays.fill(this.data, (short)Short.MIN_VALUE);
                this.owners = new UUID[this.getMaxAllowedOwners()];
                Arrays.fill(this.owners, IWardStorageServer.NIL_UUID);
                this.reverseMap = new Object2ShortOpenHashMap();
                this.counts = new char[this.getMaxAllowedOwners()];
            }

            public StorageManagerShort(IWardStorageManagerServer other) {
                this();
                if (other.getMaxAllowedOwners() > 0) {
                    for (int i = 0; i < Math.min(this.owners.length, other.getOwners().length); ++i) {
                        this.owners[i] = other.getOwners()[i];
                        this.reverseMap.put((Object)this.owners[i], (short)(i - 32768));
                    }
                    BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(0, 0, 0);
                    for (int x = 0; x < CHUNK_X_SIZE; ++x) {
                        for (int z = 0; z < CHUNK_Z_SIZE; ++z) {
                            pos.func_181079_c(x, 0, z);
                            for (int y = 0; y < CHUNK_Y_SIZE; ++y) {
                                pos.func_185336_p(y);
                                this.setOwner((BlockPos)pos, other.getOwner((BlockPos)pos));
                            }
                        }
                    }
                }
            }

            @Override
            public byte getStorageID() {
                return 5;
            }

            @Override
            public int getNumCurrentOwners() {
                return this.reverseMap.size();
            }

            @Override
            public void addOwner(UUID owner) {
                for (int i = 0; i < this.owners.length; ++i) {
                    if (!this.owners[i].equals(IWardStorageServer.NIL_UUID)) continue;
                    this.owners[i] = owner;
                    this.reverseMap.put((Object)owner, (short)(i - 32768));
                    this.counts[i] = '\u0000';
                    return;
                }
                throw new IndexOutOfBoundsException("Attempted to exceed owner storage capacity");
            }

            @Override
            public boolean isOwner(UUID owner) {
                return this.reverseMap.containsKey((Object)owner);
            }

            @Override
            public void removeOwner(UUID owner) {
                short id = this.reverseMap.removeShort((Object)owner);
                this.owners[id + 32768] = IWardStorageServer.NIL_UUID;
                this.counts[id + 32768] = '\u0000';
            }

            @Override
            public void removeOwner(UUID owner, boolean clear) {
                if (clear) {
                    short id = this.reverseMap.getShort((Object)owner);
                    this.removeOwner(owner);
                    for (int index = 0; index < CHUNK_DATA_SIZE; ++index) {
                        if (this.data[index] != id + 1) continue;
                        this.data[index] = Short.MIN_VALUE;
                    }
                } else {
                    this.removeOwner(owner);
                }
            }

            @Override
            public void clearAllOwnersAndWards() {
                Arrays.fill(this.data, (short)0);
                Arrays.fill(this.owners, IWardStorageServer.NIL_UUID);
                Arrays.fill(this.counts, '\u0000');
                this.reverseMap.clear();
            }

            @Override
            public int getMaxAllowedOwners() {
                return 65535;
            }

            @Override
            public UUID getOwner(BlockPos pos) {
                int index = (pos.func_177958_n() & CHUNK_X_SIZE - 1) + (pos.func_177956_o() & CHUNK_Y_SIZE - 1) * CHUNK_X_SIZE + (pos.func_177952_p() & CHUNK_Z_SIZE - 1) * CHUNK_X_SIZE * CHUNK_Y_SIZE;
                int result = this.data[index] + 32768;
                return result == 0 ? IWardStorageServer.NIL_UUID : this.owners[result - 1];
            }

            @Override
            public void setOwner(BlockPos pos, UUID owner) {
                short toSet;
                int index = (pos.func_177958_n() & CHUNK_X_SIZE - 1) + (pos.func_177956_o() & CHUNK_Y_SIZE - 1) * CHUNK_X_SIZE + (pos.func_177952_p() & CHUNK_Z_SIZE - 1) * CHUNK_X_SIZE * CHUNK_Y_SIZE;
                short s = toSet = !owner.equals(IWardStorageServer.NIL_UUID) ? this.reverseMap.getShort((Object)owner) + 1 : (short)Short.MIN_VALUE;
                if (toSet != Short.MIN_VALUE && toSet != this.data[index]) {
                    int n = toSet + Short.MAX_VALUE;
                    this.counts[n] = (char)(this.counts[n] + '\u0001');
                    this.data[index] = toSet;
                } else if (toSet == Short.MIN_VALUE && this.data[index] != Short.MIN_VALUE) {
                    int oldOwner;
                    int n = oldOwner = this.data[index] + Short.MAX_VALUE;
                    this.counts[n] = (char)(this.counts[n] - '\u0001');
                    this.data[index] = Short.MIN_VALUE;
                    if (this.counts[oldOwner] == '\u0000') {
                        this.removeOwner(this.owners[oldOwner]);
                    }
                }
            }

            @Override
            public UUID[] getOwners() {
                return this.owners;
            }

            private byte[] createByteArray() {
                byte[] dest = new byte[this.data.length * 2];
                for (int i = 0; i < this.data.length; ++i) {
                    dest[i * 2] = (byte)(this.data[i] >>> 8);
                    dest[i * 2 + 1] = (byte)this.data[i];
                }
                return dest;
            }

            @Override
            public NBTTagCompound serialize() {
                NBTTagCompound tag = new NBTTagCompound();
                int ownerCount = 0;
                for (int i = 0; i < this.owners.length && !this.owners[i].equals(IWardStorageServer.NIL_UUID); ++i) {
                    tag.func_186854_a(Integer.toString(i), this.owners[i]);
                    ++ownerCount;
                }
                tag.func_74768_a("o", ownerCount);
                tag.func_74773_a("d", this.createByteArray());
                return tag;
            }

            private void loadByteArray(byte[] src) {
                this.data = new short[CHUNK_DATA_SIZE];
                for (int i = 0; i < this.data.length; ++i) {
                    this.data[i] = (short)((src[i * 2] << 8) + (src[i * 2 + 1] & 0xFF));
                }
            }

            @Override
            public void deserialize(NBTTagCompound tag) {
                for (int i = 0; i < tag.func_74762_e("o"); ++i) {
                    this.owners[i] = tag.func_186857_a(Integer.toString(i));
                    this.reverseMap.put((Object)this.owners[i], (short)(i - 32768));
                }
                this.loadByteArray(tag.func_74770_j("d"));
                if (this.data.length != CHUNK_DATA_SIZE) {
                    throw new RuntimeException("Invalid ward data length");
                }
                for (int index = 0; index < CHUNK_DATA_SIZE; ++index) {
                    int id = this.data[index] + 32768;
                    if (id <= 0) continue;
                    int n = id - 1;
                    this.counts[n] = (char)(this.counts[n] + '\u0001');
                }
            }
        }

        public static class StorageManagerByte
        implements IWardStorageManagerServer {
            protected byte[] data = new byte[CHUNK_DATA_SIZE];
            protected UUID[] owners;
            protected Object2ByteOpenHashMap<UUID> reverseMap;
            protected char[] counts;

            public StorageManagerByte() {
                Arrays.fill(this.data, (byte)-128);
                this.owners = new UUID[this.getMaxAllowedOwners()];
                Arrays.fill(this.owners, IWardStorageServer.NIL_UUID);
                this.reverseMap = new Object2ByteOpenHashMap();
                this.counts = new char[this.getMaxAllowedOwners()];
            }

            public StorageManagerByte(IWardStorageManagerServer other) {
                this();
                if (other.getMaxAllowedOwners() > 0) {
                    for (int i = 0; i < Math.min(this.owners.length, other.getOwners().length); ++i) {
                        this.owners[i] = other.getOwners()[i];
                        this.reverseMap.put((Object)this.owners[i], (byte)(i - 128));
                    }
                    BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(0, 0, 0);
                    for (int x = 0; x < CHUNK_X_SIZE; ++x) {
                        for (int z = 0; z < CHUNK_Z_SIZE; ++z) {
                            pos.func_181079_c(x, 0, z);
                            for (int y = 0; y < CHUNK_Y_SIZE; ++y) {
                                pos.func_185336_p(y);
                                this.setOwner((BlockPos)pos, other.getOwner((BlockPos)pos));
                            }
                        }
                    }
                }
            }

            @Override
            public byte getStorageID() {
                return 4;
            }

            @Override
            public int getNumCurrentOwners() {
                return this.reverseMap.size();
            }

            @Override
            public void addOwner(UUID owner) {
                for (int i = 0; i < this.owners.length; ++i) {
                    if (!this.owners[i].equals(IWardStorageServer.NIL_UUID)) continue;
                    this.owners[i] = owner;
                    this.reverseMap.put((Object)owner, (byte)(i - 128));
                    this.counts[i] = '\u0000';
                    return;
                }
                throw new IndexOutOfBoundsException("Attempted to exceed owner storage capacity");
            }

            @Override
            public boolean isOwner(UUID owner) {
                return this.reverseMap.containsKey((Object)owner);
            }

            @Override
            public void removeOwner(UUID owner) {
                byte id = this.reverseMap.removeByte((Object)owner);
                this.owners[id + 128] = IWardStorageServer.NIL_UUID;
                this.counts[id + 128] = '\u0000';
            }

            @Override
            public void removeOwner(UUID owner, boolean clear) {
                if (clear) {
                    byte id = this.reverseMap.getByte((Object)owner);
                    this.removeOwner(owner);
                    for (int index = 0; index < CHUNK_DATA_SIZE; ++index) {
                        if (this.data[index] != id + 1) continue;
                        this.data[index] = -128;
                    }
                } else {
                    this.removeOwner(owner);
                }
            }

            @Override
            public void clearAllOwnersAndWards() {
                Arrays.fill(this.data, (byte)0);
                Arrays.fill(this.owners, IWardStorageServer.NIL_UUID);
                Arrays.fill(this.counts, '\u0000');
                this.reverseMap.clear();
            }

            @Override
            public int getMaxAllowedOwners() {
                return 255;
            }

            @Override
            public UUID getOwner(BlockPos pos) {
                int index = (pos.func_177958_n() & CHUNK_X_SIZE - 1) + (pos.func_177956_o() & CHUNK_Y_SIZE - 1) * CHUNK_X_SIZE + (pos.func_177952_p() & CHUNK_Z_SIZE - 1) * CHUNK_X_SIZE * CHUNK_Y_SIZE;
                int result = this.data[index] + 128;
                return result == 0 ? IWardStorageServer.NIL_UUID : this.owners[result - 1];
            }

            @Override
            public void setOwner(BlockPos pos, UUID owner) {
                byte toSet;
                int index = (pos.func_177958_n() & CHUNK_X_SIZE - 1) + (pos.func_177956_o() & CHUNK_Y_SIZE - 1) * CHUNK_X_SIZE + (pos.func_177952_p() & CHUNK_Z_SIZE - 1) * CHUNK_X_SIZE * CHUNK_Y_SIZE;
                byte by = toSet = !owner.equals(IWardStorageServer.NIL_UUID) ? this.reverseMap.getByte((Object)owner) + 1 : (byte)-128;
                if (toSet != -128 && toSet != this.data[index]) {
                    int n = toSet + 127;
                    this.counts[n] = (char)(this.counts[n] + '\u0001');
                    this.data[index] = toSet;
                } else if (toSet == -128 && this.data[index] != -128) {
                    int oldOwner;
                    int n = oldOwner = this.data[index] + 127;
                    this.counts[n] = (char)(this.counts[n] - '\u0001');
                    this.data[index] = -128;
                    if (this.counts[oldOwner] == '\u0000') {
                        this.removeOwner(this.owners[oldOwner]);
                    }
                }
            }

            @Override
            public UUID[] getOwners() {
                return this.owners;
            }

            @Override
            public NBTTagCompound serialize() {
                NBTTagCompound tag = new NBTTagCompound();
                int ownerCount = 0;
                for (int i = 0; i < this.owners.length && !this.owners[i].equals(IWardStorageServer.NIL_UUID); ++i) {
                    tag.func_186854_a(Integer.toString(i), this.owners[i]);
                    ++ownerCount;
                }
                tag.func_74768_a("o", ownerCount);
                tag.func_74773_a("d", this.data);
                return tag;
            }

            @Override
            public void deserialize(NBTTagCompound tag) {
                for (int i = 0; i < tag.func_74762_e("o"); ++i) {
                    this.owners[i] = tag.func_186857_a(Integer.toString(i));
                    this.reverseMap.put((Object)this.owners[i], (byte)(i - 128));
                }
                this.data = tag.func_74770_j("d");
                if (this.data.length != CHUNK_DATA_SIZE) {
                    throw new RuntimeException("Invalid ward data length");
                }
                for (int index = 0; index < CHUNK_DATA_SIZE; ++index) {
                    int id = this.data[index] + 128;
                    if (id <= 0) continue;
                    int n = id - 1;
                    this.counts[n] = (char)(this.counts[n] + '\u0001');
                }
            }
        }

        public static class StorageManager4Bits
        implements IWardStorageManagerServer {
            protected byte[] data = new byte[CHUNK_DATA_SIZE / 2];
            protected UUID[] owners = new UUID[this.getMaxAllowedOwners()];
            protected Object2ByteOpenHashMap<UUID> reverseMap;
            protected char[] counts;

            public StorageManager4Bits() {
                Arrays.fill(this.owners, IWardStorageServer.NIL_UUID);
                this.reverseMap = new Object2ByteOpenHashMap();
                this.counts = new char[this.getMaxAllowedOwners()];
            }

            public StorageManager4Bits(IWardStorageManagerServer other) {
                this();
                if (other.getMaxAllowedOwners() > 0) {
                    for (int i = 0; i < Math.min(this.owners.length, other.getOwners().length); ++i) {
                        this.owners[i] = other.getOwners()[i];
                        this.reverseMap.put((Object)this.owners[i], (byte)i);
                    }
                    BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(0, 0, 0);
                    for (int x = 0; x < CHUNK_X_SIZE; ++x) {
                        for (int z = 0; z < CHUNK_Z_SIZE; ++z) {
                            pos.func_181079_c(x, 0, z);
                            for (int y = 0; y < CHUNK_Y_SIZE; ++y) {
                                pos.func_185336_p(y);
                                this.setOwner((BlockPos)pos, other.getOwner((BlockPos)pos));
                            }
                        }
                    }
                }
            }

            @Override
            public byte getStorageID() {
                return 3;
            }

            @Override
            public int getNumCurrentOwners() {
                return this.reverseMap.size();
            }

            @Override
            public void addOwner(UUID owner) {
                for (int i = 0; i < this.owners.length; ++i) {
                    if (!this.owners[i].equals(IWardStorageServer.NIL_UUID)) continue;
                    this.owners[i] = owner;
                    this.reverseMap.put((Object)owner, (byte)i);
                    this.counts[i] = '\u0000';
                    return;
                }
                throw new IndexOutOfBoundsException("Attempted to exceed owner storage capacity");
            }

            @Override
            public boolean isOwner(UUID owner) {
                return this.reverseMap.containsKey((Object)owner);
            }

            @Override
            public void removeOwner(UUID owner) {
                byte id = this.reverseMap.removeByte((Object)owner);
                this.owners[id] = IWardStorageServer.NIL_UUID;
                this.counts[id] = '\u0000';
            }

            @Override
            public void removeOwner(UUID owner, boolean clear) {
                if (clear) {
                    byte id = this.reverseMap.getByte((Object)owner);
                    this.removeOwner(owner);
                    for (int index = 0; index < CHUNK_DATA_SIZE; ++index) {
                        if ((this.data[index / 2] & 15 << index % 2 * 4) >>> index % 2 * 4 != id + 1) continue;
                        this.data[index / 2] = (byte)(this.data[index / 2] & ~(1 << index % 2 * 4));
                        this.data[index / 2] = (byte)(this.data[index / 2] & ~(2 << index % 2 * 4));
                        this.data[index / 2] = (byte)(this.data[index / 2] & ~(4 << index % 2 * 4));
                        this.data[index / 2] = (byte)(this.data[index / 2] & ~(8 << index % 2 * 4));
                    }
                } else {
                    this.removeOwner(owner);
                }
            }

            @Override
            public void clearAllOwnersAndWards() {
                Arrays.fill(this.data, (byte)0);
                Arrays.fill(this.owners, IWardStorageServer.NIL_UUID);
                Arrays.fill(this.counts, '\u0000');
                this.reverseMap.clear();
            }

            @Override
            public int getMaxAllowedOwners() {
                return 15;
            }

            @Override
            public UUID getOwner(BlockPos pos) {
                int index = (pos.func_177958_n() & CHUNK_X_SIZE - 1) + (pos.func_177956_o() & CHUNK_Y_SIZE - 1) * CHUNK_X_SIZE + (pos.func_177952_p() & CHUNK_Z_SIZE - 1) * CHUNK_X_SIZE * CHUNK_Y_SIZE;
                int result = (this.data[index / 2] & 15 << index % 2 * 4) >>> index % 2 * 4;
                return result == 0 ? IWardStorageServer.NIL_UUID : this.owners[result - 1];
            }

            @Override
            public void setOwner(BlockPos pos, UUID owner) {
                int toSet;
                int index = (pos.func_177958_n() & CHUNK_X_SIZE - 1) + (pos.func_177956_o() & CHUNK_Y_SIZE - 1) * CHUNK_X_SIZE + (pos.func_177952_p() & CHUNK_Z_SIZE - 1) * CHUNK_X_SIZE * CHUNK_Y_SIZE;
                int n = toSet = !owner.equals(IWardStorageServer.NIL_UUID) ? this.reverseMap.getByte((Object)owner) + 1 : 0;
                if (toSet != 0 && toSet != (this.data[index / 2] & 15 << index % 2 * 4) >>> index % 2 * 4) {
                    int n2 = toSet - 1;
                    this.counts[n2] = (char)(this.counts[n2] + '\u0001');
                    this.data[index / 2] = (toSet & 1) != 0 ? (byte)(this.data[index / 2] | 1 << index % 2 * 4) : (byte)(this.data[index / 2] & ~(1 << index % 2 * 4));
                    this.data[index / 2] = (toSet & 2) != 0 ? (byte)(this.data[index / 2] | 2 << index % 2 * 4) : (byte)(this.data[index / 2] & ~(2 << index % 2 * 4));
                    this.data[index / 2] = (toSet & 4) != 0 ? (byte)(this.data[index / 2] | 4 << index % 2 * 4) : (byte)(this.data[index / 2] & ~(4 << index % 2 * 4));
                    this.data[index / 2] = (toSet & 8) != 0 ? (byte)(this.data[index / 2] | 8 << index % 2 * 4) : (byte)(this.data[index / 2] & ~(8 << index % 2 * 4));
                } else if (toSet == 0 && (this.data[index / 2] & 15 << index % 2 * 4) >>> index % 2 * 4 != 0) {
                    byte oldOwner;
                    byte by = oldOwner = (byte)(((this.data[index / 2] & 15 << index % 2 * 4) >>> index % 2 * 4) - 1);
                    this.counts[by] = (char)(this.counts[by] - '\u0001');
                    this.data[index / 2] = (byte)(this.data[index / 2] & ~(1 << index % 2 * 4));
                    this.data[index / 2] = (byte)(this.data[index / 2] & ~(2 << index % 2 * 4));
                    this.data[index / 2] = (byte)(this.data[index / 2] & ~(4 << index % 2 * 4));
                    this.data[index / 2] = (byte)(this.data[index / 2] & ~(8 << index % 2 * 4));
                    if (this.counts[oldOwner] == '\u0000') {
                        this.removeOwner(this.owners[oldOwner], false);
                    }
                }
            }

            @Override
            public UUID[] getOwners() {
                return this.owners;
            }

            @Override
            public NBTTagCompound serialize() {
                NBTTagCompound tag = new NBTTagCompound();
                int ownerCount = 0;
                for (int i = 0; i < this.owners.length && !this.owners[i].equals(IWardStorageServer.NIL_UUID); ++i) {
                    tag.func_186854_a(Integer.toString(i), this.owners[i]);
                    ++ownerCount;
                }
                tag.func_74768_a("o", ownerCount);
                tag.func_74773_a("d", this.data);
                return tag;
            }

            @Override
            public void deserialize(NBTTagCompound tag) {
                for (int i = 0; i < tag.func_74762_e("o"); ++i) {
                    this.owners[i] = tag.func_186857_a(Integer.toString(i));
                    this.reverseMap.put((Object)this.owners[i], (byte)i);
                }
                this.data = tag.func_74770_j("d");
                if (this.data.length != CHUNK_DATA_SIZE / 2) {
                    throw new RuntimeException("Invalid ward data length");
                }
                for (int index = 0; index < CHUNK_DATA_SIZE; ++index) {
                    int id = (this.data[index / 2] & 15 << index % 2 * 4) >>> index % 2 * 4;
                    if (id <= 0) continue;
                    int n = id - 1;
                    this.counts[n] = (char)(this.counts[n] + '\u0001');
                }
            }
        }

        public static class StorageManager2Bits
        implements IWardStorageManagerServer {
            protected byte[] data = new byte[CHUNK_DATA_SIZE / 4];
            protected UUID[] owners = new UUID[this.getMaxAllowedOwners()];
            protected Object2ByteOpenHashMap<UUID> reverseMap;
            protected char[] counts;

            public StorageManager2Bits() {
                Arrays.fill(this.owners, IWardStorageServer.NIL_UUID);
                this.reverseMap = new Object2ByteOpenHashMap();
                this.counts = new char[this.getMaxAllowedOwners()];
            }

            public StorageManager2Bits(IWardStorageManagerServer other) {
                this();
                if (other.getMaxAllowedOwners() > 0) {
                    for (int i = 0; i < Math.min(this.owners.length, other.getOwners().length); ++i) {
                        this.owners[i] = other.getOwners()[i];
                        this.reverseMap.put((Object)this.owners[i], (byte)i);
                    }
                    BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(0, 0, 0);
                    for (int x = 0; x < CHUNK_X_SIZE; ++x) {
                        for (int z = 0; z < CHUNK_Z_SIZE; ++z) {
                            pos.func_181079_c(x, 0, z);
                            for (int y = 0; y < CHUNK_Y_SIZE; ++y) {
                                pos.func_185336_p(y);
                                this.setOwner((BlockPos)pos, other.getOwner((BlockPos)pos));
                            }
                        }
                    }
                }
            }

            @Override
            public byte getStorageID() {
                return 2;
            }

            @Override
            public int getNumCurrentOwners() {
                return this.reverseMap.size();
            }

            @Override
            public void addOwner(UUID owner) {
                for (int i = 0; i < this.owners.length; ++i) {
                    if (!this.owners[i].equals(IWardStorageServer.NIL_UUID)) continue;
                    this.owners[i] = owner;
                    this.reverseMap.put((Object)owner, (byte)i);
                    this.counts[i] = '\u0000';
                    return;
                }
                throw new IndexOutOfBoundsException("Attempted to exceed owner storage capacity");
            }

            @Override
            public boolean isOwner(UUID owner) {
                return this.reverseMap.containsKey((Object)owner);
            }

            @Override
            public void removeOwner(UUID owner) {
                byte id = this.reverseMap.removeByte((Object)owner);
                this.counts[id] = '\u0000';
                this.owners[id] = IWardStorageServer.NIL_UUID;
            }

            @Override
            public void removeOwner(UUID owner, boolean clear) {
                if (clear) {
                    byte id = this.reverseMap.getByte((Object)owner);
                    this.removeOwner(owner);
                    for (int index = 0; index < CHUNK_DATA_SIZE; ++index) {
                        if ((this.data[index / 4] & 3 << index % 4 * 2) >>> index % 4 * 2 != id + 1) continue;
                        this.data[index / 4] = (byte)(this.data[index / 4] & ~(1 << index % 4 * 2));
                        this.data[index / 4] = (byte)(this.data[index / 4] & ~(2 << index % 4 * 2));
                    }
                } else {
                    this.removeOwner(owner);
                }
            }

            @Override
            public void clearAllOwnersAndWards() {
                Arrays.fill(this.data, (byte)0);
                Arrays.fill(this.owners, IWardStorageServer.NIL_UUID);
                Arrays.fill(this.counts, '\u0000');
                this.reverseMap.clear();
            }

            @Override
            public int getMaxAllowedOwners() {
                return 3;
            }

            @Override
            public UUID getOwner(BlockPos pos) {
                int index = (pos.func_177958_n() & CHUNK_X_SIZE - 1) + (pos.func_177956_o() & CHUNK_Y_SIZE - 1) * CHUNK_X_SIZE + (pos.func_177952_p() & CHUNK_Z_SIZE - 1) * CHUNK_X_SIZE * CHUNK_Y_SIZE;
                int result = (this.data[index / 4] & 3 << index % 4 * 2) >>> index % 4 * 2;
                return result == 0 ? IWardStorageServer.NIL_UUID : this.owners[result - 1];
            }

            @Override
            public void setOwner(BlockPos pos, UUID owner) {
                int toSet;
                int index = (pos.func_177958_n() & CHUNK_X_SIZE - 1) + (pos.func_177956_o() & CHUNK_Y_SIZE - 1) * CHUNK_X_SIZE + (pos.func_177952_p() & CHUNK_Z_SIZE - 1) * CHUNK_X_SIZE * CHUNK_Y_SIZE;
                int n = toSet = !owner.equals(IWardStorageServer.NIL_UUID) ? this.reverseMap.getByte((Object)owner) + 1 : 0;
                if (toSet != 0 && toSet != (this.data[index / 4] & 3 << index % 4 * 2) >>> index % 4 * 2) {
                    int n2 = toSet - 1;
                    this.counts[n2] = (char)(this.counts[n2] + '\u0001');
                    this.data[index / 4] = (toSet & 1) != 0 ? (byte)(this.data[index / 4] | 1 << index % 4 * 2) : (byte)(this.data[index / 4] & ~(1 << index % 4 * 2));
                    this.data[index / 4] = (toSet & 2) != 0 ? (byte)(this.data[index / 4] | 2 << index % 4 * 2) : (byte)(this.data[index / 4] & ~(2 << index % 4 * 2));
                } else if (toSet == 0 && (this.data[index / 4] & 3 << index % 4 * 2) >>> index % 4 * 2 != 0) {
                    byte oldOwner;
                    byte by = oldOwner = (byte)(((this.data[index / 4] & 3 << index % 4 * 2) >>> index % 4 * 2) - 1);
                    this.counts[by] = (char)(this.counts[by] - '\u0001');
                    this.data[index / 4] = (byte)(this.data[index / 4] & ~(1 << index % 4 * 2));
                    this.data[index / 4] = (byte)(this.data[index / 4] & ~(2 << index % 4 * 2));
                    if (this.counts[oldOwner] == '\u0000') {
                        this.removeOwner(this.owners[oldOwner], false);
                    }
                }
            }

            @Override
            public UUID[] getOwners() {
                return this.owners;
            }

            @Override
            public NBTTagCompound serialize() {
                NBTTagCompound tag = new NBTTagCompound();
                int ownerCount = 0;
                for (int i = 0; i < this.owners.length && !this.owners[i].equals(IWardStorageServer.NIL_UUID); ++i) {
                    tag.func_186854_a(Integer.toString(i), this.owners[i]);
                    ++ownerCount;
                }
                tag.func_74768_a("o", ownerCount);
                tag.func_74773_a("d", this.data);
                return tag;
            }

            @Override
            public void deserialize(NBTTagCompound tag) {
                for (int i = 0; i < tag.func_74762_e("o"); ++i) {
                    this.owners[i] = tag.func_186857_a(Integer.toString(i));
                    this.reverseMap.put((Object)this.owners[i], (byte)i);
                }
                this.data = tag.func_74770_j("d");
                if (this.data.length != CHUNK_DATA_SIZE / 4) {
                    throw new RuntimeException("Invalid ward data length");
                }
                for (int index = 0; index < CHUNK_DATA_SIZE; ++index) {
                    int id = (this.data[index / 4] & 3 << index % 4 * 2) >>> index % 4 * 2;
                    if (id <= 0) continue;
                    int n = id - 1;
                    this.counts[n] = (char)(this.counts[n] + '\u0001');
                }
            }
        }

        public static class StorageManager1Bit
        implements IWardStorageManagerServer {
            protected byte[] data = new byte[CHUNK_DATA_SIZE / 8];
            protected UUID owner = IWardStorageServer.NIL_UUID;
            protected char count = '\u0000';

            public StorageManager1Bit() {
            }

            public StorageManager1Bit(IWardStorageManagerServer other) {
                this();
                if (other.getMaxAllowedOwners() > 0) {
                    this.owner = other.getOwners()[0];
                    BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(0, 0, 0);
                    for (int x = 0; x < CHUNK_X_SIZE; ++x) {
                        for (int z = 0; z < CHUNK_Z_SIZE; ++z) {
                            pos.func_181079_c(x, 0, z);
                            for (int y = 0; y < CHUNK_Y_SIZE; ++y) {
                                pos.func_185336_p(y);
                                this.setOwner((BlockPos)pos, other.getOwner((BlockPos)pos));
                            }
                        }
                    }
                }
            }

            @Override
            public byte getStorageID() {
                return 1;
            }

            @Override
            public int getNumCurrentOwners() {
                return this.owner != IWardStorageServer.NIL_UUID ? 1 : 0;
            }

            @Override
            public void addOwner(UUID owner) {
                if (!this.owner.equals(IWardStorageServer.NIL_UUID)) {
                    throw new IndexOutOfBoundsException("Attempted to exceed owner storage capacity");
                }
                this.owner = owner;
                this.count = '\u0000';
            }

            @Override
            public boolean isOwner(UUID owner) {
                return owner.equals(this.owner);
            }

            @Override
            public void removeOwner(UUID owner) {
                if (this.owner.equals(owner)) {
                    this.owner = IWardStorageServer.NIL_UUID;
                    this.count = '\u0000';
                }
            }

            @Override
            public void removeOwner(UUID owner, boolean clear) {
                this.removeOwner(owner);
                if (clear) {
                    Arrays.fill(this.data, (byte)0);
                }
            }

            @Override
            public int getMaxAllowedOwners() {
                return 1;
            }

            @Override
            public UUID getOwner(BlockPos pos) {
                int index = (pos.func_177958_n() & CHUNK_X_SIZE - 1) + (pos.func_177956_o() & CHUNK_Y_SIZE - 1) * CHUNK_X_SIZE + (pos.func_177952_p() & CHUNK_Z_SIZE - 1) * CHUNK_X_SIZE * CHUNK_Y_SIZE;
                return (this.data[index / 8] & 1 << index % 8) != 0 ? this.owner : IWardStorageServer.NIL_UUID;
            }

            @Override
            public void setOwner(BlockPos pos, UUID owner) {
                int index = (pos.func_177958_n() & CHUNK_X_SIZE - 1) + (pos.func_177956_o() & CHUNK_Y_SIZE - 1) * CHUNK_X_SIZE + (pos.func_177952_p() & CHUNK_Z_SIZE - 1) * CHUNK_X_SIZE * CHUNK_Y_SIZE;
                if (owner.equals(this.owner) && !owner.equals(IWardStorageServer.NIL_UUID) && (this.data[index / 8] & 1 << index % 8) >>> index % 8 == 0) {
                    if ((this.data[index / 8] & 1 << index % 8) == 0) {
                        this.count = (char)(this.count + '\u0001');
                        this.data[index / 8] = (byte)(this.data[index / 8] | 1 << index % 8);
                    }
                } else if (owner.equals(IWardStorageServer.NIL_UUID) && (this.data[index / 8] & 1 << index % 8) >>> index % 8 == 1) {
                    this.count = (char)(this.count - '\u0001');
                    this.data[index / 8] = (byte)(this.data[index / 8] & ~(1 << index % 8));
                    if (this.count == '\u0000') {
                        this.removeOwner(this.owner, false);
                    }
                }
            }

            @Override
            public void clearAllOwnersAndWards() {
                Arrays.fill(this.data, (byte)0);
                this.owner = IWardStorageServer.NIL_UUID;
                this.count = '\u0000';
            }

            @Override
            public UUID[] getOwners() {
                return new UUID[]{this.owner};
            }

            @Override
            public NBTTagCompound serialize() {
                NBTTagCompound tag = new NBTTagCompound();
                tag.func_186854_a("0", this.owner);
                tag.func_74773_a("d", this.data);
                return tag;
            }

            @Override
            public void deserialize(NBTTagCompound tag) {
                this.owner = tag.func_186857_a("0");
                this.data = tag.func_74770_j("d");
                if (this.data.length != CHUNK_DATA_SIZE / 8) {
                    throw new RuntimeException("Invalid ward data length");
                }
                for (int i = 0; i < CHUNK_DATA_SIZE; ++i) {
                    if ((this.data[i / 8] & 1 << i % 8) == 0) continue;
                    this.count = (char)(this.count + '\u0001');
                }
            }
        }

        public static class StorageManagerNull
        implements IWardStorageManagerServer {
            public StorageManagerNull() {
            }

            public StorageManagerNull(IWardStorageManagerServer other) {
            }

            @Override
            public byte getStorageID() {
                return 0;
            }

            @Override
            public int getNumCurrentOwners() {
                return 0;
            }

            @Override
            public void addOwner(UUID owner) {
                throw new IndexOutOfBoundsException("Attempted to exceed owner storage capacity");
            }

            @Override
            public boolean isOwner(UUID owner) {
                return false;
            }

            @Override
            public void removeOwner(UUID owner) {
            }

            @Override
            public void removeOwner(UUID owner, boolean clear) {
            }

            @Override
            public int getMaxAllowedOwners() {
                return 0;
            }

            @Override
            public UUID getOwner(BlockPos pos) {
                return IWardStorageServer.NIL_UUID;
            }

            @Override
            public void setOwner(BlockPos pos, UUID owner) {
            }

            @Override
            public void clearAllOwnersAndWards() {
            }

            @Override
            public UUID[] getOwners() {
                return new UUID[0];
            }

            @Override
            public NBTTagCompound serialize() {
                return new NBTTagCompound();
            }

            @Override
            public void deserialize(NBTTagCompound tag) {
            }
        }

        public static interface IWardStorageManagerServer {
            public byte getStorageID();

            public int getNumCurrentOwners();

            public int getMaxAllowedOwners();

            public void addOwner(UUID var1);

            public void removeOwner(UUID var1);

            public void removeOwner(UUID var1, boolean var2);

            public boolean isOwner(UUID var1);

            public UUID getOwner(BlockPos var1);

            public void setOwner(BlockPos var1, UUID var2);

            public void clearAllOwnersAndWards();

            public UUID[] getOwners();

            public NBTTagCompound serialize();

            public void deserialize(NBTTagCompound var1);
        }
    }
}

