/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumicaugmentation.api.world.capability;

import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.HashSet;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.util.INBTSerializable;
import thecodex6824.thaumicaugmentation.ThaumicAugmentation;
import thecodex6824.thaumicaugmentation.api.world.capability.IFractureLocations;

public class FractureLocations
implements IFractureLocations,
INBTSerializable<NBTTagCompound> {
    private HashSet<BlockPos> positions = new HashSet();
    private WeakReference<Chunk> chunk;

    public FractureLocations() {
    }

    public FractureLocations(Chunk c) {
        this();
        this.chunk = new WeakReference<Chunk>(c);
    }

    @Override
    public void setChunk(Chunk c) {
        this.chunk = new WeakReference<Chunk>(c);
    }

    @Override
    public boolean hasFracture() {
        return !this.positions.isEmpty();
    }

    @Override
    public Collection<BlockPos> getFractureLocations() {
        return this.positions;
    }

    @Override
    public void addFractureLocation(BlockPos pos) {
        this.positions.add(pos.func_185334_h());
        if (this.chunk != null && this.chunk.get() != null) {
            ((Chunk)this.chunk.get()).func_76630_e();
        }
    }

    @Override
    public void removeFractureLocation(BlockPos pos) {
        this.positions.remove(pos.func_185334_h());
        if (this.chunk != null && this.chunk.get() != null) {
            ((Chunk)this.chunk.get()).func_76630_e();
        }
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        String str;
        for (int i = 0; i < Integer.MAX_VALUE && nbt.func_150297_b(str = Integer.toString(i), 10); ++i) {
            int[] coord = nbt.func_74775_l(str).func_74759_k("pos");
            if (coord.length != 3) {
                ThaumicAugmentation.getLogger().warn("A CapabilityFractureLocation instance contained invalid position data!");
                break;
            }
            this.positions.add(new BlockPos(coord[0], coord[1], coord[2]));
        }
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound tag = new NBTTagCompound();
        BlockPos[] arr = this.positions.toArray(new BlockPos[this.positions.size()]);
        for (int i = 0; i < arr.length; ++i) {
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74783_a("pos", new int[]{arr[i].func_177958_n(), arr[i].func_177956_o(), arr[i].func_177952_p()});
            tag.func_74782_a(Integer.toString(i), (NBTBase)nbt);
        }
        return tag;
    }
}

