/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumicaugmentation.client.model;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;
import javax.vecmath.Matrix4f;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BakedQuadRetextured;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.property.IExtendedBlockState;
import org.apache.commons.lang3.tuple.Pair;
import thecodex6824.thaumicaugmentation.api.TABlocks;
import thecodex6824.thaumicaugmentation.api.block.property.ITAStoneType;
import thecodex6824.thaumicaugmentation.common.block.trait.IStoredBlockstate;

public class DirectionalRetexturingModel
implements IModel {
    protected IModel model;

    public DirectionalRetexturingModel(IModel wrapped) {
        this.model = wrapped;
    }

    public IModelState getDefaultState() {
        return this.model.getDefaultState();
    }

    public Collection<ResourceLocation> getDependencies() {
        return this.model.getDependencies();
    }

    public Collection<ResourceLocation> getTextures() {
        return this.model.getTextures();
    }

    public IBakedModel bake(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        return new BakedModel(this.model.bake(state, format, bakedTextureGetter));
    }

    public static class BakedModel
    implements IBakedModel {
        protected IBakedModel wrapped;
        protected ItemOverrideList overrides;

        protected BakedModel(IBakedModel wrappedModel) {
            this.wrapped = wrappedModel;
            this.overrides = new ItemOverrideList((List)ImmutableList.of()){

                public IBakedModel handleItemState(IBakedModel originalModel, ItemStack stack, @Nullable World world, @Nullable EntityLivingBase entity) {
                    IBakedModel old = wrapped.func_188617_f().handleItemState(originalModel, stack, world, entity);
                    if (old != this) {
                        return new BakedModel(old);
                    }
                    return old;
                }
            };
        }

        public List<BakedQuad> func_188616_a(@Nullable IBlockState state, @Nullable EnumFacing side, long rand) {
            List quads = this.wrapped.func_188616_a(state, side, rand);
            if (!quads.isEmpty() && state != null) {
                IExtendedBlockState extended = (IExtendedBlockState)state;
                IBlockState sitting = (IBlockState)extended.getValue(IStoredBlockstate.BLOCKSTATE);
                IBakedModel blockModel = Minecraft.func_71410_x().func_175602_ab().func_184389_a(sitting);
                TextureAtlasSprite newTexture = blockModel.func_177554_e();
                if (newTexture.equals(Minecraft.func_71410_x().func_147117_R().func_174944_f())) {
                    newTexture = Minecraft.func_71410_x().func_175602_ab().func_184389_a(TABlocks.STONE.func_176223_P().func_177226_a(ITAStoneType.STONE_TYPE, (Comparable)((Object)ITAStoneType.StoneType.STONE_CRUSTED))).func_177554_e();
                }
                ImmutableList.Builder builder = ImmutableList.builder();
                for (BakedQuad old : quads) {
                    builder.add((Object)new BakedQuadRetextured(old, newTexture));
                }
                return builder.build();
            }
            return quads;
        }

        public ItemOverrideList func_188617_f() {
            return this.overrides;
        }

        public TextureAtlasSprite func_177554_e() {
            return this.wrapped.func_177554_e();
        }

        public boolean func_177555_b() {
            return this.wrapped.func_177555_b();
        }

        public boolean isAmbientOcclusion(IBlockState state) {
            return this.wrapped.isAmbientOcclusion(state);
        }

        public boolean func_188618_c() {
            return this.wrapped.func_188618_c();
        }

        public boolean func_177556_c() {
            return this.wrapped.func_177556_c();
        }

        public ItemCameraTransforms func_177552_f() {
            return this.wrapped.func_177552_f();
        }

        public Pair<? extends IBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType cameraTransformType) {
            return this.wrapped.handlePerspective(cameraTransformType);
        }
    }

    public static class Loader
    implements ICustomModelLoader {
        public boolean accepts(ResourceLocation loc) {
            return loc.func_110624_b().equals("ta_special") && (loc.func_110623_a().startsWith("directional_retexture:") || loc.func_110623_a().startsWith("models/block/directional_retexture:"));
        }

        public IModel loadModel(ResourceLocation modelLocation) throws Exception {
            String component = modelLocation.func_110623_a().split(":", 2)[1];
            if (modelLocation instanceof ModelResourceLocation) {
                return new DirectionalRetexturingModel(ModelLoaderRegistry.getModel((ResourceLocation)new ModelResourceLocation(component, ((ModelResourceLocation)modelLocation).func_177518_c())));
            }
            return new DirectionalRetexturingModel(ModelLoaderRegistry.getModel((ResourceLocation)new ResourceLocation(component)));
        }

        public void func_110549_a(IResourceManager resourceManager) {
        }
    }
}

