/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumicaugmentation.common.block;

import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thecodex6824.thaumicaugmentation.api.TAConfig;
import thecodex6824.thaumicaugmentation.api.TAItems;
import thecodex6824.thaumicaugmentation.api.block.property.ICreativeImpetusBlock;
import thecodex6824.thaumicaugmentation.common.block.prefab.BlockTABase;
import thecodex6824.thaumicaugmentation.common.block.trait.IItemBlockProvider;
import thecodex6824.thaumicaugmentation.common.item.block.ItemBlockNoImpetusNodeNBTMultiTexture;
import thecodex6824.thaumicaugmentation.common.tile.TileCreativeImpetusSink;
import thecodex6824.thaumicaugmentation.common.tile.TileCreativeImpetusSource;

public class BlockImpetusCreative
extends BlockTABase
implements ICreativeImpetusBlock,
IItemBlockProvider {
    protected static final AxisAlignedBB BOUNDING_BOX = new AxisAlignedBB(0.125, 0.125, 0.125, 0.875, 0.875, 0.875);

    public BlockImpetusCreative() {
        super(Material.field_151573_f);
        this.func_149722_s();
        this.func_149752_b(6000000.0f);
        this.func_149672_a(SoundType.field_185852_e);
        this.func_180632_j(this.func_176223_P().func_177226_a(ICreativeImpetusBlock.BLOCK_TYPE, (Comparable)((Object)ICreativeImpetusBlock.BlockType.IMPETUS_CREATIVE_SOURCE)));
        this.func_149649_H();
    }

    @Override
    public ItemBlock createItemBlock() {
        return new ItemBlockNoImpetusNodeNBTMultiTexture(this, ICreativeImpetusBlock.BLOCK_TYPE.func_177700_c().stream().map(arg_0 -> ICreativeImpetusBlock.BLOCK_TYPE.func_177702_a(arg_0)).collect(Collectors.toList()).toArray(new String[ICreativeImpetusBlock.BLOCK_TYPE.func_177700_c().size()])){

            @SideOnly(value=Side.CLIENT)
            public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
                if (!TAConfig.disableCreativeOnlyText.getValue().booleanValue()) {
                    tooltip.add(new TextComponentTranslation("thaumicaugmentation.text.creative_only", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.DARK_PURPLE)).func_150254_d());
                }
            }
        };
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{ICreativeImpetusBlock.BLOCK_TYPE});
    }

    public int func_176201_c(IBlockState state) {
        return ((ICreativeImpetusBlock.BlockType)((Object)state.func_177229_b(ICreativeImpetusBlock.BLOCK_TYPE))).getMeta();
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(ICreativeImpetusBlock.BLOCK_TYPE, (Comparable)((Object)ICreativeImpetusBlock.BlockType.fromMeta(meta)));
    }

    public int func_180651_a(IBlockState state) {
        return ((ICreativeImpetusBlock.BlockType)((Object)state.func_177229_b(ICreativeImpetusBlock.BLOCK_TYPE))).getMeta();
    }

    public int func_149745_a(Random random) {
        return 0;
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return BOUNDING_BOX;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        switch ((ICreativeImpetusBlock.BlockType)((Object)state.func_177229_b(ICreativeImpetusBlock.BLOCK_TYPE))) {
            case IMPETUS_CREATIVE_SINK: {
                return new TileCreativeImpetusSink();
            }
        }
        return new TileCreativeImpetusSource();
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    public boolean func_185481_k(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean isNormalCube(IBlockState state, IBlockAccess world, BlockPos pos) {
        return false;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.TRANSLUCENT;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (tab == TAItems.CREATIVE_TAB || tab == CreativeTabs.field_78027_g) {
            for (ICreativeImpetusBlock.BlockType type : ICreativeImpetusBlock.BlockType.values()) {
                items.add((Object)new ItemStack((Block)this, 1, type.getMeta()));
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModels() {
        for (ICreativeImpetusBlock.BlockType type : ICreativeImpetusBlock.BlockType.values()) {
            ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)this), (int)type.getMeta(), (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName().func_110624_b() + ":" + type.func_176610_l(), "inventory"));
        }
    }
}

