/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumicaugmentation.common.event;

import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.ListIterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.ExplosionEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import thaumcraft.api.golems.tasks.Task;
import thaumcraft.common.entities.construct.EntityArcaneBore;
import thaumcraft.common.golems.tasks.TaskHandler;
import thecodex6824.thaumicaugmentation.api.event.BlockWardEvent;
import thecodex6824.thaumicaugmentation.api.ward.WardHelper;
import thecodex6824.thaumicaugmentation.api.ward.storage.CapabilityWardStorage;
import thecodex6824.thaumicaugmentation.api.ward.storage.IWardStorage;
import thecodex6824.thaumicaugmentation.api.ward.storage.IWardStorageServer;
import thecodex6824.thaumicaugmentation.common.event.WardEventHandler;

public class WardEventHandlerNoCoremodFallback
extends WardEventHandler {
    private static final Field BORE_DIG_TARGET;

    private static void handleBoreNotCaringAboutCanceledEvents(FakePlayer borePlayer) {
        for (EntityArcaneBore bore : borePlayer.func_130014_f_().func_72872_a(EntityArcaneBore.class, borePlayer.func_174813_aQ())) {
            try {
                BORE_DIG_TARGET.set(bore, bore.func_180425_c());
            }
            catch (Exception ex) {
                FMLCommonHandler.instance().raiseException((Throwable)ex, "Failed to set Thaumcraft's EntityArcaneBore#digTarget", true);
            }
        }
    }

    @Override
    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onWorldTick(TickEvent.WorldTickEvent event) {
        ConcurrentHashMap tasks;
        super.onWorldTick(event);
        if (!event.world.field_72995_K && event.phase == TickEvent.Phase.END && (tasks = (ConcurrentHashMap)TaskHandler.tasks.get(event.world.field_73011_w.getDimension())) != null) {
            for (Map.Entry entry : tasks.entrySet()) {
                Chunk chunk;
                IWardStorage storage;
                Task task = (Task)entry.getValue();
                if (task.getType() != 0 || !event.world.func_175667_e(task.getPos()) || (storage = (IWardStorage)(chunk = event.world.func_175726_f(task.getPos())).getCapability(CapabilityWardStorage.WARD_STORAGE, null)) == null || !storage.hasWard(task.getPos())) continue;
                task.setPriority((byte)-128);
                task.setReserved(true);
                task.setCompletion(true);
                tasks.remove(entry.getKey());
            }
        }
    }

    @Override
    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onBlockBreak(BlockEvent.BreakEvent event) {
        BlockPos pos = event.getPos();
        Chunk chunk = event.getWorld().func_175726_f(pos);
        IWardStorage storage = (IWardStorage)chunk.getCapability(CapabilityWardStorage.WARD_STORAGE, null);
        if (storage != null && storage.hasWard(pos)) {
            if (!WardHelper.doesEntityHaveSpecialPermission((EntityLivingBase)event.getPlayer())) {
                event.setCanceled(true);
                if (event.getPlayer() instanceof FakePlayer && event.getPlayer().func_70005_c_().equals("FakeThaumcraftBore")) {
                    WardEventHandlerNoCoremodFallback.handleBoreNotCaringAboutCanceledEvents((FakePlayer)event.getPlayer());
                }
            } else if (storage instanceof IWardStorageServer) {
                ((IWardStorageServer)storage).clearWard(pos, event.getWorld());
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onBreakSpeed(PlayerEvent.BreakSpeed event) {
        BlockPos pos = event.getPos();
        EntityPlayer player = event.getEntityPlayer();
        Chunk chunk = player.func_130014_f_().func_175726_f(pos);
        IWardStorage storage = (IWardStorage)chunk.getCapability(CapabilityWardStorage.WARD_STORAGE, null);
        if (storage != null && storage.hasWard(pos) && !WardHelper.doesEntityHaveSpecialPermission((EntityLivingBase)player)) {
            RayTraceResult ray = player.func_130014_f_().func_147447_a(player.func_174824_e(1.0f), player.func_70040_Z().func_186678_a(player.func_110148_a(EntityPlayer.REACH_DISTANCE).func_111126_e()).func_178787_e(new Vec3d((Vec3i)pos)), false, false, true);
            if (ray != null) {
                WardEventHandlerNoCoremodFallback.sendWardParticles(event.getEntityPlayer().func_130014_f_(), pos, ray.field_178784_b);
            }
            event.setCanceled(true);
            event.setNewSpeed(0.0f);
        }
    }

    @Override
    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onNeighborNotify(BlockEvent.NeighborNotifyEvent event) {
        super.onNeighborNotify(event);
        if (event.getWorld().func_175667_e(event.getPos()) && event.getWorld().func_190526_b(event.getPos().func_177958_n() >> 4, event.getPos().func_177952_p() >> 4)) {
            BlockPos notifier = event.getPos();
            for (EnumFacing facing : event.getNotifiedSides()) {
                Chunk chunk;
                IWardStorage storage;
                BlockPos pos = notifier.func_177972_a(facing);
                if (!event.getWorld().func_190526_b(pos.func_177958_n() >> 4, pos.func_177952_p() >> 4) || event.getWorld().func_175623_d(pos) || (storage = (IWardStorage)(chunk = event.getWorld().func_175726_f(pos)).getCapability(CapabilityWardStorage.WARD_STORAGE, null)) == null || !storage.hasWard(pos)) continue;
                event.setCanceled(true);
                if (event.getState().func_185904_a() != Material.field_151581_o) continue;
                event.getWorld().func_180501_a(notifier, Blocks.field_150350_a.func_176223_P(), 2);
                event.setCanceled(true);
                return;
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onExplosion(ExplosionEvent.Detonate event) {
        BlockPos pos;
        HashSet<BlockPos> blockers = new HashSet<BlockPos>();
        ListIterator iterator = event.getAffectedBlocks().listIterator();
        while (iterator.hasNext()) {
            pos = (BlockPos)iterator.next();
            Chunk chunk = event.getWorld().func_175726_f(pos);
            IWardStorage storage = (IWardStorage)chunk.getCapability(CapabilityWardStorage.WARD_STORAGE, null);
            if (storage == null || !storage.hasWard(pos)) continue;
            blockers.add(pos);
            iterator.remove();
        }
        iterator = event.getAffectedBlocks().listIterator();
        while (iterator.hasNext()) {
            pos = (BlockPos)iterator.next();
            RayTraceResult ray = event.getWorld().func_72933_a(event.getExplosion().getPosition(), new Vec3d((Vec3i)pos));
            if (ray == null || ray.field_72313_a != RayTraceResult.Type.BLOCK || !blockers.contains(ray.func_178782_a())) continue;
            iterator.remove();
        }
        ListIterator entityIterator = event.getAffectedEntities().listIterator();
        while (entityIterator.hasNext()) {
            Entity entity = (Entity)entityIterator.next();
            RayTraceResult ray = event.getWorld().func_72933_a(event.getExplosion().getPosition(), entity.func_174791_d());
            if (ray != null && ray.field_72313_a == RayTraceResult.Type.BLOCK && blockers.contains(ray.func_178782_a())) {
                entityIterator.remove();
                continue;
            }
            ray = event.getWorld().func_72933_a(event.getExplosion().getPosition(), entity.func_174824_e(1.0f));
            if (ray == null || ray.field_72313_a != RayTraceResult.Type.BLOCK || !blockers.contains(ray.func_178782_a())) continue;
            entityIterator.remove();
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onGrow(BlockEvent.CropGrowEvent.Pre event) {
        BlockPos pos = event.getPos();
        Chunk chunk = event.getWorld().func_175726_f(pos);
        IWardStorage storage = (IWardStorage)chunk.getCapability(CapabilityWardStorage.WARD_STORAGE, null);
        if (storage != null && storage.hasWard(pos)) {
            event.setResult(Event.Result.DENY);
        }
    }

    @Override
    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onWardBlock(BlockWardEvent.WardedServer.Post event) {
        super.onWardBlock(event);
        BlockPos warded = event.getPos();
        for (EnumFacing facing : EnumFacing.values()) {
            BlockPos pos = warded.func_177972_a(facing);
            if (event.getWorld().func_180495_p(pos).func_185904_a() != Material.field_151581_o) continue;
            event.getWorld().func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 2);
        }
    }

    static {
        Field dig = null;
        try {
            dig = EntityArcaneBore.class.getDeclaredField("digTarget");
            dig.setAccessible(true);
        }
        catch (Exception ex) {
            FMLCommonHandler.instance().raiseException((Throwable)ex, "Failed to access Thaumcraft's EntityArcaneBore#digTarget", true);
        }
        BORE_DIG_TARGET = dig;
    }
}

