/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumicaugmentation.common.tile;

import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import thecodex6824.thaumicaugmentation.ThaumicAugmentation;
import thecodex6824.thaumicaugmentation.api.impetus.CapabilityImpetusStorage;
import thecodex6824.thaumicaugmentation.api.impetus.node.CapabilityImpetusNode;
import thecodex6824.thaumicaugmentation.api.impetus.node.NodeHelper;
import thecodex6824.thaumicaugmentation.api.impetus.node.prefab.BufferedImpetusProvider;
import thecodex6824.thaumicaugmentation.api.util.DimensionalBlockPos;
import thecodex6824.thaumicaugmentation.common.capability.InfiniteImpetusStorage;

public class TileCreativeImpetusSource
extends TileEntity
implements ITickable {
    protected BufferedImpetusProvider provider;
    protected InfiniteImpetusStorage storage = new InfiniteImpetusStorage(true, false);
    protected int ticks;

    public TileCreativeImpetusSource() {
        this.provider = new BufferedImpetusProvider(0, Integer.MAX_VALUE, this.storage);
        this.ticks = ThreadLocalRandom.current().nextInt(20);
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K && this.ticks % 20 == 0) {
            NodeHelper.validateOutputs(this.field_145850_b, this.provider);
        }
    }

    public void func_174878_a(BlockPos posIn) {
        super.func_174878_a(posIn);
        if (this.field_145850_b != null) {
            this.provider.setLocation(new DimensionalBlockPos(this.field_174879_c.func_185334_h(), this.field_145850_b.field_73011_w.getDimension()));
        }
    }

    public void func_145834_a(World worldIn) {
        super.func_145834_a(worldIn);
        this.provider.setLocation(new DimensionalBlockPos(this.field_174879_c.func_185334_h(), this.field_145850_b.field_73011_w.getDimension()));
    }

    public void onLoad() {
        this.provider.init(this.field_145850_b);
        ThaumicAugmentation.proxy.registerRenderableImpetusNode(this.provider);
    }

    public void func_145843_s() {
        if (!this.field_145850_b.field_72995_K) {
            NodeHelper.syncDestroyedImpetusNode(this.provider);
        }
        this.provider.destroy();
        ThaumicAugmentation.proxy.deregisterRenderableImpetusNode(this.provider);
        super.func_145843_s();
    }

    public void onChunkUnload() {
        this.provider.unload();
        ThaumicAugmentation.proxy.deregisterRenderableImpetusNode(this.provider);
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound tag = super.func_189517_E_();
        tag.func_74782_a("node", (NBTBase)this.provider.serializeNBT());
        return tag;
    }

    public void handleUpdateTag(NBTTagCompound tag) {
        super.handleUpdateTag(tag);
        this.provider.init(this.field_145850_b);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        tag.func_74782_a("node", (NBTBase)this.provider.serializeNBT());
        return super.func_189515_b(tag);
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.provider.deserializeNBT(nbt.func_74775_l("node"));
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityImpetusNode.IMPETUS_NODE || capability == CapabilityImpetusStorage.IMPETUS_STORAGE) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityImpetusNode.IMPETUS_NODE) {
            return (T)CapabilityImpetusNode.IMPETUS_NODE.cast((Object)this.provider);
        }
        if (capability == CapabilityImpetusStorage.IMPETUS_STORAGE) {
            return (T)CapabilityImpetusStorage.IMPETUS_STORAGE.cast((Object)this.storage);
        }
        return (T)super.getCapability(capability, facing);
    }
}

