/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumicaugmentation.common.world;

import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.fml.common.IWorldGenerator;
import thaumcraft.api.aura.AuraHelper;
import thecodex6824.thaumicaugmentation.api.TAConfig;
import thecodex6824.thaumicaugmentation.api.world.TADimensions;
import thecodex6824.thaumicaugmentation.common.event.QueuedWorldGenManager;
import thecodex6824.thaumicaugmentation.common.world.WorldDataCache;
import thecodex6824.thaumicaugmentation.common.world.biome.IFluxBiome;
import thecodex6824.thaumicaugmentation.common.world.feature.FractureUtils;
import thecodex6824.thaumicaugmentation.common.world.feature.WorldGenDimensionalFracture;

public final class TAWorldGenerator
implements IWorldGenerator {
    private static final int WORLD_BORDER_MAX = 29999984;
    private static WorldGenDimensionalFracture FRACTURE_GEN = new WorldGenDimensionalFracture();

    private static boolean wouldLink(World world, int chunkX, int chunkZ) {
        double factor = FractureUtils.movementRatio(world);
        int scaledX = FractureUtils.scaleChunkCoord(chunkX, factor);
        int scaledZ = FractureUtils.scaleChunkCoord(chunkZ, factor);
        if (Math.abs(scaledX) >= 1874999 || Math.abs(scaledZ) >= 1874999 || scaledX == FractureUtils.scaleChunkCoord(chunkX - (int)Math.signum(chunkX), factor) || scaledZ == FractureUtils.scaleChunkCoord(chunkZ - (int)Math.signum(chunkZ), factor)) {
            return false;
        }
        WorldDataCache.WorldData emptiness = WorldDataCache.getData(TADimensions.EMPTINESS.func_186068_a());
        if (emptiness != null) {
            Random test = new Random(emptiness.getWorldSeed());
            long xSeed = test.nextLong() >> 3;
            long zSeed = test.nextLong() >> 3;
            test.setSeed(xSeed * (long)scaledX + zSeed * (long)scaledZ ^ emptiness.getWorldSeed());
            if (test.nextInt(TAConfig.fractureGenChance.getValue()) == 0) {
                MathHelper.func_76136_a((Random)test, (int)-2, (int)2);
                MathHelper.func_76136_a((Random)test, (int)-2, (int)2);
                return FractureUtils.wouldLinkToDim(test, scaledX, scaledZ, world.field_73011_w.getDimension());
            }
        }
        return false;
    }

    private static BlockPos getTopValidSpot(World world, int x, int z, boolean allowVoid) {
        BlockPos pos = new BlockPos(x, 0, z);
        for (int y = Math.min(Math.max(world.func_72940_L() - 1, 0), 255); y >= 0; --y) {
            BlockPos check = pos.func_177982_a(0, y, 0);
            IBlockState state = world.func_180495_p(check);
            if (!state.func_185904_a().func_76230_c() || state.func_177230_c().isLeaves(state, (IBlockAccess)world, check) || state.func_177230_c().isFoliage((IBlockAccess)world, check) || !(state.func_185887_b(world, check) >= 0.0f) || !world.func_180495_p(check.func_177984_a()).func_177230_c().isAir(world.func_180495_p(check.func_177984_a()), (IBlockAccess)world, check)) continue;
            return pos.func_177982_a(0, y + 2, 0);
        }
        return allowVoid ? new BlockPos(x, Math.min(world.field_73011_w.func_76557_i(), Math.max(world.func_72940_L() - 1, 0)), z) : null;
    }

    public static void generateFractures(Random random, int chunkX, int chunkZ, World world) {
        if (world.field_73011_w.getDimension() == TADimensions.EMPTINESS.func_186068_a()) {
            if (random.nextInt(TAConfig.fractureGenChance.getValue()) == 0) {
                int posX = chunkX * 16 + 8 + MathHelper.func_76136_a((Random)random, (int)-2, (int)2);
                int posZ = chunkZ * 16 + 8 + MathHelper.func_76136_a((Random)random, (int)-2, (int)2);
                if (Math.abs(posX) < 29999984 && Math.abs(posZ) < 29999984) {
                    FRACTURE_GEN.func_180709_b(world, random, TAWorldGenerator.getTopValidSpot(world, posX, posZ, true));
                }
            }
        } else if (FractureUtils.isDimAllowedForLinking(world.field_73011_w.getDimension()) && TAWorldGenerator.wouldLink(world, chunkX, chunkZ)) {
            int posX = chunkX * 16 + 8 + MathHelper.func_76136_a((Random)random, (int)-2, (int)2);
            int posZ = chunkZ * 16 + 8 + MathHelper.func_76136_a((Random)random, (int)-2, (int)2);
            FRACTURE_GEN.func_180709_b(world, random, TAWorldGenerator.getTopValidSpot(world, posX, posZ, true));
        }
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        random = new Random(world.func_72905_C());
        long xSeed = random.nextLong() >> 3;
        long zSeed = random.nextLong() >> 3;
        random.setSeed(xSeed * (long)chunkX + zSeed * (long)chunkZ ^ world.func_72905_C());
        if (!TAConfig.disableEmptiness.getValue().booleanValue()) {
            BlockPos pos;
            Biome biome;
            if (world.field_73011_w.getDimension() == TADimensions.EMPTINESS.func_186068_a() && (biome = world.func_180494_b(pos = new BlockPos(chunkX * 16, 0, chunkZ * 16))) instanceof IFluxBiome) {
                float flux = (float)AuraHelper.getAuraBase((World)world, (BlockPos)pos) * ((IFluxBiome)biome).getBaseFluxConcentration();
                AuraHelper.drainVis((World)world, (BlockPos)pos, (float)flux, (boolean)false);
                AuraHelper.polluteAura((World)world, (BlockPos)pos, (float)flux, (boolean)false);
            }
            if (TAConfig.fractureGenChance.getValue() > 0) {
                if (WorldDataCache.isInitialized()) {
                    TAWorldGenerator.generateFractures(random, chunkX, chunkZ, world);
                } else {
                    Random rand = new Random(world.func_72905_C());
                    xSeed = random.nextLong() >> 3;
                    zSeed = random.nextLong() >> 3;
                    rand.setSeed(xSeed * (long)chunkX + zSeed * (long)chunkZ ^ world.func_72905_C());
                    QueuedWorldGenManager.enqueueGeneration(() -> {
                        TAWorldGenerator.generateFractures(rand, chunkX, chunkZ, world);
                        world.func_72964_e(chunkX, chunkZ).func_76630_e();
                    });
                }
            }
        }
    }
}

