/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumicaugmentation.common.world.biome;

import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeCache;
import net.minecraft.world.biome.BiomeProvider;
import net.minecraft.world.gen.layer.GenLayer;
import net.minecraft.world.gen.layer.IntCache;
import thecodex6824.thaumicaugmentation.api.world.TABiomes;
import thecodex6824.thaumicaugmentation.common.world.biome.layer.GenLayerEmptiness;

public class BiomeProviderEmptiness
extends BiomeProvider {
    protected BiomeCache cache = new BiomeCache((BiomeProvider)this);
    protected GenLayer biomeGen;
    protected GenLayer indexGen;

    public BiomeProviderEmptiness() {
    }

    public BiomeProviderEmptiness(World world) {
        this();
        GenLayer[] layers = GenLayerEmptiness.createLayers(world.func_72905_C());
        this.biomeGen = layers[0];
        this.indexGen = layers[1];
    }

    public List<Biome> func_76932_a() {
        return allowedBiomes;
    }

    public Biome func_180631_a(BlockPos pos) {
        return this.func_180300_a(pos, null);
    }

    public Biome func_180300_a(BlockPos pos, Biome defaultBiome) {
        return this.cache.func_180284_a(pos.func_177958_n(), pos.func_177952_p(), defaultBiome);
    }

    public Biome[] func_76937_a(Biome[] biomes, int x, int z, int width, int height) {
        IntCache.func_76446_a();
        if (biomes == null || biomes.length < width * height) {
            biomes = new Biome[width * height];
        }
        int[] ids = this.biomeGen.func_75904_a(x, z, width, height);
        for (int i = 0; i < width * height; ++i) {
            biomes[i] = ids[i] >= 0 && ids[i] <= Biome.field_185377_q.func_148742_b().size() ? Biome.func_150568_d((int)ids[i]) : TABiomes.EMPTINESS;
        }
        return biomes;
    }

    public Biome[] func_76933_b(@Nullable Biome[] oldBiomeList, int x, int z, int width, int depth) {
        return this.func_76931_a(oldBiomeList, x, z, width, depth, true);
    }

    public Biome[] func_76931_a(@Nullable Biome[] biomes, int x, int z, int width, int height, boolean cacheFlag) {
        IntCache.func_76446_a();
        if (biomes == null || biomes.length < width * height) {
            biomes = new Biome[width * height];
        }
        if (cacheFlag && width == 16 && height == 16 && (x & 0xF) == 0 && (z & 0xF) == 0) {
            Biome[] cached = this.cache.func_76839_e(x, z);
            System.arraycopy(cached, 0, biomes, 0, width * height);
            return biomes;
        }
        int[] ids = this.indexGen.func_75904_a(x, z, width, height);
        for (int i = 0; i < width * height; ++i) {
            biomes[i] = ids[i] >= 0 && ids[i] <= Biome.field_185377_q.func_148742_b().size() ? Biome.func_150568_d((int)ids[i]) : TABiomes.EMPTINESS;
        }
        return biomes;
    }

    public boolean func_76940_a(int x, int z, int radius, List<Biome> allowed) {
        IntCache.func_76446_a();
        int xMin = x - radius >> 2;
        int zMin = z - radius >> 2;
        int xMax = x + radius >> 2;
        int zMax = z + radius >> 2;
        int width = xMax - xMin + 1;
        int height = zMax - zMin + 1;
        int[] ids = this.biomeGen.func_75904_a(xMin, zMin, width, height);
        for (int i = 0; i < width * height; ++i) {
            Biome biome = Biome.func_150568_d((int)ids[i]);
            if (allowed.contains(biome)) continue;
            return false;
        }
        return true;
    }

    public BlockPos func_180630_a(int x, int z, int radius, List<Biome> biomes, Random random) {
        IntCache.func_76446_a();
        int xMin = x - radius >> 2;
        int zMin = z - radius >> 2;
        int xMax = x + radius >> 2;
        int zMax = z + radius >> 2;
        int width = xMax - xMin + 1;
        int height = zMax - zMin + 1;
        int[] ids = this.biomeGen.func_75904_a(xMin, zMin, width, height);
        BlockPos ret = null;
        int counter = 0;
        for (int i = 0; i < width * height; ++i) {
            int bX = xMin + i % width << 2;
            int bZ = zMin + i / height << 2;
            Biome biome = Biome.func_150568_d((int)ids[i]);
            if (!biomes.contains(biome) || ret != null && random.nextInt(counter + 1) != 0) continue;
            ret = new BlockPos(bX, 0, bZ);
            ++counter;
        }
        return ret;
    }

    public void func_76938_b() {
        this.cache.func_76838_a();
    }

    static {
        allowedBiomes.clear();
        allowedBiomes.add(TABiomes.EMPTINESS);
        allowedBiomes.add(TABiomes.TAINTED_LANDS);
        allowedBiomes.add(TABiomes.EMPTINESS_HIGHLANDS);
    }
}

