/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.assetmover;

import com.cleanroommc.assetmover.AssetMoverHelper;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Iterator;
import java.util.Map;
import javax.net.ssl.SSLHandshakeException;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.LoaderState;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AssetMoverAPI {
    public static final String VERSION = "2.5";
    static final Logger LOGGER = LogManager.getLogger((String)"AssetMover");
    static final Path PARENT_PATH = Paths.get("", new String[0]).resolve("assetmover");

    public static void fromMinecraft(String version, Map<String, String> assets) {
        AssetMoverAPI.validateLoadingState();
        assets = new Object2ObjectOpenHashMap(assets);
        if (AssetMoverAPI.isUpdated((Map<String, String>)assets)) {
            return;
        }
        try {
            AssetMoverHelper.fromMinecraftVersion(version, (Map<String, String>)assets);
        }
        catch (SSLHandshakeException e) {
            LOGGER.fatal("Unexpected error occurred, perhaps update your Java version?", (Throwable)e);
        }
        catch (IOException e) {
            LOGGER.fatal("Unexpected error occurred", (Throwable)e);
        }
    }

    public static void fromCurseForgeMod(String projectId, String fileId, Map<String, String> assets) {
        AssetMoverAPI.validateLoadingState();
        assets = new Object2ObjectOpenHashMap(assets);
        if (AssetMoverAPI.isUpdated((Map<String, String>)assets)) {
            return;
        }
        try {
            Path file = AssetMoverHelper.getCurseForgeMod(projectId, fileId);
            AssetMoverHelper.moveViaFilesystem(file, (Map<String, String>)assets);
        }
        catch (SSLHandshakeException e) {
            LOGGER.fatal("Unexpected error occurred, perhaps update your Java version?", (Throwable)e);
        }
        catch (IOException | URISyntaxException e) {
            LOGGER.fatal("Unexpected error occurred", (Throwable)e);
        }
    }

    public static void fromUrlFile(String url, Map<String, String> assets) {
        AssetMoverAPI.validateLoadingState();
        try {
            AssetMoverAPI.fromUrlFile(new URL(url), assets);
        }
        catch (MalformedURLException e) {
            LOGGER.fatal("Unexpected error occurred", (Throwable)e);
        }
    }

    public static void fromUrlFile(URL url, Map<String, String> assets) {
        AssetMoverAPI.validateLoadingState();
        assets = new Object2ObjectOpenHashMap(assets);
        if (AssetMoverAPI.isUpdated((Map<String, String>)assets)) {
            return;
        }
        try {
            Path file = AssetMoverHelper.getFileFromUrl(url, url.getFile());
            AssetMoverHelper.moveViaFilesystem(file, (Map<String, String>)assets);
        }
        catch (SSLHandshakeException e) {
            LOGGER.fatal("Unexpected error occurred, perhaps update your Java version?", (Throwable)e);
        }
        catch (IOException | URISyntaxException e) {
            LOGGER.fatal("Unexpected error occurred", (Throwable)e);
        }
    }

    private static void validateLoadingState() {
        if (Loader.instance().hasReachedState(LoaderState.PREINITIALIZATION)) {
            throw new RuntimeException("AssetMover operations can only be performed during FMLConstructionEvent or earlier!");
        }
    }

    private static boolean isUpdated(Map<String, String> assets) {
        boolean allUpdated = true;
        Iterator<Map.Entry<String, String>> iter = assets.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<String, String> entry = iter.next();
            if (Files.exists(PARENT_PATH.resolve(entry.getValue()), new LinkOption[0])) {
                iter.remove();
                continue;
            }
            allUpdated = false;
        }
        return allUpdated;
    }

    private AssetMoverAPI() {
    }
}

