/*
 * Decompiled with CFR 0.152.
 */
package t145.metalchests.api.chests;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import t145.metalchests.api.consts.RegistryMC;

public class UpgradeRegistry {
    private static final Map<ResourceLocation, HashMap<ResourceLocation, ResourceLocation>> UPGRADES = new HashMap<ResourceLocation, HashMap<ResourceLocation, ResourceLocation>>();

    private UpgradeRegistry() {
    }

    public static void register(Item upgrade, Block chest, Block metalChest) {
        ResourceLocation upgradeKey = upgrade.getRegistryName();
        if (!UPGRADES.containsKey(upgradeKey)) {
            UPGRADES.put(upgradeKey, new HashMap());
        }
        HashMap<ResourceLocation, ResourceLocation> blocks = UPGRADES.get(upgradeKey);
        ResourceLocation chestKey = chest.getRegistryName();
        ResourceLocation metalChestKey = metalChest.getRegistryName();
        if (blocks.containsKey(chestKey)) {
            RegistryMC.LOG.warn(String.format("{%s} The chest [%s] is already registered to [%s]!", upgradeKey, chestKey, blocks.get(chestKey)));
        } else {
            blocks.put(chestKey, metalChestKey);
        }
    }

    public static boolean hasMetalChest(Item upgrade, Block chest) {
        return UPGRADES.get(upgrade.getRegistryName()).containsKey(chest.getRegistryName());
    }

    public static Block getMetalChest(Item upgrade, Block chest) {
        return Block.func_149684_b((String)UPGRADES.get(upgrade.getRegistryName()).get(chest.getRegistryName()).toString());
    }

    public static boolean hasMultipleUpgrades() {
        return UPGRADES.size() > 1;
    }
}

