/*
 * Decompiled with CFR 0.152.
 */
package t145.metalchests.api.consts;

import com.google.common.collect.Iterables;
import com.google.gson.JsonObject;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import java.util.Collections;
import java.util.Map;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.util.IStringSerializable;

public enum ChestType implements IStringSerializable
{
    COPPER("ingotCopper", MapColor.field_151658_d),
    IRON("ingotIron", MapColor.field_151668_h),
    SILVER("ingotSilver", MapColor.field_151680_x),
    GOLD("ingotGold", MapColor.field_151647_F),
    DIAMOND("gemDiamond", MapColor.field_151648_G),
    OBSIDIAN("obsidian", Material.field_151576_e, MapColor.field_151654_J, SoundType.field_185851_d);

    public static final ObjectList<ChestType> TIERS;
    private static final Map<String, Integer> ORES;
    private final String ore;
    private final Material material;
    private final MapColor color;
    private final SoundType sound;
    private boolean registered;
    private boolean auto;
    private int index;
    private int rows;
    private int cols;
    private byte holding;

    private ChestType(String ore, Material material, MapColor color, SoundType sound) {
        this.ore = ore;
        this.material = material;
        this.color = color;
        this.sound = sound;
    }

    private ChestType(String ore, MapColor color, SoundType sound) {
        this(ore, Material.field_151573_f, color, sound);
    }

    private ChestType(String ore, MapColor color) {
        this(ore, color, SoundType.field_185852_e);
    }

    public String func_176610_l() {
        return this.name().toLowerCase();
    }

    public String getOre() {
        return this.ore;
    }

    public Material getMaterial() {
        return this.material;
    }

    public MapColor getMapColor() {
        return this.color;
    }

    public SoundType getSoundType() {
        return this.sound;
    }

    void setRows(int rows) {
        this.rows = rows;
    }

    public int getRows() {
        return this.rows;
    }

    void setCols(int cols) {
        this.cols = cols;
    }

    public int getColumns() {
        return this.cols;
    }

    void setIndex(int index) {
        this.index = index;
    }

    public int getIndex() {
        return this.index;
    }

    public int getInventorySize() {
        return this.rows * this.cols;
    }

    void setHolding(byte holding) {
        this.holding = holding;
    }

    public byte getHolding() {
        return this.holding;
    }

    void setRegistered(boolean registered) {
        this.registered = registered;
    }

    public boolean isRegistered() {
        return this.registered;
    }

    public static boolean hasOre(String ore) {
        return ORES.containsKey(ore);
    }

    public static ChestType byOre(String ore) {
        return ChestType.values()[ORES.get(ore)];
    }

    public static void attemptRegister(String ore) {
        if (ChestType.hasOre(ore)) {
            ChestType type = ChestType.byOre(ore);
            if (type.auto && !type.registered) {
                type.setRegistered(true);
                TIERS.add(type.getIndex(), (Object)type);
            }
        }
    }

    private static boolean isEnabled(ChestType type, JsonObject obj) {
        String enabled = obj.getAsJsonPrimitive("enabled").getAsString();
        type.auto = enabled.contentEquals("auto");
        return Boolean.parseBoolean(enabled);
    }

    public static void setTiers(JsonObject settings) {
        for (ChestType type2 : ChestType.values()) {
            JsonObject props = settings.getAsJsonObject("chests").getAsJsonObject(type2.func_176610_l());
            if (props == null) continue;
            int index = props.getAsJsonPrimitive("index").getAsInt();
            type2.setRegistered(ChestType.isEnabled(type2, props));
            type2.setRows(props.getAsJsonPrimitive("rows").getAsInt());
            type2.setCols(props.getAsJsonPrimitive("cols").getAsInt());
            type2.setHolding(props.getAsJsonPrimitive("holding").getAsByte());
            type2.setIndex(index);
            TIERS.set(index, (Object)type2);
            ORES.put(type2.ore, index);
        }
        Iterables.removeIf(TIERS, type -> type == null || !type.registered);
    }

    public static void postInit() {
        for (int i = 0; i < TIERS.size(); i = (int)((short)(i + 1))) {
            ((ChestType)((Object)TIERS.get(i))).setIndex(i);
        }
    }

    static {
        TIERS = new ObjectArrayList(Collections.nCopies(ChestType.values().length - 1, null));
        ORES = new Object2ObjectOpenHashMap(ChestType.values().length);
    }
}

