/*
 * Decompiled with CFR 0.152.
 */
package t145.metalchests.blocks;

import cofh.core.init.CoreEnchantments;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityOcelot;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import t145.metalchests.api.chests.IMetalChest;
import t145.metalchests.api.config.ConfigMC;
import t145.metalchests.api.consts.ChestType;
import t145.metalchests.api.consts.RegistryMC;
import t145.metalchests.tiles.TileMetalChest;

public class BlockMetalChest
extends Block {
    public BlockMetalChest() {
        super(Material.field_151573_f);
        this.registerResource();
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(IMetalChest.VARIANT, (Comparable)((Object)ChestType.IRON)));
        this.func_149711_c(3.0f);
        this.func_149647_a(RegistryMC.TAB);
    }

    protected void registerResource(ResourceLocation resource) {
        this.setRegistryName(resource);
        this.func_149663_c(resource.toString());
    }

    protected void registerResource() {
        this.registerResource(RegistryMC.RESOURCE_METAL_CHEST);
    }

    @Nullable
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileMetalChest((ChestType)((Object)state.func_177229_b(IMetalChest.VARIANT)));
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    public MapColor func_180659_g(IBlockState state, IBlockAccess world, BlockPos pos) {
        return ((ChestType)((Object)state.func_177229_b(IMetalChest.VARIANT))).getMapColor();
    }

    public Material func_149688_o(IBlockState state) {
        return ((ChestType)((Object)state.func_177229_b(IMetalChest.VARIANT))).getMaterial();
    }

    public SoundType getSoundType(IBlockState state, World world, BlockPos pos, @Nullable Entity entity) {
        return ((ChestType)((Object)state.func_177229_b(IMetalChest.VARIANT))).getSoundType();
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_190946_v(IBlockState state) {
        return true;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return Blocks.field_150477_bB.func_176223_P().func_185900_c(world, pos);
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return this.func_185496_a(state, world, pos);
    }

    public float getExplosionResistance(World world, BlockPos pos, Entity exploder, Explosion explosion) {
        TileMetalChest chest;
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileMetalChest && (chest = (TileMetalChest)te).getChestType() == ChestType.OBSIDIAN) {
            return 10000.0f;
        }
        return super.getExplosionResistance(world, pos, exploder, explosion);
    }

    public static ItemStack getDropStack(IMetalChest chest, Block chestBlock) {
        ItemStack stack = new ItemStack(chestBlock, 1, chest.getChestType().ordinal());
        if (ConfigMC.hasThermalExpansion()) {
            NBTTagCompound tag = new NBTTagCompound();
            if (chest.getEnchantLevel() > 0) {
                CoreEnchantments.addEnchantment((NBTTagCompound)tag, (Enchantment)CoreEnchantments.holding, (int)chest.getEnchantLevel());
            }
            if (chest.getEnchantLevel() >= chest.getChestType().getHolding()) {
                chest.writeToNBT(tag);
            }
            if (!tag.func_82582_d()) {
                stack.func_77982_d(tag);
            }
        }
        return stack;
    }

    private ItemStack getDropStack(IBlockAccess world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileMetalChest) {
            TileMetalChest chest = (TileMetalChest)te;
            return BlockMetalChest.getDropStack(chest, chest.func_145838_q());
        }
        return ItemStack.field_190927_a;
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return this.getDropStack((IBlockAccess)world, pos);
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        drops.add((Object)this.getDropStack(world, pos));
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        if (willHarvest) {
            return true;
        }
        return super.removedByPlayer(state, world, pos, player, willHarvest);
    }

    public void func_180657_a(World world, EntityPlayer player, BlockPos pos, IBlockState state, @Nullable TileEntity te, ItemStack tool) {
        super.func_180657_a(world, player, pos, state, te, tool);
        world.func_175698_g(pos);
    }

    public static void dropItems(IMetalChest chest, World world, BlockPos pos) {
        if (!ConfigMC.hasThermalExpansion() || chest.getEnchantLevel() < chest.getChestType().getHolding()) {
            for (int i = 0; i < chest.getInventory().getSlots(); ++i) {
                ItemStack stack = chest.getInventory().getStackInSlot(i);
                if (stack.func_190926_b()) continue;
                InventoryHelper.func_180173_a((World)world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)stack);
            }
        }
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileMetalChest) {
            TileMetalChest chest = (TileMetalChest)te;
            BlockMetalChest.dropItems(chest, world, pos);
            world.func_175666_e(pos, (Block)this);
        }
        world.func_175713_t(pos);
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileMetalChest) {
            TileMetalChest chest = (TileMetalChest)te;
            chest.setFront(placer.func_174811_aO().func_176734_d());
            if (stack.func_82837_s()) {
                chest.setCustomName(stack.func_82833_r());
            }
            if (ConfigMC.hasThermalExpansion() && stack.func_77978_p() != null) {
                chest.setEnchantLevel((byte)MathHelper.func_76125_a((int)EnchantmentHelper.func_77506_a((Enchantment)CoreEnchantments.holding, (ItemStack)stack), (int)0, (int)CoreEnchantments.holding.func_77325_b()));
                if (stack.func_77978_p().func_74764_b("Inventory")) {
                    chest.func_145839_a(stack.func_77978_p());
                }
            }
        }
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K && world.func_175625_s(pos) instanceof TileMetalChest && !player.func_70093_af() && !this.isBlocked(world, pos)) {
            player.openGui((Object)"metalchests", 0, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        }
        return true;
    }

    private boolean isBlocked(World world, BlockPos pos) {
        return this.isBelowSolidBlock(world, pos) || this.isOcelotSittingOnChest(world, pos);
    }

    private boolean isBelowSolidBlock(World world, BlockPos pos) {
        return world.func_180495_p(pos.func_177984_a()).doesSideBlockChestOpening((IBlockAccess)world, pos.func_177984_a(), EnumFacing.DOWN);
    }

    private boolean isOcelotSittingOnChest(World world, BlockPos pos) {
        for (Entity entity : world.func_72872_a(EntityOcelot.class, new AxisAlignedBB((double)pos.func_177958_n(), (double)(pos.func_177956_o() + 1), (double)pos.func_177952_p(), (double)(pos.func_177958_n() + 1), (double)(pos.func_177956_o() + 2), (double)(pos.func_177952_p() + 1)))) {
            EntityOcelot ocelot = (EntityOcelot)entity;
            if (!ocelot.func_70906_o()) continue;
            return true;
        }
        return false;
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public int func_180641_l(IBlockState state, World world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileMetalChest) {
            TileMetalChest chest = (TileMetalChest)te;
            return ItemHandlerHelper.calcRedstoneFromInventory((IItemHandler)chest.getInventory());
        }
        return 0;
    }

    public boolean func_149744_f(IBlockState state) {
        return true;
    }

    public boolean canConnectRedstone(IBlockState state, IBlockAccess world, BlockPos pos, @Nullable EnumFacing side) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileMetalChest) {
            return ((TileMetalChest)te).isTrapped() && side != null;
        }
        return false;
    }

    public int func_180656_a(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        TileMetalChest chest;
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileMetalChest && (chest = (TileMetalChest)te).isTrapped()) {
            return MathHelper.func_76125_a((int)chest.getChestAnimator().numPlayersUsing, (int)0, (int)15);
        }
        return 0;
    }

    public int func_176211_b(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return side == EnumFacing.UP ? state.func_185911_a(world, pos, side) : 0;
    }

    public BlockFaceShape func_193383_a(IBlockAccess world, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public int func_180651_a(IBlockState state) {
        return ((ChestType)((Object)state.func_177229_b(IMetalChest.VARIANT))).ordinal();
    }

    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        ChestType.TIERS.forEach(type -> items.add((Object)new ItemStack((Block)this, 1, type.ordinal())));
    }

    public EnumFacing[] getValidRotations(World world, BlockPos pos) {
        return EnumFacing.Plane.VERTICAL.func_179516_a();
    }

    public boolean rotateBlock(World world, BlockPos pos, EnumFacing axis) {
        if (world.field_72995_K) {
            return false;
        }
        if (axis.func_176740_k().func_176720_b()) {
            TileEntity te = world.func_175625_s(pos);
            if (te instanceof TileMetalChest) {
                TileMetalChest chest = (TileMetalChest)te;
                chest.setFront(chest.getFront().func_176746_e());
            }
            return true;
        }
        return false;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(IMetalChest.VARIANT, (Comparable)((Object)ChestType.values()[meta]));
    }

    public int func_176201_c(IBlockState state) {
        return ((ChestType)((Object)state.func_177229_b(IMetalChest.VARIANT))).ordinal();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{IMetalChest.VARIANT});
    }

    public boolean func_189539_a(IBlockState state, World world, BlockPos pos, int id, int param) {
        TileEntity te = world.func_175625_s(pos);
        return te != null && te.func_145842_c(id, param);
    }
}

