/*
 * Decompiled with CFR 0.152.
 */
package t145.metalchests.blocks;

import cofh.core.init.CoreEnchantments;
import cofh.core.item.IEnchantableItem;
import cofh.core.util.helpers.MathHelper;
import cofh.core.util.helpers.StringHelper;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Optional;
import t145.metalchests.api.config.ConfigMC;
import t145.metalchests.api.consts.ChestType;
import t145.tbone.items.TItemBlock;

@Optional.Interface(modid="thermalexpansion", iface="cofh.core.item.IEnchantableItem", striprefs=true)
public class BlockMetalChestItem
extends TItemBlock
implements IEnchantableItem {
    public BlockMetalChestItem(List<ChestType> types, Block block) {
        super(types, block);
    }

    @Nullable
    public String getCreatorModId(ItemStack stack) {
        return "metalchests";
    }

    public int func_77647_b(int meta) {
        return meta;
    }

    public String func_77667_c(ItemStack stack) {
        if (this.field_77787_bX) {
            return String.format("%s.%s", super.func_77658_a(), ChestType.values()[stack.func_77952_i()].func_176610_l());
        }
        return super.func_77667_c(stack);
    }

    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag flagIn) {
        if (ConfigMC.hasThermalExpansion() && stack.func_77942_o()) {
            byte enchantLevel = (byte)MathHelper.clamp((int)EnchantmentHelper.func_77506_a((Enchantment)CoreEnchantments.holding, (ItemStack)stack), (int)0, (int)CoreEnchantments.holding.func_77325_b());
            if (enchantLevel <= 0) {
                return;
            }
            ChestType type = ChestType.values()[stack.func_77952_i()];
            if (enchantLevel >= type.getHolding()) {
                NBTTagCompound tag = stack.func_77978_p().func_74775_l("Inventory");
                NBTTagList tagList = tag.func_150295_c("Items", 10);
                if (tagList.func_74745_c() > 0) {
                    if (StringHelper.displayShiftForDetail && !StringHelper.isShiftKeyDown()) {
                        tooltip.add(StringHelper.shiftForDetails());
                    }
                    if (!StringHelper.isShiftKeyDown()) {
                        return;
                    }
                    for (int i = 0; i < tagList.func_74745_c(); ++i) {
                        NBTTagCompound itemTags = tagList.func_150305_b(i);
                        int slot = itemTags.func_74762_e("Slot");
                        ItemStack slotStack = new ItemStack(itemTags);
                        if (slot < 0 || slot >= type.getInventorySize()) continue;
                        tooltip.add(String.format("    %sx %s", itemTags.func_74762_e("Count"), slotStack.func_82833_r()));
                    }
                }
            } else {
                tooltip.add(StringHelper.getInfoText((String)"info.metalchests.chest_info.fail"));
            }
        }
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return ConfigMC.hasThermalExpansion() && enchantment == CoreEnchantments.holding && !stack.func_77948_v() && stack.func_190916_E() == 1;
    }

    public boolean func_77616_k(ItemStack stack) {
        return ConfigMC.hasThermalExpansion() && stack.func_190916_E() == 1;
    }

    public int getItemEnchantability(ItemStack stack) {
        return ConfigMC.hasThermalExpansion() ? 10 : 0;
    }

    @Optional.Method(modid="thermalexpansion")
    public boolean canEnchant(ItemStack stack, Enchantment enchantment) {
        return enchantment == CoreEnchantments.holding;
    }
}

