/*
 * Decompiled with CFR 0.152.
 */
package t145.metalchests.client.render.blocks;

import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelChest;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import t145.metalchests.api.chests.IMetalChest;
import t145.metalchests.api.config.ConfigMC;
import t145.metalchests.api.consts.ChestType;
import t145.metalchests.api.consts.RegistryMC;
import t145.metalchests.tiles.TileMetalChest;
import t145.tbone.lib.ChestHelper;

@SideOnly(value=Side.CLIENT)
public class RenderMetalChest
extends TileEntitySpecialRenderer<TileMetalChest> {
    public static final RenderMetalChest INSTANCE = new RenderMetalChest();
    protected final ModelChest model = new ModelChest();

    protected ResourceLocation getActiveResource(ChestType type) {
        return ConfigMC.hollowModelTextures ? RegistryMC.HOLLOW_METAL_CHEST_MODELS[type.ordinal()] : RegistryMC.METAL_CHEST_MODELS[type.ordinal()];
    }

    protected void preRender(ResourceLocation overlay, IMetalChest chest, double x, double y, double z, int destroyStage, float alpha) {
        if (overlay != null) {
            this.func_147499_a(overlay);
            GlStateManager.func_179128_n((int)5890);
            GlStateManager.func_179094_E();
            GlStateManager.func_179152_a((float)4.0f, (float)4.0f, (float)1.0f);
            GlStateManager.func_179109_b((float)0.0625f, (float)0.0625f, (float)0.0625f);
            GlStateManager.func_179128_n((int)5888);
        } else {
            this.func_147499_a(this.getActiveResource(chest.getChestType()));
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179091_B();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        GlStateManager.func_179137_b((double)x, (double)(y + 1.0), (double)(z + 1.0));
        GlStateManager.func_179152_a((float)1.0f, (float)-1.0f, (float)-1.0f);
        GlStateManager.func_179109_b((float)0.5f, (float)0.5f, (float)0.5f);
        GlStateManager.func_179114_b((float)ChestHelper.getFrontAngle((EnumFacing)chest.getFront()), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179109_b((float)-0.5f, (float)-0.5f, (float)-0.5f);
    }

    protected void postRenderModel(IMetalChest chest, float partialTicks) {
        this.model.field_78234_a.field_78795_f = chest.getChestAnimator().getLidAngle(partialTicks);
        this.model.func_78231_a();
    }

    protected void postRenderChest(IMetalChest chest) {
        GlStateManager.func_179101_C();
        GlStateManager.func_179121_F();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    protected void postRenderOverlay(IMetalChest chest) {
        GlStateManager.func_179128_n((int)5890);
        GlStateManager.func_179121_F();
        GlStateManager.func_179128_n((int)5888);
    }

    protected void renderOverlay(ResourceLocation overlay) {
        float scale = 1.002f;
        this.func_147499_a(overlay);
        GlStateManager.func_179094_E();
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
        GlStateManager.func_179109_b((float)-0.001f, (float)-0.001f, (float)-0.001f);
        this.model.func_78231_a();
        GlStateManager.func_179084_k();
        GlStateManager.func_179121_F();
    }

    public void renderChest(IMetalChest chest, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        this.preRender(destroyStage >= 0 ? field_178460_a[destroyStage] : null, chest, x, y, z, destroyStage, alpha);
        this.postRenderModel(chest, partialTicks);
        if (chest.isTrapped()) {
            this.renderOverlay(RegistryMC.OVERLAY_TRAP);
        }
        this.postRenderChest(chest);
        if (destroyStage >= 0) {
            this.postRenderOverlay(chest);
        }
        if (chest.getEnchantLevel() > 0) {
            double spin = (double)Minecraft.func_71386_F() / 1000.0;
            float scale = 0.33333334f;
            this.preRender(RegistryMC.OVERLAY_ENCHANT, chest, x, y, z, destroyStage, alpha);
            GlStateManager.func_179147_l();
            GlStateManager.func_179143_c((int)514);
            GlStateManager.func_179132_a((boolean)false);
            GlStateManager.func_179131_c((float)0.5f, (float)0.5f, (float)0.5f, (float)1.0f);
            for (int i = 0; i < 2; ++i) {
                GlStateManager.func_179140_f();
                GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_COLOR, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
                GlStateManager.func_179131_c((float)0.38f, (float)0.19f, (float)0.608f, (float)1.0f);
                GlStateManager.func_179128_n((int)5890);
                GlStateManager.func_179096_D();
                GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
                GlStateManager.func_179114_b((float)(30.0f - (float)i * 60.0f), (float)0.0f, (float)0.0f, (float)1.0f);
                GlStateManager.func_179137_b((double)0.0, (double)(spin * 32.0 * (double)(0.001f + (float)i * 0.003f) * 20.0), (double)0.0);
                GlStateManager.func_179128_n((int)5888);
                this.postRenderModel(chest, partialTicks);
                GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            }
            GlStateManager.func_179128_n((int)5890);
            GlStateManager.func_179096_D();
            GlStateManager.func_179128_n((int)5888);
            GlStateManager.func_179145_e();
            GlStateManager.func_179132_a((boolean)true);
            GlStateManager.func_179143_c((int)515);
            GlStateManager.func_179084_k();
            this.postRenderChest(chest);
            this.postRenderOverlay(chest);
        }
    }

    public void renderStatic(IMetalChest chest, double x, double y, double z, int destroyStage, float alpha) {
        this.renderChest(chest, x, y, z, 0.0f, destroyStage, alpha);
    }

    protected boolean canRenderNameTag(TileMetalChest chest) {
        return chest.func_145818_k_();
    }

    public void render(TileMetalChest chest, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        if (this.canRenderNameTag(chest)) {
            super.func_192841_a((TileEntity)chest, x, y, z, partialTicks, destroyStage, alpha);
        }
        this.renderChest(chest, x, y, z, partialTicks, destroyStage, alpha);
    }
}

