/*
 * Decompiled with CFR 0.152.
 */
package t145.metalchests.containers;

import invtweaks.api.container.ChestContainer;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;
import t145.metalchests.api.chests.IMetalChest;
import t145.metalchests.api.consts.ChestType;
import t145.tbone.api.IInventoryHandler;

@ChestContainer
public class ContainerMetalChest
extends Container {
    public static final int MAX_COLUMNS = 23;
    public static final int MAX_ROWS = 8;
    public final IInventoryHandler mainInv;
    public final ChestType type;

    public ContainerMetalChest(IInventoryHandler mainInv, InventoryPlayer playerInv, ChestType type) {
        this.mainInv = mainInv;
        this.type = type;
        mainInv.func_174889_b(playerInv.field_70458_d);
        this.setupChestSlots();
        this.setupPlayerSlots(playerInv);
    }

    public ContainerMetalChest(IMetalChest chest, InventoryPlayer playerInv) {
        this(chest, playerInv, chest.getChestType());
    }

    public int getBorderTop() {
        return 17;
    }

    public int getBorderSide() {
        return 7;
    }

    public int getBorderBottom() {
        return 7;
    }

    public int getBufferInventory() {
        return 13;
    }

    public int getBufferHotbar() {
        return 4;
    }

    public int getWidth() {
        return Math.max(this.type.getColumns(), 9) * 18 + this.getBorderSide() * 2;
    }

    public int getHeight() {
        return this.getBorderTop() + this.type.getRows() * 18 + this.getBufferInventory() + 72 + this.getBufferHotbar() + this.getBorderBottom();
    }

    public int getContainerInvWidth() {
        return this.type.getColumns() * 18;
    }

    public int getContainerInvHeight() {
        return this.type.getRows() * 18;
    }

    public int getContainerInvXOffset() {
        return this.getBorderSide() + Math.max(0, (this.getPlayerInvWidth() - this.getContainerInvWidth()) / 2);
    }

    public int getPlayerInvWidth() {
        return 162;
    }

    public int getPlayerInvHeight() {
        return 72 + this.getBufferHotbar();
    }

    public int getPlayerInvXOffset() {
        return this.getBorderSide() + Math.max(0, (this.getContainerInvWidth() - this.getPlayerInvWidth()) / 2);
    }

    protected void setupChestSlots() {
        int xOffset = 1 + this.getContainerInvXOffset();
        int yOffset = 1 + this.getBorderTop();
        int y = 0;
        while (y < this.type.getRows()) {
            for (int x = 0; x < this.type.getColumns(); ++x) {
                this.func_75146_a((Slot)new SlotItemHandler((IItemHandler)this.mainInv.getInventory(), x + y * this.type.getColumns(), xOffset + x * 18, yOffset));
            }
            ++y;
            yOffset += 18;
        }
    }

    protected void setupPlayerSlots(InventoryPlayer playerInv) {
        int xOffset = 1 + this.getPlayerInvXOffset();
        int yOffset = 1 + this.getBorderTop() + this.getContainerInvHeight() + this.getBufferInventory();
        int y = 0;
        while (y < 3) {
            for (int x = 0; x < 9; ++x) {
                this.func_75146_a(new Slot((IInventory)playerInv, x + y * 9 + 9, xOffset + x * 18, yOffset));
            }
            ++y;
            yOffset += 18;
        }
        yOffset += this.getBufferHotbar();
        for (int x = 0; x < 9; ++x) {
            this.func_75146_a(new Slot((IInventory)playerInv, x, xOffset + x * 18, yOffset));
        }
    }

    public boolean func_75145_c(EntityPlayer player) {
        return this.mainInv.func_70300_a(player);
    }

    @OverridingMethodsMustInvokeSuper
    public void func_75134_a(EntityPlayer player) {
        super.func_75134_a(player);
        this.mainInv.func_174886_c(player);
    }

    public ItemStack func_82846_b(EntityPlayer player, int index) {
        Slot slot = (Slot)this.field_75151_b.get(index);
        ItemStack result = ItemStack.field_190927_a;
        if (slot != null && slot.func_75216_d()) {
            ItemStack stack = slot.func_75211_c();
            result = stack.func_77946_l();
            int slotCount = this.field_75151_b.size() - player.field_71071_by.field_70462_a.size();
            if (index < slotCount ? !this.func_75135_a(stack, slotCount, this.field_75151_b.size(), true) : !this.func_75135_a(stack, 0, slotCount, false)) {
                return ItemStack.field_190927_a;
            }
            slot.func_75218_e();
        }
        return result;
    }

    @ChestContainer.RowSizeCallback
    public int getRowSize() {
        return this.type.getColumns();
    }
}

