/*
 * Decompiled with CFR 0.152.
 */
package t145.metalchests.core;

import cubex2.mods.chesttransporter.api.TransportableChest;
import cubex2.mods.chesttransporter.chests.TransportableChestImpl;
import cubex2.mods.chesttransporter.chests.TransportableChestOld;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import t145.metalchests.api.config.ConfigMC;
import t145.metalchests.api.consts.ChestType;
import t145.metalchests.api.consts.RegistryMC;
import t145.metalchests.api.objs.BlocksMC;
import thaumcraft.api.blocks.BlocksTC;

@Mod.EventBusSubscriber(modid="metalchests")
class CompatChestTransporter {
    private CompatChestTransporter() {
    }

    @Optional.Method(modid="chesttransporter")
    @SubscribeEvent
    public static void registerChestTransporter(RegistryEvent.Register<TransportableChest> event) {
        IForgeRegistry registry = event.getRegistry();
        registry.register((IForgeRegistryEntry)new TransportableMetalChestImpl(BlocksMC.METAL_CHEST, "metal_chest"));
        if (ConfigMC.hasThaumcraft()) {
            registry.register((IForgeRegistryEntry)new TransportableChestOld(BlocksTC.hungryChest, -1, 1, "vanilla"));
            registry.register((IForgeRegistryEntry)new TransportableMetalChestImpl(BlocksMC.METAL_HUNGRY_CHEST, "hungry/", "metal_hungry_chest"));
        }
        if (ConfigMC.hasRefinedRelocation()) {
            registry.register((IForgeRegistryEntry)new TransportableMetalChestImpl(BlocksMC.METAL_SORTING_CHEST, "metal_sorting_chest"));
            if (ConfigMC.hasThaumcraft()) {
                registry.register((IForgeRegistryEntry)new TransportableMetalChestImpl(BlocksMC.METAL_SORTING_HUNGRY_CHEST, "hungry/", "metal_sorting_hungry_chest"));
            }
        }
    }

    static class TransportableMetalChestImpl
    extends TransportableChestImpl {
        private final String prefix;

        public TransportableMetalChestImpl(Block chestBlock, String prefix, String name) {
            super(chestBlock, -1, name);
            this.prefix = prefix;
        }

        public TransportableMetalChestImpl(Block chestBlock, String name) {
            this(chestBlock, "", name);
        }

        public boolean copyTileEntity() {
            return true;
        }

        public ItemStack createChestStack(ItemStack transporter) {
            ItemStack stack = super.createChestStack(transporter);
            NBTTagCompound tag = transporter.func_77978_p().func_74775_l("ChestTile");
            stack.func_77964_b(ChestType.valueOf(tag.func_74779_i("ChestType")).ordinal());
            return stack;
        }

        public ResourceLocation getChestModel(ItemStack transporter) {
            NBTTagCompound tag = transporter.func_77978_p().func_74775_l("ChestTile");
            return RegistryMC.getResource(String.format("item/chesttransporter/%s%s", this.prefix, tag.func_74779_i("ChestType").toLowerCase()));
        }

        public Collection<ResourceLocation> getChestModels() {
            ArrayList<ResourceLocation> models = new ArrayList<ResourceLocation>();
            ChestType.TIERS.forEach(type -> models.add(RegistryMC.getResource(String.format("item/chesttransporter/%s%s", this.prefix, type.func_176610_l()))));
            return models;
        }

        public NBTTagCompound modifyTileCompound(NBTTagCompound tag, World world, BlockPos pos, EntityPlayer player, ItemStack transporter) {
            tag.func_74778_a("Front", player.func_174811_aO().func_176734_d().toString());
            return super.modifyTileCompound(tag, world, pos, player, transporter);
        }
    }
}

