/*
 * Decompiled with CFR 0.152.
 */
package t145.metalchests.core;

import mezz.jei.api.IItemBlacklist;
import mezz.jei.api.IJeiRuntime;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.JEIPlugin;
import net.minecraft.item.ItemStack;
import t145.metalchests.api.config.ConfigMC;
import t145.metalchests.api.consts.ChestType;
import t145.metalchests.api.consts.ChestUpgrade;
import t145.metalchests.api.objs.BlocksMC;
import t145.metalchests.api.objs.ItemsMC;

@JEIPlugin
public class CompatJEI
implements IModPlugin {
    private IItemBlacklist blacklist;

    public void register(IModRegistry registry) {
        this.blacklist = registry.getJeiHelpers().getItemBlacklist();
        if (ConfigMC.hasThaumcraft()) {
            ChestType.TIERS.forEach(type -> registry.addDescription(new ItemStack(BlocksMC.METAL_HUNGRY_CHEST, 1, type.ordinal()), new String[]{"info.metalchests.jei_hungry_reminder", "info.metalchests.jei_hungry_cost"}));
            ChestUpgrade.TIERS.forEach(type -> registry.addDescription(new ItemStack(ItemsMC.HUNGRY_CHEST_UPGRADE, 1, type.ordinal()), new String[]{"info.metalchests.jei_hungry_reminder", "info.metalchests.jei_hungry_cost"}));
        }
    }

    public void onRuntimeAvailable(IJeiRuntime runtime) {
        for (ChestType type : ChestType.values()) {
            if (type.isRegistered()) continue;
            this.blacklist.addItemToBlacklist(new ItemStack(BlocksMC.METAL_CHEST, 1, type.ordinal()));
            if (ConfigMC.hasThaumcraft()) {
                this.blacklist.addItemToBlacklist(new ItemStack(BlocksMC.METAL_HUNGRY_CHEST, 1, type.ordinal()));
            }
            if (!ConfigMC.hasRefinedRelocation()) continue;
            this.blacklist.addItemToBlacklist(new ItemStack(BlocksMC.METAL_SORTING_CHEST, 1, type.ordinal()));
            if (!ConfigMC.hasThaumcraft()) continue;
            this.blacklist.addItemToBlacklist(new ItemStack(BlocksMC.METAL_SORTING_HUNGRY_CHEST, 1, type.ordinal()));
        }
    }
}

