/*
 * Decompiled with CFR 0.152.
 */
package t145.metalchests.core;

import java.util.List;
import javax.annotation.Nullable;
import net.blay09.mods.refinedrelocation.ModBlocks;
import net.blay09.mods.refinedrelocation.item.ItemSortingUpgrade;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.commons.lang3.text.WordUtils;
import t145.metalchests.api.chests.IMetalChest;
import t145.metalchests.api.chests.UpgradeRegistry;
import t145.metalchests.api.config.ConfigMC;
import t145.metalchests.api.consts.ChestType;
import t145.metalchests.api.consts.RegistryMC;
import t145.metalchests.api.objs.BlocksMC;
import t145.metalchests.api.objs.ItemsMC;
import t145.metalchests.blocks.BlockMetalChest;
import t145.metalchests.blocks.BlockMetalChestItem;
import t145.metalchests.client.render.blocks.RenderMetalSortingChest;
import t145.metalchests.tiles.TileMetalChest;
import t145.metalchests.tiles.TileMetalHungryChest;
import t145.metalchests.tiles.TileMetalSortingChest;
import t145.metalchests.tiles.TileMetalSortingHungryChest;
import t145.tbone.core.TClient;
import t145.tbone.core.TServer;

@Mod.EventBusSubscriber(modid="metalchests")
class CompatRefinedRelocation {
    private CompatRefinedRelocation() {
    }

    @Optional.Method(modid="refinedrelocation")
    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> event) {
        IForgeRegistry registry = event.getRegistry();
        BlocksMC.METAL_SORTING_CHEST = new BlockMetalChest(){

            @Override
            protected void registerResource() {
                this.registerResource(RegistryMC.RESOURCE_METAL_SORTING_CHEST);
            }

            @Override
            @Nullable
            public TileEntity createTileEntity(World world, IBlockState state) {
                return new TileMetalSortingChest((ChestType)((Object)state.func_177229_b(IMetalChest.VARIANT)));
            }
        };
        registry.register((IForgeRegistryEntry)BlocksMC.METAL_SORTING_CHEST);
        TServer.registerTileEntity(TileMetalSortingChest.class, (String)"metalchests");
    }

    @Optional.Method(modid="refinedrelocation")
    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        IForgeRegistry registry = event.getRegistry();
        registry.register((IForgeRegistryEntry)new BlockMetalChestItem((List<ChestType>)ChestType.TIERS, BlocksMC.METAL_SORTING_CHEST));
    }

    @Optional.Method(modid="refinedrelocation")
    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public static void registerModels(ModelRegistryEvent event) {
        ChestType.TIERS.forEach(type -> TClient.registerModel((String)"metalchests", (Block)BlocksMC.METAL_SORTING_CHEST, (int)type.ordinal(), (IStringSerializable)type));
        TClient.registerTileRenderer(TileMetalSortingChest.class, (TileEntitySpecialRenderer)new RenderMetalSortingChest());
    }

    private static void registerSortingChestRecipe(Block baseChest, Block metalChest, ChestType type, String postfix) {
        GameRegistry.addShapedRecipe((ResourceLocation)RegistryMC.getResource(String.format("recipeChest%s%sAlt", WordUtils.capitalize((String)type.func_176610_l()), postfix)), null, (ItemStack)new ItemStack(metalChest, 1, type.ordinal()), (Object[])new Object[]{" a ", "bcb", " d ", Character.valueOf('a'), Items.field_151099_bA, Character.valueOf('b'), Items.field_151137_ax, Character.valueOf('c'), new ItemStack(baseChest, 1, type.ordinal()), Character.valueOf('d'), Blocks.field_150438_bZ});
    }

    @Optional.Method(modid="refinedrelocation")
    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void registerRecipes(RegistryEvent.Register<IRecipe> event) {
        UpgradeRegistry.register(ItemsMC.CHEST_UPGRADE, ModBlocks.sortingChest, BlocksMC.METAL_SORTING_CHEST);
        for (ChestType type : ChestType.TIERS) {
            CompatRefinedRelocation.registerSortingChestRecipe(BlocksMC.METAL_CHEST, BlocksMC.METAL_SORTING_CHEST, type, "Sorting");
            if (!ConfigMC.hasThaumcraft()) continue;
            CompatRefinedRelocation.registerSortingChestRecipe(BlocksMC.METAL_HUNGRY_CHEST, BlocksMC.METAL_SORTING_HUNGRY_CHEST, type, "SortingHungry");
        }
    }

    @Optional.Method(modid="refinedrelocation")
    @SubscribeEvent
    public static void activate(PlayerInteractEvent.RightClickBlock event) {
        World world = event.getWorld();
        BlockPos pos = event.getPos();
        TileEntity te = world.func_175625_s(pos);
        if (!world.field_72995_K && te instanceof TileMetalChest) {
            EntityPlayer player = event.getEntityPlayer();
            ItemStack stack = event.getItemStack();
            if (player.func_70093_af() && stack.func_77973_b() instanceof ItemSortingUpgrade) {
                te.func_145836_u();
                TileMetalChest oldChest = (TileMetalChest)te;
                TileMetalSortingChest newChest = te instanceof TileMetalHungryChest ? new TileMetalSortingHungryChest(oldChest.getChestType()) : new TileMetalSortingChest(oldChest.getChestType());
                Block chestBlock = newChest instanceof TileMetalSortingHungryChest ? BlocksMC.METAL_SORTING_HUNGRY_CHEST : BlocksMC.METAL_SORTING_CHEST;
                world.func_175713_t(pos);
                world.func_175698_g(pos);
                world.func_175690_a(pos, (TileEntity)newChest);
                IBlockState state = chestBlock.func_176223_P().func_177226_a(IMetalChest.VARIANT, (Comparable)((Object)newChest.getChestType()));
                world.func_180501_a(pos, state, 3);
                TileMetalChest chest = (TileMetalChest)world.func_175625_s(pos);
                if (chest != null) {
                    chest.setInventory((IItemHandler)oldChest.getInventory());
                    chest.setFront(oldChest.getFront());
                }
            }
        }
    }
}

