/*
 * Decompiled with CFR 0.152.
 */
package t145.metalchests.core;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import t145.metalchests.api.chests.IMetalChest;
import t145.metalchests.api.chests.UpgradeRegistry;
import t145.metalchests.api.config.ConfigMC;
import t145.metalchests.api.consts.ChestType;
import t145.metalchests.api.consts.ChestUpgrade;
import t145.metalchests.api.consts.RegistryMC;
import t145.metalchests.api.objs.BlocksMC;
import t145.metalchests.api.objs.ItemsMC;
import t145.metalchests.blocks.BlockMetalChest;
import t145.metalchests.blocks.BlockMetalChestItem;
import t145.metalchests.client.render.blocks.RenderMetalChest;
import t145.metalchests.client.render.blocks.RenderMetalSortingChest;
import t145.metalchests.items.ItemChestUpgrade;
import t145.metalchests.recipes.RecipeHandler;
import t145.metalchests.tiles.TileMetalHungryChest;
import t145.metalchests.tiles.TileMetalSortingHungryChest;
import t145.tbone.core.TClient;
import t145.tbone.core.TServer;
import t145.tbone.lib.ChestHelper;
import thaumcraft.api.blocks.BlocksTC;

@Mod.EventBusSubscriber(modid="metalchests")
class CompatThaumcraft {
    private CompatThaumcraft() {
    }

    @Optional.Method(modid="thaumcraft")
    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> event) {
        IForgeRegistry registry = event.getRegistry();
        BlocksMC.METAL_HUNGRY_CHEST = new BlockMetalChest(){

            @Override
            protected void registerResource() {
                this.registerResource(RegistryMC.RESOURCE_METAL_HUNGRY_CHEST);
            }

            @Override
            @Nullable
            public TileEntity createTileEntity(World world, IBlockState state) {
                return new TileMetalHungryChest((ChestType)((Object)state.func_177229_b(IMetalChest.VARIANT)));
            }

            public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
                ChestHelper.tryToEatItem((World)world, (BlockPos)pos, (Entity)entity, (Block)this);
            }
        };
        registry.register((IForgeRegistryEntry)BlocksMC.METAL_HUNGRY_CHEST);
        TServer.registerTileEntity(TileMetalHungryChest.class, (String)"metalchests");
        if (ConfigMC.hasRefinedRelocation()) {
            BlocksMC.METAL_SORTING_HUNGRY_CHEST = new BlockMetalChest(){

                @Override
                protected void registerResource() {
                    this.registerResource(RegistryMC.RESOURCE_METAL_SORTING_HUNGRY_CHEST);
                }

                @Override
                @Nullable
                public TileEntity createTileEntity(World world, IBlockState state) {
                    return new TileMetalSortingHungryChest((ChestType)((Object)state.func_177229_b(IMetalChest.VARIANT)));
                }

                public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
                    ChestHelper.tryToEatItem((World)world, (BlockPos)pos, (Entity)entity, (Block)this);
                }
            };
            registry.register((IForgeRegistryEntry)BlocksMC.METAL_SORTING_HUNGRY_CHEST);
            TServer.registerTileEntity(TileMetalSortingHungryChest.class, (String)"metalchests");
        }
    }

    @Optional.Method(modid="thaumcraft")
    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        IForgeRegistry registry = event.getRegistry();
        registry.register((IForgeRegistryEntry)new BlockMetalChestItem((List<ChestType>)ChestType.TIERS, BlocksMC.METAL_HUNGRY_CHEST));
        if (ConfigMC.hasRefinedRelocation()) {
            registry.register((IForgeRegistryEntry)new BlockMetalChestItem((List<ChestType>)ChestType.TIERS, BlocksMC.METAL_SORTING_HUNGRY_CHEST));
        }
        ItemsMC.HUNGRY_CHEST_UPGRADE = new ItemChestUpgrade(RegistryMC.RESOURCE_HUNGRY_CHEST_UPGRADE);
        registry.register((IForgeRegistryEntry)ItemsMC.HUNGRY_CHEST_UPGRADE);
    }

    @Optional.Method(modid="thaumcraft")
    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public static void registerModels(ModelRegistryEvent event) {
        ChestType.TIERS.forEach(type -> TClient.registerModel((String)"metalchests", (Block)BlocksMC.METAL_HUNGRY_CHEST, (int)type.ordinal(), (IStringSerializable)type));
        for (int i = 0; i < ChestUpgrade.TIERS.size(); i = (int)((short)(i + 1))) {
            ChestUpgrade type2 = (ChestUpgrade)ChestUpgrade.TIERS.get(i);
            TClient.registerModel((String)"metalchests", (Item)ItemsMC.HUNGRY_CHEST_UPGRADE, (String)String.format("item_%s", "hungry_chest_upgrade"), (int)i, (String[])new String[]{String.format("item=%s", type2.func_176610_l())});
        }
        TClient.registerTileRenderer(TileMetalHungryChest.class, (TileEntitySpecialRenderer)new RenderMetalChest(){

            @Override
            protected ResourceLocation getActiveResource(ChestType type) {
                return RegistryMC.METAL_HUNGRY_CHEST_MODELS[type.ordinal()];
            }
        });
        if (ConfigMC.hasRefinedRelocation()) {
            ChestType.TIERS.forEach(type -> TClient.registerModel((String)"metalchests", (Block)BlocksMC.METAL_SORTING_HUNGRY_CHEST, (int)type.ordinal(), (String[])new String[]{TClient.getVariantName((IStringSerializable)type)}));
            TClient.registerTileRenderer(TileMetalSortingHungryChest.class, (TileEntitySpecialRenderer)new RenderMetalSortingChest(){

                @Override
                protected ResourceLocation getActiveResource(ChestType type) {
                    return RegistryMC.METAL_HUNGRY_CHEST_MODELS[type.ordinal()];
                }

                @Override
                protected ResourceLocation getActiveOverlay(ChestType type) {
                    return RegistryMC.SORTING_HUNGRY_OVERLAY_MODELS[type.ordinal()];
                }
            });
        }
    }

    @Optional.Method(modid="thaumcraft")
    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void registerRecipes(RegistryEvent.Register<IRecipe> event) {
        UpgradeRegistry.register(ItemsMC.HUNGRY_CHEST_UPGRADE, BlocksTC.hungryChest, BlocksMC.METAL_HUNGRY_CHEST);
        RecipeHandler.registerHungryChests(BlocksTC.hungryChest, BlocksMC.METAL_HUNGRY_CHEST, "Hungry");
        RecipeHandler.registerHungryUpgrades();
    }
}

