/*
 * Decompiled with CFR 0.152.
 */
package t145.metalchests.core;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonIOException;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.HashSet;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIOcelotSit;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.entity.passive.EntityOcelot;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.datafix.FixTypes;
import net.minecraft.util.datafix.IDataWalker;
import net.minecraft.util.datafix.IFixType;
import net.minecraft.util.datafix.IFixableData;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.common.util.CompoundDataFixer;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ModMetadata;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import t145.metalchests.api.chests.UpgradeRegistry;
import t145.metalchests.api.config.ConfigMC;
import t145.metalchests.api.consts.ChestType;
import t145.metalchests.api.consts.ChestUpgrade;
import t145.metalchests.api.consts.RegistryMC;
import t145.metalchests.api.objs.BlocksMC;
import t145.metalchests.api.objs.ItemsMC;
import t145.metalchests.blocks.BlockMetalChest;
import t145.metalchests.blocks.BlockMetalChestItem;
import t145.metalchests.client.gui.GuiMetalChest;
import t145.metalchests.client.render.blocks.RenderMetalChest;
import t145.metalchests.containers.ContainerMetalChest;
import t145.metalchests.data.MetalChestFixer;
import t145.metalchests.data.MetalChestWalker;
import t145.metalchests.entities.ai.EntityAIOcelotSitOnChest;
import t145.metalchests.items.ItemChestUpgrade;
import t145.metalchests.recipes.RecipeHandler;
import t145.metalchests.tiles.TileMetalChest;
import t145.metalchests.tiles.TileMetalHungryChest;
import t145.metalchests.tiles.TileMetalSortingChest;
import t145.metalchests.tiles.TileMetalSortingHungryChest;
import t145.tbone.core.TClient;
import t145.tbone.core.TServer;

@Mod(modid="metalchests", name="MetalChests", version="v6.1.0+mc1.12.2", updateJSON="https://raw.githubusercontent.com/T145/metalchests/master/update.json", dependencies="required-after:tbone;after:chesttransporter;after:thaumcraft", acceptedMinecraftVersions="[1.12.2]")
@Mod.EventBusSubscriber
public class MetalChests
implements IGuiHandler {
    public static final String VERSION = "v6.1.0+mc1.12.2";
    public static final String UPDATE_JSON = "https://raw.githubusercontent.com/T145/metalchests/master/update.json";
    @Mod.Instance(value="metalchests")
    public static MetalChests instance;

    public MetalChests() {
        TServer.registerMod((String)"metalchests", (String)"MetalChests");
    }

    public static boolean isDeobfuscated() {
        return VERSION.contentEquals(VERSION);
    }

    private static void generateConfig(File cfg) throws IOException {
        FileWriter writer = new FileWriter(cfg.getAbsolutePath());
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        JsonParser jp = new JsonParser();
        JsonElement je = jp.parse(String.format("{\r\n  \"_comment_version\": \"The mod version this config was generated under. If this mismatches the current version, this config will be regenerated.\",\r\n  \"version\": \"%s\",\r\n  \"_comment_enabled_auto\": \"The enabled auto option will enable the variant if it finds its corresponding oredict name existing.\",\r\n  \"_comment_enabled_auto_1\": \"Automatically configured variants behave as though they do not exist when first loading the mod,\",\r\n  \"_comment_enabled_auto_2\": \"so label their index at the *expected* position in the order if they are loaded.\",\r\n  \"_comment_enabled_toggle\": \"Set enabled to true or false for explicit variant toggling.\",\r\n  \"_comment_size\": \"Change the number of rows and columns for chest inventories (max 8 rows x 23 cols., or 192 slots)\",\r\n  \"chests\": {\r\n    \"copper\": {\r\n      \"index\": 0,\r\n      \"enabled\": \"auto\",\r\n      \"rows\": 5,\r\n      \"cols\": 9,\r\n      \"holding\": 1\r\n    },\r\n    \"iron\": {\r\n      \"index\": 0,\r\n      \"enabled\": true,\r\n      \"rows\": 6,\r\n      \"cols\": 9,\r\n      \"holding\": 1\r\n    },\r\n    \"silver\": {\r\n      \"index\": 2,\r\n      \"enabled\": \"auto\",\r\n      \"rows\": 6,\r\n      \"cols\": 12,\r\n      \"holding\": 2\r\n    },\r\n    \"gold\": {\r\n      \"index\": 1,\r\n      \"enabled\": true,\r\n      \"rows\": 5,\r\n      \"cols\": 16,\r\n      \"holding\": 2\r\n    },\r\n    \"diamond\": {\r\n      \"index\": 2,\r\n      \"enabled\": true,\r\n      \"rows\": 6,\r\n      \"cols\": 18,\r\n      \"holding\": 3\r\n    },\r\n    \"obsidian\": {\r\n      \"index\": 3,\r\n      \"enabled\": true,\r\n      \"rows\": 6,\r\n      \"cols\": 18,\r\n      \"holding\": 4\r\n    }\r\n  }\r\n}", VERSION));
        writer.write(gson.toJson(je));
        writer.close();
    }

    private static JsonObject getJsonObj(File cfg) throws JsonIOException, JsonSyntaxException, FileNotFoundException {
        return (JsonObject)new JsonParser().parse((Reader)new FileReader(cfg));
    }

    private static JsonObject loadSettings() {
        File cfg = new File(String.format("%s/T145/%s.json", Loader.instance().getConfigDir(), "MetalChests"));
        try {
            if (cfg.exists()) {
                JsonObject obj = MetalChests.getJsonObj(cfg);
                if (VERSION.contentEquals(obj.get("version").getAsString())) {
                    return obj;
                }
                if (ConfigMC.regenConfig) {
                    MetalChests.generateConfig(cfg);
                }
            } else {
                MetalChests.generateConfig(cfg);
            }
            return MetalChests.getJsonObj(cfg);
        }
        catch (JsonIOException | JsonSyntaxException | IOException err) {
            RegistryMC.LOG.catching(err);
            return null;
        }
    }

    public ContainerMetalChest getServerGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new ContainerMetalChest((TileMetalChest)world.func_175625_s(new BlockPos(x, y, z)), player.field_71071_by);
    }

    @SideOnly(value=Side.CLIENT)
    public GuiMetalChest getClientGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new GuiMetalChest(this.getServerGuiElement(ID, player, world, x, y, z));
    }

    @SubscribeEvent
    public static void metalchests$updateConfig(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("metalchests")) {
            ConfigManager.sync((String)"metalchests", (Config.Type)Config.Type.INSTANCE);
        }
    }

    @Mod.EventHandler
    public void metalchests$preInit(FMLPreInitializationEvent event) {
        ChestType.setTiers(MetalChests.loadSettings());
        ModMetadata meta = event.getModMetadata();
        meta.authorList.add("T145");
        meta.autogenerated = false;
        meta.credits = "The fans!";
        meta.description = "The better alternative to IronChests";
        meta.logoFile = "logo.png";
        meta.modId = "metalchests";
        meta.name = "MetalChests";
        meta.url = "https://github.com/T145/metalchests";
        meta.useDependencyInformation = false;
        meta.version = VERSION;
    }

    @Mod.EventHandler
    public void metalchests$init(FMLInitializationEvent event) {
        int version;
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)instance, (IGuiHandler)this);
        int n = version = MetalChests.isDeobfuscated() ? 1 : Integer.parseInt(VERSION.substring(0, VERSION.indexOf(43)));
        if (ConfigMC.forceDataFixing) {
            ++version;
        }
        CompoundDataFixer fixers = FMLCommonHandler.instance().getDataFixer();
        CompoundDataFixer walkers = FMLCommonHandler.instance().getDataFixer();
        fixers.init("metalchests", version).registerFix((IFixType)FixTypes.BLOCK_ENTITY, (IFixableData)new MetalChestFixer(version));
        walkers.func_188258_a(FixTypes.BLOCK_ENTITY, (IDataWalker)new MetalChestWalker(TileMetalChest.class));
        if (ConfigMC.hasThaumcraft()) {
            walkers.func_188258_a(FixTypes.BLOCK_ENTITY, (IDataWalker)new MetalChestWalker(TileMetalHungryChest.class));
        }
        if (ConfigMC.hasRefinedRelocation()) {
            walkers.func_188258_a(FixTypes.BLOCK_ENTITY, (IDataWalker)new MetalChestWalker(TileMetalSortingChest.class));
            if (ConfigMC.hasThaumcraft()) {
                walkers.func_188258_a(FixTypes.BLOCK_ENTITY, (IDataWalker)new MetalChestWalker(TileMetalSortingHungryChest.class));
            }
        }
    }

    @Mod.EventHandler
    public void metalchests$postInit(FMLPostInitializationEvent event) {
        OreDictionary.getOres((String)"chestWood").forEach(stack -> UpgradeRegistry.register(ItemsMC.CHEST_UPGRADE, Block.func_149634_a((Item)stack.func_77973_b()), BlocksMC.METAL_CHEST));
        OreDictionary.getOres((String)"chestTrapped").forEach(stack -> UpgradeRegistry.register(ItemsMC.CHEST_UPGRADE, Block.func_149634_a((Item)stack.func_77973_b()), BlocksMC.METAL_CHEST));
    }

    @SubscribeEvent
    public static void metalchests$registerBlocks(RegistryEvent.Register<Block> event) {
        IForgeRegistry registry = event.getRegistry();
        BlocksMC.METAL_CHEST = new BlockMetalChest();
        registry.register((IForgeRegistryEntry)BlocksMC.METAL_CHEST);
        TServer.registerTileEntity(TileMetalChest.class, (String)"metalchests");
    }

    @SubscribeEvent
    public static void metalchests$registerItems(RegistryEvent.Register<Item> event) {
        IForgeRegistry registry = event.getRegistry();
        registry.register((IForgeRegistryEntry)new BlockMetalChestItem((List<ChestType>)ChestType.TIERS, BlocksMC.METAL_CHEST));
        ItemsMC.CHEST_UPGRADE = new ItemChestUpgrade(RegistryMC.RESOURCE_CHEST_UPGRADE);
        registry.register((IForgeRegistryEntry)ItemsMC.CHEST_UPGRADE);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void metalchests$registerRecipes(RegistryEvent.Register<IRecipe> event) {
        ChestType.postInit();
        RecipeHandler.registerChests("chestWood", BlocksMC.METAL_CHEST, "");
        RecipeHandler.registerUpgrades(ItemsMC.CHEST_UPGRADE, "plankWood", "");
    }

    @SubscribeEvent
    public static void metalchests$registerOre(OreDictionary.OreRegisterEvent event) {
        ChestType.attemptRegister(event.getName());
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public static void metalchests$registerModels(ModelRegistryEvent event) {
        ChestType.TIERS.forEach(type -> TClient.registerModel((String)"metalchests", (Block)BlocksMC.METAL_CHEST, (int)type.ordinal(), (IStringSerializable)type));
        TClient.registerTileRenderer(TileMetalChest.class, (TileEntitySpecialRenderer)RenderMetalChest.INSTANCE);
        for (ChestUpgrade upgrade : ChestUpgrade.TIERS) {
            TClient.registerModel((String)"metalchests", (Item)ItemsMC.CHEST_UPGRADE, (String)String.format("item_%s", "chest_upgrade"), (int)upgrade.ordinal(), (String[])new String[]{String.format("item=%s", upgrade.func_176610_l())});
        }
    }

    @SubscribeEvent
    public static void metalchests$tickOcelot(LivingEvent.LivingUpdateEvent event) {
        EntityLivingBase creature = event.getEntityLiving();
        if (creature instanceof EntityOcelot && creature.field_70173_aa < 5) {
            EntityOcelot ocelot = (EntityOcelot)creature;
            HashSet<EntityAITasks.EntityAITaskEntry> tasks = new HashSet<EntityAITasks.EntityAITaskEntry>();
            for (EntityAITasks.EntityAITaskEntry task : ocelot.field_70714_bg.field_75782_a) {
                if (task.field_75733_a.getClass() != EntityAIOcelotSit.class) continue;
                tasks.add(task);
            }
            for (EntityAITasks.EntityAITaskEntry task : tasks) {
                ocelot.field_70714_bg.func_85156_a(task.field_75733_a);
                ocelot.field_70714_bg.func_75776_a(task.field_75731_b, (EntityAIBase)new EntityAIOcelotSitOnChest(ocelot, 0.4f));
            }
        }
    }

    @SubscribeEvent
    public static void metalchests$activateMetalChest(PlayerInteractEvent.RightClickBlock event) {
        EntityPlayer player;
        BlockPos pos;
        World world = event.getWorld();
        TileEntity te = world.func_175625_s(pos = event.getPos());
        if (te instanceof TileMetalChest && (player = event.getEntityPlayer()).func_70093_af()) {
            TileMetalChest chest = (TileMetalChest)te;
            ItemStack stack = event.getItemStack();
            boolean hasRedstone = stack.func_77973_b().equals(Items.field_151137_ax);
            if (hasRedstone) {
                if (chest.isTrapped()) {
                    chest.setTrapped(false);
                } else {
                    if (!player.field_71075_bZ.field_75098_d) {
                        stack.func_190918_g(1);
                    }
                    chest.setTrapped(true);
                }
                event.setCanceled(true);
            }
        }
    }
}

