/*
 * Decompiled with CFR 0.152.
 */
package t145.metalchests.items;

import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.tileentity.TileEntityEnderChest;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import t145.metalchests.api.chests.IMetalChest;
import t145.metalchests.api.chests.UpgradeRegistry;
import t145.metalchests.api.consts.ChestType;
import t145.metalchests.api.consts.ChestUpgrade;
import t145.metalchests.api.consts.RegistryMC;
import t145.tbone.items.TItem;

public class ItemChestUpgrade
extends TItem {
    public ItemChestUpgrade(ResourceLocation resource) {
        super(ChestUpgrade.TIERS, resource, RegistryMC.TAB);
        this.func_77625_d(1);
    }

    private boolean canUpdateChest(TileEntity te, ChestType base) {
        if (te instanceof IMetalChest) {
            IMetalChest chest = (IMetalChest)te;
            return chest.getChestType() == base && !chest.getChestAnimator().isOpen() && chest.canUpgradeUsing((Item)this);
        }
        if (UpgradeRegistry.hasMetalChest((Item)this, te.func_145838_q())) {
            te.func_145836_u();
            if (te instanceof TileEntityChest) {
                TileEntityChest vanillaChest = (TileEntityChest)te;
                if (vanillaChest.field_145989_m > 0.0f) {
                    return false;
                }
            }
            if (te instanceof TileEntityEnderChest) {
                TileEntityEnderChest enderChest = (TileEntityEnderChest)te;
                if (enderChest.field_145972_a > 0.0f) {
                    return false;
                }
            }
            return te != null;
        }
        return false;
    }

    private IBlockState createBlockState(Block upgradeBlock, ChestType upgrade) {
        return upgradeBlock.func_176223_P().func_177226_a(IMetalChest.VARIANT, (Comparable)((Object)upgrade));
    }

    private EnumFacing getBlockFront(EntityPlayer player, World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        for (IProperty prop : state.func_177228_b().keySet()) {
            if (!prop.func_177701_a().equals("facing") && !prop.func_177701_a().equals("rotation") || prop.func_177699_b() != EnumFacing.class) continue;
            IProperty facingProperty = prop;
            return (EnumFacing)state.func_177229_b(facingProperty);
        }
        return player.func_174811_aO().func_176734_d();
    }

    private IItemHandler getChestInventory(TileEntity te, EnumFacing front) {
        if (te instanceof TileEntityChest) {
            return ((TileEntityChest)te).getSingleChestHandler();
        }
        return (IItemHandler)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, front);
    }

    private boolean updateChest(ChestType upgrade, TileEntity te, EntityPlayer player, World world, BlockPos pos) {
        Block block = te.func_145838_q();
        if (te instanceof IMetalChest) {
            IBlockState state = this.createBlockState(block, upgrade);
            NBTTagCompound tag = te.func_189515_b(new NBTTagCompound());
            tag.func_74775_l("Inventory").func_74768_a("Size", upgrade.getInventorySize());
            tag.func_74778_a("ChestType", upgrade.toString());
            te.func_145839_a(tag);
            world.func_180501_a(pos, state, 3);
            return true;
        }
        boolean trapped = world.func_180495_p(pos).func_185897_m();
        EnumFacing front = this.getBlockFront(player, world, pos);
        IItemHandler inv = this.getChestInventory(te, front);
        block = UpgradeRegistry.getMetalChest((Item)this, block);
        IBlockState state = this.createBlockState(block, upgrade);
        world.func_175713_t(pos);
        world.func_175698_g(pos);
        world.func_175690_a(pos, block.createTileEntity(world, state));
        world.func_180501_a(pos, state, 3);
        IMetalChest chest = (IMetalChest)world.func_175625_s(pos);
        if (chest != null) {
            chest.setChestType(upgrade);
            chest.setTrapped(trapped);
            chest.setFront(front);
            chest.setInventory(inv);
            return true;
        }
        return false;
    }

    public EnumActionResult onItemUseFirst(EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        ItemStack stack;
        ChestUpgrade upgrade;
        if (world.field_72995_K || player.func_70093_af()) {
            return EnumActionResult.PASS;
        }
        TileEntity te = world.func_175625_s(pos);
        if (!this.canUpdateChest(te, (upgrade = (ChestUpgrade)ChestUpgrade.TIERS.get((stack = player.func_184586_b(hand)).func_77952_i())).getBase()) || !this.updateChest(upgrade.getUpgrade(), te, player, world, pos)) {
            return EnumActionResult.FAIL;
        }
        if (!player.field_71075_bZ.field_75098_d) {
            stack.func_190918_g(1);
        }
        player.field_70170_p.func_184133_a(null, player.func_180425_c(), SoundEvents.field_187692_g, SoundCategory.PLAYERS, 0.4f, 0.8f);
        return EnumActionResult.SUCCESS;
    }
}

