/*
 * Decompiled with CFR 0.152.
 */
package t145.metalchests.recipes;

import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.commons.lang3.text.WordUtils;
import t145.metalchests.api.consts.ChestType;
import t145.metalchests.api.consts.ChestUpgrade;
import t145.metalchests.api.consts.RegistryMC;
import t145.metalchests.api.objs.ItemsMC;
import thaumcraft.api.ThaumcraftApi;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.blocks.BlocksTC;
import thaumcraft.api.crafting.IArcaneRecipe;
import thaumcraft.api.crafting.ShapedArcaneRecipe;

public class RecipeHandler {
    private RecipeHandler() {
    }

    private static Object getChestBase(Block chest, Object base, ChestType type) {
        if (type.getIndex() == 0) {
            return base;
        }
        return new ItemStack(chest, 1, ((ChestType)((Object)ChestType.TIERS.get(type.getIndex() - 1))).ordinal());
    }

    private static String getOre(ChestType type, String postfix) {
        return String.format("chest%s%s", WordUtils.capitalize((String)type.func_176610_l()), postfix);
    }

    private static ResourceLocation getChestResource(ChestType type, String postfix) {
        return RegistryMC.getResource(String.format("recipe%s", WordUtils.capitalize((String)RecipeHandler.getOre(type, postfix))));
    }

    public static void registerChests(Object baseChest, Block metalChest, String postfix) {
        ChestType.TIERS.forEach(type -> {
            ItemStack result = new ItemStack(metalChest, 1, type.ordinal());
            GameRegistry.addShapedRecipe((ResourceLocation)RecipeHandler.getChestResource(type, ""), (ResourceLocation)RegistryMC.RECIPE_GROUP, (ItemStack)result, (Object[])new Object[]{"aaa", "aba", "aaa", Character.valueOf('a'), type.getOre(), Character.valueOf('b'), RecipeHandler.getChestBase(metalChest, baseChest, type)});
            OreDictionary.registerOre((String)"chest", (ItemStack)result);
            OreDictionary.registerOre((String)RecipeHandler.getOre(type, postfix), (ItemStack)result);
        });
    }

    @Optional.Method(modid="thaumcraft")
    public static void registerHungryChests(Object baseChest, Block metalChest, String postfix) {
        for (ChestType type : ChestType.TIERS) {
            ItemStack result = new ItemStack(metalChest, 1, type.ordinal());
            ThaumcraftApi.addArcaneCraftingRecipe((ResourceLocation)RecipeHandler.getChestResource(type, postfix), (IArcaneRecipe)new ShapedArcaneRecipe(RegistryMC.RECIPE_GROUP, "HUNGRYCHEST", 15, new AspectList().add(Aspect.EARTH, 1).add(Aspect.WATER, 1), result, new Object[]{"aaa", "aba", "aaa", Character.valueOf('a'), type.getOre(), Character.valueOf('b'), RecipeHandler.getChestBase(metalChest, baseChest, type)}));
            OreDictionary.registerOre((String)"chest", (ItemStack)result);
            OreDictionary.registerOre((String)RecipeHandler.getOre(type, postfix), (ItemStack)result);
        }
    }

    private static Object getUpgradeBase(Item upgrade, Object base, ChestUpgrade curr) {
        short meta = (short)curr.ordinal();
        if (curr.isForWood()) {
            if (meta == 0) {
                return base;
            }
            return new ItemStack(upgrade, 1, meta - 1);
        }
        ChestUpgrade prior = (ChestUpgrade)ChestUpgrade.TIERS.get(meta - 1);
        if (prior.getBase() == curr.getBase()) {
            return new ItemStack(upgrade, 1, meta - 1);
        }
        return curr.getBase().getOre();
    }

    private static ResourceLocation getUpgradeResource(ChestUpgrade type, String postfix) {
        return RegistryMC.getResource(String.format("recipeUpgrade%s%s", WordUtils.capitalize((String)type.func_176610_l()), postfix));
    }

    public static void registerUpgrades(Item upgrade, Object base, String postfix) {
        ChestUpgrade.TIERS.forEach(type -> GameRegistry.addShapedRecipe((ResourceLocation)RecipeHandler.getUpgradeResource(type, postfix), (ResourceLocation)RegistryMC.RECIPE_GROUP, (ItemStack)new ItemStack(upgrade, 1, type.ordinal()), (Object[])new Object[]{"aaa", "aaa", "baa", Character.valueOf('a'), type.getUpgrade().getOre(), Character.valueOf('b'), RecipeHandler.getUpgradeBase(upgrade, base, type)}));
    }

    @Optional.Method(modid="thaumcraft")
    public static void registerHungryUpgrades() {
        for (ChestUpgrade type : ChestUpgrade.TIERS) {
            ThaumcraftApi.addArcaneCraftingRecipe((ResourceLocation)RecipeHandler.getUpgradeResource(type, "Hungry"), (IArcaneRecipe)new ShapedArcaneRecipe(RegistryMC.RECIPE_GROUP, "HUNGRYCHEST", 15, new AspectList().add(Aspect.EARTH, 1).add(Aspect.WATER, 1), new ItemStack(ItemsMC.HUNGRY_CHEST_UPGRADE, 1, type.ordinal()), new Object[]{"aaa", "aaa", "baa", Character.valueOf('a'), type.getUpgrade().getOre(), Character.valueOf('b'), RecipeHandler.getUpgradeBase(ItemsMC.HUNGRY_CHEST_UPGRADE, BlocksTC.plankGreatwood, type)}));
        }
    }
}

