/*
 * Decompiled with CFR 0.152.
 */
package t145.metalchests.tiles;

import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import net.dries007.holoInventory.api.INamedItemHandler;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.apache.commons.lang3.StringUtils;
import t145.metalchests.api.chests.IMetalChest;
import t145.metalchests.api.config.ConfigMC;
import t145.metalchests.api.consts.ChestType;
import t145.metalchests.api.objs.ItemsMC;
import t145.tbone.lib.ChestAnimator;
import t145.tbone.lib.ChestHandler;
import vazkii.quark.api.IDropoffManager;

@Optional.InterfaceList(value={@Optional.Interface(modid="holoinventory", iface="net.dries007.holoInventory.api.INamedItemHandler", striprefs=true), @Optional.Interface(modid="quark", iface="vazkii.quark.api.IDropoffManager", striprefs=true)})
public class TileMetalChest
extends TileEntity
implements IMetalChest,
ITickable,
INamedItemHandler,
IDropoffManager {
    public ChestAnimator animator = new ChestAnimator(true);
    protected ChestType chestType;
    protected EnumFacing front;
    protected ChestHandler inventory;
    protected String customName = "";
    protected byte enchantLevel;
    protected boolean trapped;

    public TileMetalChest(ChestType chestType) {
        this.setChestType(chestType);
        this.setFront(EnumFacing.EAST);
        this.inventory = this.initInventory();
    }

    public TileMetalChest() {
        this(ChestType.IRON);
    }

    protected ChestHandler initInventory() {
        return new ChestHandler(this.chestType.getInventorySize());
    }

    public boolean shouldRefresh(World world, BlockPos pos, @Nonnull IBlockState oldState, @Nonnull IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(super.func_189517_E_());
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 0, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager manager, SPacketUpdateTileEntity packet) {
        this.handleUpdateTag(packet.func_148857_g());
    }

    @Override
    public ChestAnimator getChestAnimator() {
        return this.animator;
    }

    @Override
    public ChestType getChestType() {
        return this.chestType;
    }

    @Override
    public void setChestType(ChestType chestType) {
        this.chestType = chestType;
    }

    @Override
    public EnumFacing getFront() {
        return this.front;
    }

    @Override
    public void setFront(EnumFacing front) {
        this.front = front;
    }

    public String getCustomName() {
        return this.customName;
    }

    public void setCustomName(String customName) {
        this.customName = customName;
    }

    @Override
    public byte getEnchantLevel() {
        return this.enchantLevel;
    }

    @Override
    public void setEnchantLevel(byte enchantLevel) {
        this.enchantLevel = enchantLevel;
    }

    @Override
    public boolean isTrapped() {
        return this.trapped;
    }

    @Override
    public void setTrapped(boolean trapped) {
        this.trapped = trapped;
    }

    @Override
    public boolean canUpgradeUsing(Item upgrade) {
        return upgrade == ItemsMC.CHEST_UPGRADE;
    }

    public ItemStackHandler getInventory() {
        return this.inventory;
    }

    public boolean hasCapability(@Nonnull Capability<?> cap, EnumFacing side) {
        return cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(cap, side);
    }

    public <T> T getCapability(@Nonnull Capability<T> cap, EnumFacing side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.inventory);
        }
        return (T)super.getCapability(cap, side);
    }

    public void func_174889_b(EntityPlayer player) {
        this.animator.update(player, this.field_145850_b, this.field_174879_c, SoundEvents.field_187657_V, true, this.trapped);
    }

    public void func_174886_c(EntityPlayer player) {
        this.animator.update(player, this.field_145850_b, this.field_174879_c, SoundEvents.field_187651_T, false, this.trapped);
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.field_145850_b.func_175625_s(this.field_174879_c) == this && player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public void func_73660_a() {
        this.inventory.tick(this.field_145850_b, this.field_174879_c, this.func_145838_q());
        this.animator.tick(this.field_145850_b, this.field_174879_c);
    }

    @OverridingMethodsMustInvokeSuper
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        tag.func_74778_a("ChestType", this.chestType.toString());
        tag.func_74782_a("Inventory", (NBTBase)this.inventory.serializeNBT());
        tag.func_74778_a("Front", this.front.toString());
        tag.func_74778_a("CustomName", this.customName);
        tag.func_74774_a("EnchantLevel", this.enchantLevel);
        tag.func_74757_a("Trapped", this.trapped);
        return tag;
    }

    @OverridingMethodsMustInvokeSuper
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.setChestType(ChestType.valueOf(tag.func_74779_i("ChestType")));
        this.inventory.deserializeNBT(tag.func_74775_l("Inventory"));
        this.setFront(EnumFacing.func_176739_a((String)tag.func_74779_i("Front")));
        this.setCustomName(tag.func_74779_i("CustomName"));
        this.setEnchantLevel(tag.func_74771_c("EnchantLevel"));
        this.setTrapped(tag.func_74767_n("Trapped"));
    }

    public boolean func_145842_c(int event, int data) {
        return this.animator.receiveClientEvent(event, data);
    }

    public void func_145843_s() {
        this.func_145836_u();
        super.func_145843_s();
    }

    public String getTranslationKey() {
        return ConfigMC.archaicNaming ? "container.chest" : String.format("tile.%s:%s.%s.name", "metalchests", "metal_chest", this.chestType.func_176610_l());
    }

    public boolean func_145818_k_() {
        return !StringUtils.isEmpty((CharSequence)this.customName);
    }

    public String func_70005_c_() {
        return this.getTranslationKey();
    }

    public ITextComponent func_145748_c_() {
        return this.func_145818_k_() ? new TextComponentString(this.customName) : new TextComponentTranslation(this.getTranslationKey(), new Object[0]);
    }

    @Optional.Method(modid="holoinventory")
    public String getItemHandlerName() {
        return this.getTranslationKey();
    }

    @Optional.Method(modid="quark")
    public boolean acceptsDropoff(EntityPlayer player) {
        return true;
    }

    @Optional.Method(modid="quark")
    public IItemHandler getDropoffItemHandler(Supplier<IItemHandler> defaultSupplier) {
        return this.inventory;
    }
}

