/*
 * Decompiled with CFR 0.152.
 */
package t145.metalchests.tiles;

import javax.annotation.Nullable;
import net.blay09.mods.refinedrelocation.api.Capabilities;
import net.blay09.mods.refinedrelocation.api.filter.IRootFilter;
import net.blay09.mods.refinedrelocation.api.grid.ISortingInventory;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import t145.metalchests.api.config.ConfigMC;
import t145.metalchests.api.consts.ChestType;
import t145.metalchests.tiles.TileMetalChest;
import t145.tbone.lib.ChestHandler;

public class TileMetalSortingChest
extends TileMetalChest {
    protected final ISortingInventory sortingInventory = (ISortingInventory)Capabilities.getDefaultInstance((Capability)Capabilities.SORTING_INVENTORY);
    protected final IRootFilter rootFilter = (IRootFilter)Capabilities.getDefaultInstance((Capability)Capabilities.ROOT_FILTER);

    public TileMetalSortingChest(ChestType chestType) {
        super(chestType);
    }

    public TileMetalSortingChest() {
    }

    @Override
    protected ChestHandler initInventory() {
        return new ChestHandler(this.chestType.getInventorySize()){

            protected void onContentsChanged(int slot) {
                super.onContentsChanged(slot);
                TileMetalSortingChest.this.sortingInventory.onSlotChanged(slot);
            }
        };
    }

    public void onLoad() {
        super.onLoad();
        this.sortingInventory.onLoad((TileEntity)this);
    }

    @Override
    public void func_73660_a() {
        this.sortingInventory.onUpdate((TileEntity)this);
        super.func_73660_a();
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        this.sortingInventory.onInvalidate((TileEntity)this);
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        this.sortingInventory.onInvalidate((TileEntity)this);
    }

    @Override
    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || capability == Capabilities.NAME_TAGGABLE || Capabilities.isSortingGridCapability(capability) || Capabilities.isFilterCapability(capability) || super.hasCapability(capability, facing);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.inventory);
        }
        if (Capabilities.isSortingGridCapability(capability)) {
            return (T)Capabilities.SORTING_INVENTORY.cast((Object)this.sortingInventory);
        }
        if (Capabilities.isFilterCapability(capability)) {
            return (T)Capabilities.ROOT_FILTER.cast((Object)this.rootFilter);
        }
        return super.getCapability(capability, facing);
    }

    public static void fixRootFilterTag(NBTTagCompound compound) {
        if (compound.func_150299_b("RootFilter") == 9) {
            NBTTagList tagList = compound.func_150295_c("RootFilter", 10);
            compound.func_82580_o("RootFilter");
            NBTTagCompound rootFilter = new NBTTagCompound();
            rootFilter.func_74782_a("FilterList", (NBTBase)tagList);
            compound.func_74782_a("RootFilter", (NBTBase)rootFilter);
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.sortingInventory.deserializeNBT((NBTBase)compound.func_74775_l("SortingInventory"));
        TileMetalSortingChest.fixRootFilterTag(compound);
        this.rootFilter.deserializeNBT((NBTBase)compound.func_74775_l("RootFilter"));
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74782_a("SortingInventory", this.sortingInventory.serializeNBT());
        compound.func_74782_a("RootFilter", this.rootFilter.serializeNBT());
        return compound;
    }

    @Override
    public String getTranslationKey() {
        return ConfigMC.archaicNaming ? "container.refinedrelocation:sorting_chest" : String.format("tile.%s:%s.%s.name", "metalchests", "metal_sorting_chest", this.chestType.func_176610_l());
    }
}

