/*
 * Decompiled with CFR 0.152.
 */
package t145.tbone.core;

import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.ForgeVersion;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.ModContainer;
import t145.tbone.core.TBone;

class UpdateChecker {
    private final String modId;
    private final String modName;

    UpdateChecker(String modId, String modName) {
        this.modId = modId;
        this.modName = modName;
    }

    private ForgeVersion.CheckResult getResult() {
        return ForgeVersion.getResult((ModContainer)FMLCommonHandler.instance().findContainerFor((Object)this.modId));
    }

    public boolean hasUpdate() {
        ForgeVersion.CheckResult result = this.getResult();
        if (result.status == ForgeVersion.Status.PENDING) {
            TBone.LOG.warn("Cannot check for updates! Found status PENDING!");
            return false;
        }
        return result.status.isAnimated();
    }

    private String getLatestVersion() {
        return this.getResult().target.toString();
    }

    public ITextComponent getUpdateNotification() {
        ITextComponent prefix = new TextComponentTranslation(this.modName, new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.GREEN));
        ITextComponent base = new TextComponentTranslation("tbone.client.update", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.GOLD));
        TextComponentString postfix = new TextComponentString(String.format("%s%s%s!", TextFormatting.AQUA, this.getLatestVersion(), TextFormatting.GOLD));
        return prefix.func_150257_a(base).func_150257_a((ITextComponent)postfix);
    }
}

