/*
 * Decompiled with CFR 0.152.
 */
package t145.tbone.dispenser;

import net.minecraft.block.Block;
import net.minecraft.block.BlockDispenser;
import net.minecraft.block.BlockRailBase;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.dispenser.BehaviorDefaultDispenseItem;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public abstract class BehaviorDispenseMinecart
extends BehaviorDefaultDispenseItem {
    private final BehaviorDefaultDispenseItem dispenseBehavior = new BehaviorDefaultDispenseItem();

    public static void register(Item item, BehaviorDispenseMinecart behavior) {
        BlockDispenser.field_149943_a.func_82595_a((Object)item, (Object)behavior);
    }

    private BlockRailBase.EnumRailDirection getRailDirection(IBlockState state, World world, BlockPos pos) {
        Block block = state.func_177230_c();
        if (block instanceof BlockRailBase) {
            BlockRailBase rail = (BlockRailBase)block;
            return rail.getRailDirection((IBlockAccess)world, pos, state, null);
        }
        return BlockRailBase.EnumRailDirection.NORTH_SOUTH;
    }

    public abstract EntityMinecart getMinecartEntity(World var1, double var2, double var4, double var6, ItemStack var8);

    public EnumActionResult placeStack(EntityPlayer player, EnumHand hand, World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        if (!BlockRailBase.func_176563_d((IBlockState)state)) {
            return EnumActionResult.FAIL;
        }
        ItemStack stack = player.func_184586_b(hand);
        if (!world.field_72995_K) {
            double yOffset = 0.0;
            if (this.getRailDirection(state, world, pos).func_177018_c()) {
                yOffset = 0.5;
            }
            EntityMinecart cart = this.getMinecartEntity(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.0625 + yOffset, (double)pos.func_177952_p() + 0.5, stack);
            if (stack.func_82837_s()) {
                cart.func_96094_a(stack.func_82833_r());
            }
            world.func_72838_d((Entity)cart);
        }
        stack.func_190918_g(1);
        return EnumActionResult.SUCCESS;
    }

    public ItemStack func_82487_b(IBlockSource source, ItemStack stack) {
        EnumFacing front = (EnumFacing)source.func_189992_e().func_177229_b((IProperty)BlockDispenser.field_176441_a);
        BlockPos pos = source.func_180699_d().func_177972_a(front);
        World world = source.func_82618_k();
        IBlockState state = world.func_180495_p(pos);
        double yOffset = 0.0;
        if (BlockRailBase.func_176563_d((IBlockState)state)) {
            yOffset = this.getRailDirection(state, world, pos).func_177018_c() ? 0.6 : 0.1;
        } else {
            if (state.func_185904_a() != Material.field_151579_a || !BlockRailBase.func_176563_d((IBlockState)world.func_180495_p(pos.func_177977_b()))) {
                return this.dispenseBehavior.func_82482_a(source, stack);
            }
            yOffset -= front != EnumFacing.DOWN && this.getRailDirection(state, world, pos.func_177977_b()).func_177018_c() ? 0.4 : 0.9;
        }
        double xOffset = source.func_82615_a() + (double)front.func_82601_c() * 1.125;
        double zOffset = source.func_82616_c() + (double)front.func_82599_e() * 1.125;
        EntityMinecart cart = this.getMinecartEntity(world, xOffset, yOffset += Math.floor(source.func_82617_b()) + (double)front.func_96559_d(), zOffset, stack);
        if (stack.func_82837_s()) {
            cart.func_96094_a(stack.func_82833_r());
        }
        world.func_72838_d((Entity)cart);
        stack.func_190918_g(1);
        return stack;
    }

    protected void func_82485_a(IBlockSource source) {
        source.func_82618_k().func_175718_b(1000, source.func_180699_d(), 0);
    }
}

