/*
 * Decompiled with CFR 0.152.
 */
package t145.tbone.lib;

import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class ChestAnimator {
    public static final int EVENT_PLAYER_USED = -1;
    public static final int EVENT_CHEST_NOM = -2;
    public float lidAngle;
    public float prevLidAngle;
    public int numPlayersUsing;
    public final boolean updateBlock;

    public ChestAnimator(boolean updateBlock) {
        this.updateBlock = updateBlock;
    }

    public boolean isOpen() {
        return this.lidAngle > 0.0f;
    }

    public void update(EntityPlayer player, World world, BlockPos pos, SoundEvent sound, boolean opening, boolean trapped) {
        if (!player.func_175149_v()) {
            this.numPlayersUsing = opening ? MathHelper.func_76125_a((int)this.numPlayersUsing, (int)0, (int)this.numPlayersUsing) + 1 : --this.numPlayersUsing;
            world.func_184133_a(player, pos, sound, SoundCategory.BLOCKS, 0.5f, world.field_73012_v.nextFloat() * 0.1f + 0.9f);
            if (this.updateBlock) {
                Block block = world.func_180495_p(pos).func_177230_c();
                world.func_175641_c(pos, block, -1, this.numPlayersUsing);
                world.func_175685_c(pos, block, false);
                if (trapped) {
                    world.func_175685_c(pos.func_177977_b(), block, false);
                }
            }
        }
    }

    private float lerp(float a, float b, float max) {
        return a > b ? (a - b < max ? b : a - max) : (b - a < max ? b : a + max);
    }

    public void tick(World world, BlockPos pos) {
        if (!world.field_72995_K && this.updateBlock && (world.func_82737_E() + (long)pos.func_177958_n() + (long)pos.func_177956_o() + (long)pos.func_177952_p() & 0x1FL) == 0L) {
            world.func_175641_c(pos, world.func_180495_p(pos).func_177230_c(), -1, this.numPlayersUsing);
        }
        this.prevLidAngle = this.lidAngle;
        this.lidAngle = this.lerp(this.lidAngle, this.numPlayersUsing > 0 ? 1.0f : 0.0f, 0.1f);
    }

    public boolean receiveClientEvent(int event, int data) {
        switch (event) {
            case -1: {
                this.numPlayersUsing = data;
                return true;
            }
            case -2: {
                if (this.lidAngle < (float)data / 10.0f) {
                    this.lidAngle = (float)data / 10.0f;
                }
                return true;
            }
        }
        return false;
    }

    public float getLidAngle(float partialTicks) {
        double f = this.prevLidAngle + (this.lidAngle - this.prevLidAngle) * partialTicks;
        f = 1.0 - f;
        f = 1.0 - f * f * f;
        return (float)(-(f * 1.5707963267948966));
    }
}

