/*
 * Decompiled with CFR 0.152.
 */
package prospector.traverse.commands;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import prospector.traverse.config.TraverseConfig;

public class CommandFindBiome
extends CommandBase {
    public static BlockPos spiralOutwardsLookingForBiome(ICommandSender sender, World world, Biome biomeToFind, double startX, double startZ, int timeout) {
        double a = 16.0 / Math.sqrt(Math.PI);
        double b = 2.0 * Math.sqrt(Math.PI);
        double dist = 0.0;
        long start = System.currentTimeMillis();
        BlockPos.PooledMutableBlockPos pos = BlockPos.PooledMutableBlockPos.func_185346_s();
        int previous = 0;
        int i = 0;
        int n = 0;
        while (dist < 2.147483647E9) {
            if (System.currentTimeMillis() - start > (long)timeout) {
                return null;
            }
            double rootN = Math.sqrt(n);
            dist = a * rootN;
            double x = startX + dist * Math.sin(b * rootN);
            double z = startZ + dist * Math.cos(b * rootN);
            pos.func_189532_c(x, 0.0, z);
            if (sender instanceof EntityPlayer) {
                if (previous == 3) {
                    previous = 0;
                }
                String s = previous == 0 ? "." : (previous == 1 ? ".." : "...");
                ((EntityPlayer)sender).func_146105_b((ITextComponent)new TextComponentString("Scanning" + s), true);
                if (i == 1501) {
                    ++previous;
                    i = 0;
                }
                ++i;
            }
            if (world.func_180494_b((BlockPos)pos).equals(biomeToFind)) {
                pos.func_185344_t();
                if (sender instanceof EntityPlayer) {
                    ((EntityPlayer)sender).func_146105_b((ITextComponent)new TextComponentString("Found Biome"), true);
                }
                return new BlockPos((int)x, 0, (int)z);
            }
            ++n;
        }
        return null;
    }

    public String func_71517_b() {
        return "findbiome";
    }

    public String func_71518_a(ICommandSender sender) {
        return "/findbiome <biome>";
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
        if (args.length == 1) {
            ArrayList<String> strings = new ArrayList<String>();
            for (Biome b : ForgeRegistries.BIOMES.getValues()) {
                String s = b.getRegistryName().toString();
                if (!s.toLowerCase().contains(args[0].toLowerCase())) continue;
                strings.add(s);
            }
            return strings;
        }
        return Collections.emptyList();
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        Biome biome = null;
        if (args.length == 0) {
            sender.func_145747_a((ITextComponent)new TextComponentString("No biome specified"));
            return;
        }
        for (Biome b : ForgeRegistries.BIOMES.getValues()) {
            String name = b.getRegistryName().toString().replaceAll(" ", "_").toLowerCase();
            if (!args[0].equalsIgnoreCase(name)) continue;
            biome = b;
        }
        if (biome == null) {
            sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "Error! Biome '" + args[0] + "' cannot be found!"));
            return;
        }
        long start = System.currentTimeMillis();
        Biome finalBiome = biome;
        new Thread(() -> {
            BlockPos pos = CommandFindBiome.spiralOutwardsLookingForBiome(sender, sender.func_130014_f_(), finalBiome, sender.func_180425_c().func_177958_n(), sender.func_180425_c().func_177952_p(), TraverseConfig.findBiomeCommandTimeout);
            if (pos == null) {
                server.func_152344_a(() -> sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "Error! Biome '" + args[0] + "' could not be found after " + TextFormatting.GRAY + TraverseConfig.findBiomeCommandTimeout + "ms" + TextFormatting.RED + ".")));
                return;
            }
            if (sender instanceof EntityPlayerMP) {
                server.func_152344_a(() -> {
                    EntityPlayerMP playerMP = (EntityPlayerMP)sender;
                    playerMP.field_71135_a.func_147364_a((double)pos.func_177958_n(), 150.0, (double)pos.func_177952_p(), 0.0f, 0.0f);
                    sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.WHITE + "Found '" + finalBiome.getRegistryName().toString() + "' Biome! " + TextFormatting.GRAY + "(" + (System.currentTimeMillis() - start) + "ms)"));
                });
                return;
            }
            server.func_152344_a(() -> sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "Error! An unknown error occurred.")));
        }, "Biome Finder - Traverse").start();
    }
}

