/*
 * Decompiled with CFR 0.152.
 */
package vazkii.morphtool;

import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import vazkii.arl.recipe.ModRecipe;
import vazkii.morphtool.ConfigHandler;
import vazkii.morphtool.ModItems;
import vazkii.morphtool.MorphingHandler;

public class AttachementRecipe
extends ModRecipe {
    public AttachementRecipe() {
        super(new ResourceLocation("morphtool", "attachment"));
    }

    public boolean func_77569_a(InventoryCrafting var1, World var2) {
        boolean foundTool = false;
        boolean foundTarget = false;
        for (int i = 0; i < var1.func_70302_i_(); ++i) {
            ItemStack stack = var1.func_70301_a(i);
            if (stack.func_190926_b()) continue;
            if (this.isTarget(stack)) {
                if (foundTarget) {
                    return false;
                }
                foundTarget = true;
                continue;
            }
            if (stack.func_77973_b() == ModItems.tool) {
                if (foundTool) {
                    return false;
                }
                foundTool = true;
                continue;
            }
            return false;
        }
        return foundTool && foundTarget;
    }

    public ItemStack func_77572_b(InventoryCrafting var1) {
        String mod;
        NBTTagCompound morphData;
        ItemStack tool = ItemStack.field_190927_a;
        ItemStack target = ItemStack.field_190927_a;
        for (int i = 0; i < var1.func_70302_i_(); ++i) {
            ItemStack stack = var1.func_70301_a(i);
            if (stack.func_190926_b()) continue;
            if (stack.func_77973_b() == ModItems.tool) {
                tool = stack;
                continue;
            }
            target = stack;
        }
        ItemStack copy = tool.func_77946_l();
        NBTTagCompound cmp = copy.func_77978_p();
        if (cmp == null) {
            cmp = new NBTTagCompound();
            copy.func_77982_d(cmp);
        }
        if (!cmp.func_74764_b("morphtool:data")) {
            cmp.func_74782_a("morphtool:data", (NBTBase)new NBTTagCompound());
        }
        if ((morphData = cmp.func_74775_l("morphtool:data")).func_74764_b(mod = MorphingHandler.getModFromStack(target))) {
            return ItemStack.field_190927_a;
        }
        NBTTagCompound modCmp = new NBTTagCompound();
        target.func_77955_b(modCmp);
        morphData.func_74782_a(mod, (NBTBase)modCmp);
        return copy;
    }

    public boolean func_194133_a(int width, int height) {
        return false;
    }

    public boolean isTarget(ItemStack stack) {
        if (stack.func_190926_b() || MorphingHandler.isMorphTool(stack)) {
            return false;
        }
        String mod = MorphingHandler.getModFromStack(stack);
        if (mod.equals("minecraft")) {
            return false;
        }
        if (ConfigHandler.allItems) {
            return true;
        }
        if (ConfigHandler.blacklistedMods.contains(mod)) {
            return false;
        }
        ResourceLocation registryNameRL = stack.func_77973_b().getRegistryName();
        String registryName = registryNameRL.toString();
        if (ConfigHandler.whitelistedItems.contains(registryName) || ConfigHandler.whitelistedItems.contains(registryName + ":" + stack.func_77952_i())) {
            return true;
        }
        String itemName = registryNameRL.func_110623_a().toLowerCase();
        for (String s : ConfigHandler.whitelistedNames) {
            if (!itemName.contains(s.toLowerCase())) continue;
            return true;
        }
        return false;
    }

    public ItemStack func_77571_b() {
        return ItemStack.field_190927_a;
    }

    public NonNullList<ItemStack> func_179532_b(InventoryCrafting inv) {
        return NonNullList.func_191197_a((int)inv.func_70302_i_(), (Object)ItemStack.field_190927_a);
    }
}

