/*
 * Decompiled with CFR 0.152.
 */
package technicianlp.reauth.mojangfix;

import java.lang.reflect.Field;
import java.security.NoSuchAlgorithmException;
import java.security.Permission;
import java.security.PermissionCollection;
import java.util.Map;
import javax.crypto.Cipher;
import technicianlp.reauth.ReAuth;
import technicianlp.reauth.crypto.CryptoException;
import technicianlp.reauth.mojangfix.MojangJavaFix;
import technicianlp.reauth.util.ReflectionUtils;

final class JceWorkaround {
    JceWorkaround() {
    }

    static void ensureUnlimitedCryptography() {
        try {
            if (Cipher.getMaxAllowedKeyLength("AES") != Integer.MAX_VALUE) {
                ReAuth.log.warn("Cryptography is restricted in this Java installation");
                if (!MojangJavaFix.java8) {
                    ReAuth.log.warn("Cryptography is likely deliberately restricted!");
                }
                JceWorkaround.removeCryptographyRestrictions();
                if (Cipher.getMaxAllowedKeyLength("AES") != Integer.MAX_VALUE) {
                    ReAuth.log.error("Failed to remove cryptography restriction");
                } else {
                    ReAuth.log.info("Cryptography restriction removed successfully");
                }
            }
        }
        catch (NoSuchAlgorithmException e) {
            throw new CryptoException("AES unavailable", e);
        }
    }

    private static void removeCryptographyRestrictions() {
        try {
            Class<?> jceSecurity = Class.forName("javax.crypto.JceSecurity");
            Field isRestricted = ReflectionUtils.findField(jceSecurity, "isRestricted");
            ReflectionUtils.unlockFinalField(isRestricted);
            Field defaultPolicy = ReflectionUtils.findField(jceSecurity, "defaultPolicy");
            Class<?> cryptoPermissions = Class.forName("javax.crypto.CryptoPermissions");
            Field perms = ReflectionUtils.findField(cryptoPermissions, "perms");
            Class<?> cryptoAllPermission = Class.forName("javax.crypto.CryptoAllPermission");
            Field instance = ReflectionUtils.findField(cryptoAllPermission, "INSTANCE");
            ReflectionUtils.setField(isRestricted, null, false);
            PermissionCollection permissionCollection = (PermissionCollection)ReflectionUtils.getField(defaultPolicy, null);
            ((Map)ReflectionUtils.getField(perms, permissionCollection)).clear();
            permissionCollection.add((Permission)ReflectionUtils.getField(instance, null));
        }
        catch (Exception e) {
            ReAuth.log.error("Exception removing cryptography restrictions", (Throwable)e);
        }
    }
}

