/*
 * Decompiled with CFR 0.152.
 */
package tonius.simplyjetpacks.crafting;

import javax.annotation.Nonnull;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import tonius.simplyjetpacks.capability.IEnergyContainerItem;
import tonius.simplyjetpacks.item.ItemFluxpack;
import tonius.simplyjetpacks.item.ItemJetpack;
import tonius.simplyjetpacks.proxy.CommonProxy;
import tonius.simplyjetpacks.setup.ParticleType;
import tonius.simplyjetpacks.util.NBTHelper;

public class UpgradingRecipeShaped
extends ShapedOreRecipe {
    private final IEnergyContainerItem resultItem;
    private final int resultMeta;
    private static int j = 0;

    public UpgradingRecipeShaped(ItemStack result, Object ... recipe) {
        super(null, result, recipe);
        this.setRegistryName("simplyjetpacks", "upgradeRecipeShaped" + j);
        ++j;
        this.resultItem = (IEnergyContainerItem)result.func_77973_b();
        this.resultMeta = result.func_77952_i();
        result.func_77986_q();
    }

    @Nonnull
    public ItemStack func_77572_b(InventoryCrafting inventoryCrafting) {
        int addedEnergy = 0;
        ParticleType particleType = null;
        NBTTagCompound tags = null;
        for (int i = 0; i < inventoryCrafting.func_70302_i_(); ++i) {
            ItemStack slotStack = inventoryCrafting.func_70301_a(i);
            slotStack.func_77973_b();
            if (slotStack.func_77973_b() instanceof ItemJetpack || slotStack.func_77973_b() instanceof ItemFluxpack) {
                tags = NBTHelper.getTagCompound(slotStack).func_74737_b();
            }
            if (slotStack.func_77973_b() instanceof IEnergyContainerItem) {
                addedEnergy += ((IEnergyContainerItem)slotStack.func_77973_b()).getEnergyStored(slotStack);
                continue;
            }
            if (!OreDictionary.containsMatch((boolean)false, CommonProxy.oresListParticles, (ItemStack[])new ItemStack[]{slotStack})) continue;
            particleType = ParticleType.values()[slotStack.func_77952_i()];
        }
        ItemStack result = new ItemStack((Item)this.resultItem, 1, this.resultMeta);
        if (tags != null) {
            result.func_77982_d(tags);
        }
        NBTHelper.setInt(result, "Energy", Math.min(addedEnergy, this.resultItem.getMaxEnergyStored(result)));
        if (this.resultItem instanceof ItemJetpack && particleType != null) {
            ((ItemJetpack)this.resultItem).setParticleType(result, particleType);
        }
        return result;
    }
}

